/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.images.apng;

import com.jpexs.images.apng.Png;
import com.jpexs.images.apng.chunks.Actl;
import com.jpexs.images.apng.chunks.Chunk;
import com.jpexs.images.apng.chunks.Fctl;
import com.jpexs.images.apng.chunks.Fdat;
import com.jpexs.images.apng.chunks.Idat;
import com.jpexs.images.apng.chunks.Iend;
import com.jpexs.images.apng.chunks.Ihdr;
import com.jpexs.images.apng.data.AnimatedPngData;
import com.jpexs.images.apng.data.AnimationFrameData;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class AnimatedPngDecoder {
    public static AnimatedPngData decode(InputStream is) throws IOException {
        ArrayList<AnimationFrameData> frames = new ArrayList<AnimationFrameData>();
        Png png = new Png(is);
        int width = 0;
        int height = 0;
        int numPlays = 0;
        Ihdr hdr = null;
        Actl actl = null;
        Fctl fctl = null;
        ArrayList<Chunk> otherChunks = new ArrayList<Chunk>();
        BufferedImage outputBuffer = null;
        Idat idat = null;
        for (Chunk chunk : png.getChunks()) {
            if (chunk instanceof Ihdr) {
                hdr = (Ihdr)chunk;
                outputBuffer = new BufferedImage((int)hdr.getWidth(), (int)hdr.getHeight(), 2);
                Graphics g = outputBuffer.getGraphics();
                g.setColor(new Color(0, 0, 0, 0));
                g.fillRect(0, 0, outputBuffer.getWidth(), outputBuffer.getHeight());
                width = (int)hdr.getWidth();
                height = (int)hdr.getHeight();
                continue;
            }
            if (chunk instanceof Idat) {
                idat = (Idat)chunk;
                continue;
            }
            if (chunk instanceof Fctl) {
                fctl = (Fctl)chunk;
                continue;
            }
            if (chunk instanceof Fdat) {
                Fdat fdat = (Fdat)chunk;
                Png outPng = new Png();
                outPng.addChunk(new Ihdr(fctl.getWidth(), fctl.getHeight(), hdr.getBitDepth(), hdr.getColorType(), hdr.getCompressionMethod(), hdr.getFilterMethod(), hdr.getInterlaceMethod()));
                outPng.addAllChunks(otherChunks);
                outPng.addChunk(new Idat(fdat.getFrameData()));
                outPng.addChunk(new Iend());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                outPng.writeTo(baos);
                BufferedImage subFrame = ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
                BufferedImage newImage = new BufferedImage((int)hdr.getWidth(), (int)hdr.getHeight(), 2);
                Graphics2D g = newImage.createGraphics();
                g.setComposite(AlphaComposite.Src);
                g.drawImage((Image)outputBuffer, 0, 0, null);
                g.setComposite(fctl.getBlendOp() == 0 ? AlphaComposite.Src : AlphaComposite.SrcOver);
                g.drawImage(subFrame, (int)fctl.getxOffset(), (int)fctl.getyOffset(), (int)fctl.getxOffset() + (int)fctl.getWidth(), (int)fctl.getyOffset() + (int)fctl.getHeight(), 0, 0, (int)fctl.getWidth(), (int)fctl.getHeight(), null);
                switch (fctl.getDisposeOp()) {
                    case 0: {
                        outputBuffer = newImage;
                        break;
                    }
                    case 1: {
                        outputBuffer = new BufferedImage((int)hdr.getWidth(), (int)hdr.getHeight(), 2);
                        Graphics2D g2 = outputBuffer.createGraphics();
                        g2.setComposite(AlphaComposite.Src);
                        g2.setColor(new Color(0, 0, 0, 0));
                        g2.fillRect(0, 0, outputBuffer.getWidth(), outputBuffer.getHeight());
                        break;
                    }
                }
                frames.add(new AnimationFrameData(newImage, fctl.getDelayNum(), fctl.getDelayDen()));
                fctl = null;
                continue;
            }
            if (chunk instanceof Iend) break;
            if (chunk instanceof Actl) {
                actl = (Actl)chunk;
                numPlays = (int)actl.getNumPlays();
                continue;
            }
            otherChunks.add(chunk);
        }
        BufferedImage backupImage = null;
        if (frames.isEmpty()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            png.writeTo(baos);
            backupImage = ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
        } else if (idat != null && hdr != null) {
            Png newPng = new Png();
            newPng.addChunk(hdr);
            newPng.addAllChunks(otherChunks);
            newPng.addChunk(idat);
            newPng.addChunk(new Iend());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            newPng.writeTo(baos);
            backupImage = ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
        }
        return new AnimatedPngData(width, height, numPlays, backupImage, frames);
    }
}

