/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.images.apng;

import com.jpexs.images.apng.Png;
import com.jpexs.images.apng.chunks.Actl;
import com.jpexs.images.apng.chunks.Chunk;
import com.jpexs.images.apng.chunks.Fctl;
import com.jpexs.images.apng.chunks.Fdat;
import com.jpexs.images.apng.chunks.Idat;
import com.jpexs.images.apng.chunks.Iend;
import com.jpexs.images.apng.chunks.Ihdr;
import com.jpexs.images.apng.chunks.Text;
import com.jpexs.images.apng.data.AnimatedPngData;
import com.jpexs.images.apng.data.AnimationFrameData;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class AnimatedPngEncoder {
    public static void encode(AnimatedPngData data, OutputStream os) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedImage backupImage = data.getBackupImage();
        if (backupImage == null && data.hasFrames()) {
            backupImage = data.getFrame(0).getImage();
        }
        ImageIO.write((RenderedImage)backupImage, "PNG", baos);
        byte[] backupImageData = baos.toByteArray();
        Png backupPng = new Png(new ByteArrayInputStream(backupImageData));
        ArrayList<Chunk> targetChunks = new ArrayList<Chunk>();
        targetChunks.addAll(backupPng.getChunks());
        if (data.hasFrames()) {
            long sequenceNumber = 0L;
            int frame = 0;
            for (int i = 0; i < targetChunks.size(); ++i) {
                Chunk chunk = (Chunk)targetChunks.get(i);
                if (chunk instanceof Ihdr) {
                    targetChunks.add(i + 1, new Actl(data.getFrameCount(), data.getNumPlays()));
                }
                if (chunk instanceof Idat) {
                    AnimationFrameData fdata = data.getFrame(frame);
                    targetChunks.add(i, new Fctl(sequenceNumber, data.getWidth(), data.getHeight(), 0L, 0L, fdata.getDelayNumerator(), fdata.getDelayDenominator(), 1, 0));
                    ++frame;
                    ++sequenceNumber;
                    i += 2;
                    while (frame < data.getFrameCount()) {
                        fdata = data.getFrame(frame);
                        targetChunks.add(i, new Fctl(sequenceNumber, data.getWidth(), data.getHeight(), 0L, 0L, fdata.getDelayNumerator(), fdata.getDelayDenominator(), 1, 0));
                        ++sequenceNumber;
                        ++i;
                        baos = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)fdata.getImage(), "PNG", baos);
                        Png framePng = new Png(new ByteArrayInputStream(baos.toByteArray()));
                        for (int j = 0; j < framePng.getChunkCount(); ++j) {
                            if (!(framePng.getChunk(j) instanceof Idat)) continue;
                            targetChunks.add(i, new Fdat(sequenceNumber, framePng.getChunk(j).getData()));
                            ++sequenceNumber;
                            ++i;
                        }
                        ++frame;
                    }
                    --i;
                    continue;
                }
                if (!(chunk instanceof Iend)) continue;
                targetChunks.add(i, new Text("Software", "jpexs-apng"));
                break;
            }
        }
        Png targetPng = new Png(targetChunks);
        targetPng.writeTo(os);
    }
}

