/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.images.apng;

public class Crc {
    private static long[] crcTable = new long[256];
    private static boolean crcTableComputed = false;

    private static void makeCrcTable() {
        for (int n = 0; n < 256; ++n) {
            long c = n;
            for (int k = 0; k < 8; ++k) {
                if ((c & 1L) > 0L) {
                    c = 0xEDB88320L ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            Crc.crcTable[n] = c;
        }
        crcTableComputed = true;
    }

    private static long updateCrc(long crc, byte[] buf) {
        long c = crc;
        if (!crcTableComputed) {
            Crc.makeCrcTable();
        }
        for (int n = 0; n < buf.length; ++n) {
            c = crcTable[(int)((c ^ (long)(buf[n] & 0xFF)) & 0xFFL)] ^ c >>> 8;
        }
        return c;
    }

    public static long calculate(byte[] ... data) {
        long ret = 0xFFFFFFFFL;
        for (byte[] dataPart : data) {
            ret = Crc.updateCrc(ret, dataPart);
        }
        ret ^= 0xFFFFFFFFL;
        return ret &= 0xFFFFFFFFL;
    }
}

