/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.images.apng;

import com.jpexs.images.apng.PngInputStream;
import com.jpexs.images.apng.PngOutputStream;
import com.jpexs.images.apng.chunks.Chunk;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Png {
    public static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private List<Chunk> chunks = new ArrayList<Chunk>();

    public Png() {
    }

    public Png(List<Chunk> chunks) {
        this.chunks = new ArrayList<Chunk>(chunks);
    }

    public Png(InputStream is) throws IOException {
        PngInputStream pis = new PngInputStream(is);
        byte[] signature = pis.readBytes(8);
        if (!Arrays.equals(signature, SIGNATURE)) {
            throw new IOException("Invalid PNG signature");
        }
        this.chunks = pis.readChunkList();
    }

    public void writeTo(OutputStream os) throws IOException {
        PngOutputStream pos = new PngOutputStream(os);
        pos.write(SIGNATURE);
        for (Chunk chunk : this.chunks) {
            pos.writeChunk(chunk);
        }
    }

    public static void dumpPng(InputStream is) throws IOException {
        Png png = new Png(is);
        for (Chunk chunk : png.chunks) {
            System.out.println(chunk.toString());
        }
    }

    public List<Chunk> getChunks() {
        return new ArrayList<Chunk>(this.chunks);
    }

    public void setChunks(List<Chunk> chunks) {
        this.chunks = new ArrayList<Chunk>(chunks);
    }

    public void addChunk(Chunk chunk) {
        this.chunks.add(chunk);
    }

    public void addAllChunks(Collection<? extends Chunk> chunk) {
        this.chunks.addAll(chunk);
    }

    public void addAllChunks(int index, Collection<? extends Chunk> chunk) {
        this.chunks.addAll(index, chunk);
    }

    public void addChunk(int index, Chunk chunk) {
        this.chunks.add(index, chunk);
    }

    public Chunk getChunk(int index) {
        return this.chunks.get(index);
    }

    public Chunk removeChunk(int index) {
        return this.chunks.remove(index);
    }

    public void clearChunks() {
        this.chunks.clear();
    }

    public int getChunkCount() {
        return this.chunks.size();
    }
}

