/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.images.apng;

import com.jpexs.images.apng.Crc;
import com.jpexs.images.apng.chunks.Chunk;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class PngOutputStream
extends OutputStream {
    private final OutputStream os;

    public PngOutputStream(OutputStream os) {
        this.os = os;
    }

    public void writeUnsignedInt(long val) throws IOException {
        this.os.write((int)(val >> 24 & 0xFFL));
        this.os.write((int)(val >> 16 & 0xFFL));
        this.os.write((int)(val >> 8 & 0xFFL));
        this.os.write((int)(val & 0xFFL));
    }

    public void writeUnsignedShort(int val) throws IOException {
        this.os.write(val >> 8 & 0xFF);
        this.os.write(val & 0xFF);
    }

    public void writeUnsignedByte(int val) throws IOException {
        this.os.write(val);
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    public void writeChunk(Chunk chunk) throws IOException {
        byte[] dataBytes = chunk.getData();
        this.writeUnsignedInt(dataBytes.length);
        byte[] typeBytes = chunk.getType().getBytes(StandardCharsets.US_ASCII);
        this.write(typeBytes);
        this.write(dataBytes);
        this.writeUnsignedInt(Crc.calculate(typeBytes, dataBytes));
    }
}

