/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.images.apng.chunks;

import com.jpexs.images.apng.PngInputStream;
import com.jpexs.images.apng.PngOutputStream;
import com.jpexs.images.apng.chunks.Chunk;
import java.io.IOException;

public class Fctl
extends Chunk {
    public static final String TYPE = "fcTL";
    public static final int DISPOSE_OP_NONE = 0;
    public static final int DISPOSE_OP_BACKGROUND = 1;
    public static final int DISPOSE_OP_PREVIOUS = 2;
    public static final int BLEND_OP_SOURCE = 0;
    public static final int BLEND_OP_OVER = 1;
    private long sequenceNumber;
    private long width;
    private long height;
    private long xOffset;
    private long yOffset;
    private int delayNum;
    private int delayDen;
    private int disposeOp;
    private int blendOp;

    public Fctl(byte[] data) {
        super(TYPE, data);
    }

    @Override
    public void parseData(PngInputStream pis) throws IOException {
        long sequenceNumber = pis.readUnsignedInt();
        long width = pis.readUnsignedInt();
        long height = pis.readUnsignedInt();
        long xOffset = pis.readUnsignedInt();
        long yOffset = pis.readUnsignedInt();
        int delayNum = pis.readUnsignedShort();
        int delayDen = pis.readUnsignedShort();
        int disposeOp = pis.readUnsignedByte();
        int blendOp = pis.readUnsignedByte();
        this.create(sequenceNumber, width, height, xOffset, yOffset, delayNum, delayDen, disposeOp, blendOp);
    }

    @Override
    public void writeData(PngOutputStream os) throws IOException {
        os.writeUnsignedInt(this.sequenceNumber);
        os.writeUnsignedInt(this.width);
        os.writeUnsignedInt(this.height);
        os.writeUnsignedInt(this.xOffset);
        os.writeUnsignedInt(this.yOffset);
        os.writeUnsignedShort(this.delayNum);
        os.writeUnsignedShort(this.delayDen);
        os.writeUnsignedByte(this.disposeOp);
        os.writeUnsignedByte(this.blendOp);
    }

    public Fctl(long sequenceNumber, long width, long height, long xOffset, long yOffset, int delayNum, int delayDen, int disposeOp, int blendOp) {
        super(TYPE);
        this.sequenceNumber = sequenceNumber;
        this.width = width;
        this.height = height;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.delayNum = delayNum;
        this.delayDen = delayDen;
        this.disposeOp = disposeOp;
        this.blendOp = blendOp;
        this.create(sequenceNumber, width, height, xOffset, yOffset, delayNum, delayDen, disposeOp, blendOp);
    }

    private void create(long sequenceNumber, long width, long height, long xOffset, long yOffset, int delayNum, int delayDen, int disposeOp, int blendOp) {
        if (width <= 0L) {
            throw new IllegalArgumentException("Invalid width " + width);
        }
        if (height <= 0L) {
            throw new IllegalArgumentException("Invalid height " + height);
        }
        if (disposeOp > 2) {
            throw new IllegalArgumentException("Invalid disposeOp " + disposeOp);
        }
        if (blendOp > 1) {
            throw new IllegalArgumentException("Invalid blendOp " + blendOp);
        }
        this.sequenceNumber = sequenceNumber;
        this.width = width;
        this.height = height;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.delayNum = delayNum;
        this.delayDen = delayDen;
        this.disposeOp = disposeOp;
        this.blendOp = blendOp;
    }

    @Override
    public String toString() {
        return "[fcTL sequenceNumber=" + this.sequenceNumber + " width=" + this.width + " height=" + this.height + " xOffset=" + this.xOffset + " yOffset=" + this.yOffset + " delayNum=" + this.delayNum + " delayDen=" + this.delayDen + " disposeOp=" + this.disposeOp + " blendOp=" + this.blendOp + "]";
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public long getWidth() {
        return this.width;
    }

    public void setWidth(long width) {
        this.width = width;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public long getxOffset() {
        return this.xOffset;
    }

    public void setxOffset(long xOffset) {
        this.xOffset = xOffset;
    }

    public long getyOffset() {
        return this.yOffset;
    }

    public void setyOffset(long yOffset) {
        this.yOffset = yOffset;
    }

    public int getDelayNum() {
        return this.delayNum;
    }

    public void setDelayNum(int delayNum) {
        this.delayNum = delayNum;
    }

    public int getDelayDen() {
        return this.delayDen;
    }

    public void setDelayDen(int delayDen) {
        this.delayDen = delayDen;
    }

    public int getDisposeOp() {
        return this.disposeOp;
    }

    public void setDisposeOp(int disposeOp) {
        this.disposeOp = disposeOp;
    }

    public int getBlendOp() {
        return this.blendOp;
    }

    public void setBlendOp(int blendOp) {
        this.blendOp = blendOp;
    }
}

