/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.images.apng.chunks;

import com.jpexs.images.apng.PngInputStream;
import com.jpexs.images.apng.PngOutputStream;
import com.jpexs.images.apng.chunks.Chunk;
import java.io.IOException;

public class Fdat
extends Chunk {
    public static final String TYPE = "fdAT";
    private long sequenceNumber;
    private byte[] frameData;

    public Fdat(byte[] data) {
        super(TYPE, data);
    }

    public Fdat(long sequenceNumber, byte[] frameData) {
        super(TYPE);
        this.create(sequenceNumber, frameData);
    }

    private void create(long sequenceNumber, byte[] frameData) {
        this.sequenceNumber = sequenceNumber;
        this.frameData = frameData;
    }

    @Override
    public void parseData(PngInputStream pis) throws IOException {
        long sequenceNumber = pis.readUnsignedInt();
        byte[] frameData = pis.readBytes(pis.available());
        this.create(sequenceNumber, frameData);
    }

    @Override
    public void writeData(PngOutputStream os) throws IOException {
        os.writeUnsignedInt(this.sequenceNumber);
        os.write(this.frameData);
    }

    @Override
    public String toString() {
        return "[fdAT sequenceNumber=" + this.sequenceNumber + " frameData.length=" + this.frameData.length + "]";
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public byte[] getFrameData() {
        return this.frameData;
    }

    public void setFrameData(byte[] frameData) {
        this.frameData = frameData;
    }
}

