/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.images.apng.chunks;

import com.jpexs.images.apng.PngInputStream;
import com.jpexs.images.apng.PngOutputStream;
import com.jpexs.images.apng.chunks.Chunk;
import java.io.IOException;

public class Trns
extends Chunk {
    public static final String TYPE = "tRNS";
    private byte[] transparencyData;

    public Trns(byte[] data) {
        super(TYPE, data);
        this.create(this.transparencyData);
    }

    @Override
    public void parseData(PngInputStream pis) throws IOException {
        byte[] transparencyData = pis.readBytes(pis.available());
        this.create(transparencyData);
    }

    @Override
    public void writeData(PngOutputStream os) throws IOException {
        os.write(this.transparencyData);
    }

    private void create(byte[] transparencyData) {
        this.transparencyData = transparencyData;
    }

    public byte[] getTransparencyData() {
        return this.transparencyData;
    }

    public void setTransparencyData(byte[] transparencyData) {
        this.transparencyData = transparencyData;
    }

    @Override
    public String toString() {
        return "[tRNS dataLength=" + this.transparencyData.length + "]";
    }
}

