/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.tags.DefineEditTextTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.StaticTextTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.dynamictext.TextStyle;
import com.jpexs.decompiler.flash.tags.text.xml.XmlException;
import com.jpexs.decompiler.flash.tags.text.xml.XmlLexer;
import com.jpexs.decompiler.flash.tags.text.xml.XmlParsedSymbol;
import com.jpexs.decompiler.flash.tags.text.xml.XmlSymbolType;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import java.awt.Font;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class FontNormalizer {
    public void normalizeFonts(SWF swf) {
        this.normalizeFonts(swf, true, new LinkedHashMap<Integer, FontTag>(), new LinkedHashMap<Integer, TextTag>());
    }

    public void normalizeFonts(SWF swf, Map<Integer, FontTag> outFonts, Map<Integer, TextTag> outTexts) {
        this.normalizeFonts(swf, false, outFonts, outTexts);
    }

    public void normalizeFonts(SWF swf, boolean inPlace, Map<Integer, FontTag> outFonts, Map<Integer, TextTag> outTexts) {
        Map<Integer, CharacterTag> characters = swf.getCharacters(!inPlace);
        LinkedHashMap<Integer, TextTag> texts = new LinkedHashMap<Integer, TextTag>();
        for (int characterId : characters.keySet()) {
            CharacterTag character = characters.get(characterId);
            if (!(character instanceof TextTag)) continue;
            texts.put(characterId, (TextTag)character);
        }
        LinkedHashSet<Integer> invertedFontIds = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> notInvertedFontIds = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> fontIds = new LinkedHashSet<Integer>();
        for (TextTag text : texts.values()) {
            if (text instanceof DefineEditTextTag) {
                DefineEditTextTag detext = (DefineEditTextTag)text;
                fontIds.addAll(this.getDefineEditTextFonts(detext));
            }
            if (!(text instanceof StaticTextTag)) continue;
            StaticTextTag stext = (StaticTextTag)text;
            boolean inverted = false;
            if (stext.textMatrix != null && stext.textMatrix.scaleY < 0.0f) {
                inverted = true;
            }
            for (TEXTRECORD rec : stext.textRecords) {
                if (!rec.styleFlagsHasFont) continue;
                if (inverted) {
                    invertedFontIds.add(rec.fontId);
                } else {
                    notInvertedFontIds.add(rec.fontId);
                }
                fontIds.add(rec.fontId);
            }
        }
        LinkedHashMap<Integer, Double> fontNewScale = new LinkedHashMap<Integer, Double>();
        Iterator<Object> iterator = fontIds.iterator();
        while (iterator.hasNext()) {
            FontTag font2;
            CharacterTag fontCharacter;
            int fontId = (Integer)iterator.next();
            if (notInvertedFontIds.contains(fontId)) {
                invertedFontIds.remove(fontId);
            }
            if ((fontCharacter = characters.get(fontId)) == null || !(fontCharacter instanceof FontTag)) continue;
            FontTag font = (FontTag)fontCharacter;
            boolean willModify = false;
            if (invertedFontIds.contains(fontId)) {
                willModify = true;
            }
            double newScale = 1.0;
            String systemFont = font.getSystemFontName();
            List<SHAPE> shapes1 = font.getGlyphShapeTable();
            Double h = null;
            Double systemH = null;
            double sumH = 0.0;
            for (int i = 0; i < shapes1.size(); ++i) {
                RECT b = shapes1.get(i).getBounds(1);
                h = (double)b.getHeight() / font.getDivider();
                if (h <= 0.0) continue;
                sumH += h.doubleValue();
                char c = font.glyphToChar(i);
                Font f = new Font(systemFont, (font.isBold() ? 1 : 0) | (font.isItalic() ? 2 : 0), 1000);
                if (!f.canDisplay(c)) continue;
                FontRenderContext frc = new FontRenderContext(null, true, true);
                GlyphVector gv = f.createGlyphVector(frc, new char[]{c});
                systemH = gv.getGlyphOutline(0).getBounds2D().getHeight();
                break;
            }
            if (systemH == null) {
                h = sumH / (double)shapes1.size();
                Font f = new Font("Serif", (font.isBold() ? 1 : 0) | (font.isItalic() ? 2 : 0), 1000);
                FontRenderContext frc = new FontRenderContext(null, true, true);
                GlyphVector gv = f.createGlyphVector(frc, new char[]{'H'});
                systemH = gv.getGlyphOutline(0).getBounds2D().getHeight();
            }
            newScale = systemH / h;
            willModify = true;
            double scale = newScale;
            int spaceGlyph = font.charToGlyph(' ');
            int nonBreakingSpaceGlyph = font.charToGlyph('\u00a0');
            if (spaceGlyph != -1 && font.getGlyphAdvance(spaceGlyph) <= 1.0) {
                willModify = true;
            }
            if (nonBreakingSpaceGlyph != -1 && font.getGlyphAdvance(nonBreakingSpaceGlyph) <= 1.0) {
                willModify = true;
            }
            if (!willModify) continue;
            fontNewScale.put(fontId, scale);
            if (inPlace) {
                font2 = font;
            } else {
                try {
                    font2 = (FontTag)font.cloneTag();
                }
                catch (IOException | InterruptedException ex) {
                    continue;
                }
            }
            outFonts.put(fontId, font2);
            List<SHAPE> shapes = font2.getGlyphShapeTable();
            Matrix matrix = new Matrix();
            matrix = matrix.preConcatenate(Matrix.getScaleInstance(scale, scale));
            if (invertedFontIds.contains(fontId)) {
                matrix = matrix.preConcatenate(Matrix.getScaleInstance(1.0, -1.0));
            }
            for (int i = 0; i < shapes.size(); ++i) {
                SHAPE shp = shapes.get(i);
                this.transformSHAPE(matrix, shp);
                if (!font2.hasLayout()) continue;
                font2.setGlyphAdvance(i, font2.getGlyphAdvance(i) * scale);
            }
            if (font2.hasLayout()) {
                font2.updateBounds();
                font2.setAscent((int)Math.round((double)font2.getAscent() * scale));
                font2.setDescent((int)Math.round((double)font2.getDescent() * scale));
                font2.setLeading((int)Math.round((double)font2.getLeading() * scale));
                if (invertedFontIds.contains(fontId)) {
                    int ascent = font2.getAscent();
                    int descent = font2.getDescent();
                    font2.setAscent(descent);
                    font2.setDescent(ascent);
                }
            }
            if (spaceGlyph != -1 && font.getGlyphAdvance(spaceGlyph) <= 1.0) {
                font2.setGlyphAdvance(spaceGlyph, 512.0);
            }
            if (nonBreakingSpaceGlyph != -1 && font.getGlyphAdvance(nonBreakingSpaceGlyph) <= 1.0) {
                font2.setGlyphAdvance(nonBreakingSpaceGlyph, 512.0);
            }
            font2.setModified(true);
        }
        iterator = texts.keySet().iterator();
        block12: while (iterator.hasNext()) {
            TextTag text;
            int textId = (Integer)iterator.next();
            int fontId = -1;
            int textHeight = 240;
            if (texts.get(textId) instanceof DefineEditTextTag) {
                text = (DefineEditTextTag)texts.get(textId);
                this.scaleDefineEditTextFonts((DefineEditTextTag)text, fontNewScale, inPlace, outTexts);
                continue;
            }
            if (!(texts.get(textId) instanceof StaticTextTag)) continue;
            text = (StaticTextTag)texts.get(textId);
            TextTag text2 = null;
            for (int i = 0; i < ((StaticTextTag)text).textRecords.size(); ++i) {
                FontTag font;
                TEXTRECORD rec = ((StaticTextTag)text).textRecords.get(i);
                if (rec.styleFlagsHasFont) {
                    fontId = rec.fontId;
                    if ((fontNewScale.containsKey(fontId) || invertedFontIds.contains(fontId)) && text2 == null) {
                        if (inPlace) {
                            text2 = text;
                        } else {
                            try {
                                text2 = (StaticTextTag)text.cloneTag();
                            }
                            catch (IOException | InterruptedException ex) {
                                continue block12;
                            }
                        }
                        outTexts.put(textId, text2);
                        text2.setModified(true);
                    }
                    textHeight = ((StaticTextTag)text).textRecords.get((int)i).textHeight;
                    if (fontNewScale.containsKey(fontId)) {
                        textHeight = ((StaticTextTag)text2).textRecords.get((int)i).textHeight = FontNormalizer.round20((double)((StaticTextTag)text2).textRecords.get((int)i).textHeight / (Double)fontNewScale.get(fontId));
                    }
                    if (invertedFontIds.contains(fontId) && ((StaticTextTag)text2).textMatrix != null && ((StaticTextTag)text2).textMatrix.scaleY < 0.0f) {
                        ((StaticTextTag)text2).textMatrix.scaleY *= -1.0f;
                    }
                }
                if (invertedFontIds.contains(fontId) && rec.styleFlagsHasYOffset) {
                    ((StaticTextTag)text2).textRecords.get((int)i).yOffset = -rec.yOffset;
                }
                if (rec.glyphEntries.isEmpty() || rec.glyphEntries.get((int)(rec.glyphEntries.size() - 1)).glyphAdvance != 0 || (font = outFonts.containsKey(fontId) ? outFonts.get(fontId) : swf.getFont(fontId)) == null) continue;
                if (text2 == null) {
                    if (inPlace) {
                        text2 = text;
                    } else {
                        try {
                            text2 = (StaticTextTag)text.cloneTag();
                        }
                        catch (IOException | InterruptedException ex) {
                            continue block12;
                        }
                    }
                    outTexts.put(textId, text2);
                    text2.setModified(true);
                }
                GLYPHENTRY lastGlyphEntry = ((StaticTextTag)text2).textRecords.get((int)i).glyphEntries.get(rec.glyphEntries.size() - 1);
                lastGlyphEntry.glyphAdvance = (int)Math.round(font.getGlyphAdvance(lastGlyphEntry.glyphIndex) * (double)textHeight / (1024.0 * font.getDivider()));
                if (i + 1 >= ((StaticTextTag)text).textRecords.size()) continue;
                TEXTRECORD nextRec = ((StaticTextTag)text2).textRecords.get(i + 1);
                if (nextRec.styleFlagsHasXOffset || nextRec.glyphEntries.isEmpty()) continue;
                nextRec.glyphEntries.get((int)0).glyphAdvance -= lastGlyphEntry.glyphAdvance;
            }
        }
        swf.clearShapeCache();
    }

    private static int round20(double val) {
        return (int)Math.round(val);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<Integer> getDefineEditTextFonts(DefineEditTextTag text) {
        LinkedHashSet<Integer> ret = new LinkedHashSet<Integer>();
        TextStyle style = new TextStyle();
        style.font = text.fontClass != null ? text.getSwf().getFontByClass(text.fontClass) : text.getSwf().getFont(text.fontId);
        int fontId = text.getSwf().getCharacterId(style.font);
        ret.add(fontId);
        if (!text.html) return ret;
        Stack<TextStyle> styles = new Stack<TextStyle>();
        styles.add(style);
        XmlLexer lexer = new XmlLexer(new StringReader(text.initialText));
        try {
            XmlParsedSymbol s = lexer.yylex();
            boolean inOpenTag = false;
            String attributeName = null;
            String tagName = null;
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            while (s.type != XmlSymbolType.EOF) {
                switch (s.type) {
                    case TAG_OPEN: {
                        inOpenTag = true;
                        attributeName = null;
                        tagName = (String)s.value;
                        attributes.clear();
                        break;
                    }
                    case ATTRIBUTE: {
                        attributeName = (String)s.value;
                        break;
                    }
                    case ATTRIBUTE_VALUE: {
                        if (attributeName == null) {
                            return ret;
                        }
                        attributes.put(attributeName, (String)s.value);
                        break;
                    }
                    case TAG_OPEN_END: {
                        style = (TextStyle)styles.peek();
                        switch (tagName) {
                            case "p": {
                                break;
                            }
                            case "a": {
                                break;
                            }
                            case "b": {
                                style = style.clone();
                                style.bold = true;
                                styles.add(style);
                                break;
                            }
                            case "i": {
                                style = style.clone();
                                style.italic = true;
                                styles.add(style);
                                break;
                            }
                            case "u": {
                                style = style.clone();
                                style.underlined = true;
                                styles.add(style);
                                break;
                            }
                            case "font": {
                                String size;
                                style = style.clone();
                                String face = (String)attributes.get("face");
                                if (face != null && face.length() > 0) {
                                    style.fontFace = face;
                                }
                                if ((size = (String)attributes.get("size")) != null && size.length() > 0 && style.fontFace != null && text.useOutlines) {
                                    CharacterTag ct = text.getSwf().getCharacterByExportName(style.fontFace);
                                    style.font = ct != null && ct instanceof FontTag ? (FontTag)ct : text.getSwf().getFontByNameInTag(style.fontFace, style.bold, style.italic);
                                    if (style.font == null) {
                                        style.fontFace = null;
                                    } else {
                                        fontId = text.getSwf().getCharacterId(style.font);
                                        ret.add(fontId);
                                    }
                                }
                                styles.add(style);
                                break;
                            }
                        }
                        tagName = null;
                        break;
                    }
                    case TAG_CLOSE: {
                        switch (tagName = (String)s.value) {
                            case "b": 
                            case "i": 
                            case "u": 
                            case "font": {
                                styles.pop();
                                break;
                            }
                        }
                        tagName = null;
                    }
                }
                s = lexer.yylex();
            }
            return ret;
        }
        catch (IOException iOException) {
            return ret;
        }
        catch (XmlException xmlException) {
            // empty catch block
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scaleDefineEditTextFonts(DefineEditTextTag text, Map<Integer, Double> fontNewScale, boolean inPlace, Map<Integer, TextTag> outTexts) {
        String str = "";
        TextStyle style = new TextStyle();
        style.font = text.fontClass != null ? text.getSwf().getFontByClass(text.fontClass) : text.getSwf().getFont(text.fontId);
        int textId = text.getSwf().getCharacterId(text);
        int fontId = text.getSwf().getCharacterId(style.font);
        DefineEditTextTag text2 = null;
        if (fontNewScale.containsKey(fontId)) {
            if (inPlace) {
                text2 = text;
            } else {
                try {
                    text2 = (DefineEditTextTag)text.cloneTag();
                }
                catch (IOException | InterruptedException ex) {
                    return;
                }
            }
            text2.fontHeight = FontNormalizer.round20((double)text2.fontHeight / fontNewScale.get(fontId));
            outTexts.put(textId, text2);
            text2.setModified(true);
        }
        style.fontHeight = text.fontHeight;
        style.fontLeading = text.leading;
        if (text.hasTextColor) {
            style.textColor = text.textColor;
        }
        if (text.hasText) {
            str = text.initialText;
        }
        style.leftMargin = text.leftMargin;
        ArrayList ret = new ArrayList();
        if (!text.html) return;
        StringBuilder sb = new StringBuilder();
        Stack<TextStyle> styles = new Stack<TextStyle>();
        styles.add(style);
        XmlLexer lexer = new XmlLexer(new StringReader(text.initialText));
        try {
            XmlParsedSymbol s = lexer.yylex();
            boolean inOpenTag = false;
            String attributeName = null;
            String tagName = null;
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            block43: while (s.type != XmlSymbolType.EOF) {
                switch (s.type) {
                    case TAG_OPEN: {
                        inOpenTag = true;
                        attributeName = null;
                        tagName = (String)s.value;
                        attributes.clear();
                        break;
                    }
                    case ATTRIBUTE: {
                        attributeName = (String)s.value;
                        break;
                    }
                    case ATTRIBUTE_VALUE: {
                        if (attributeName == null) break block43;
                        attributes.put(attributeName, (String)s.value);
                        break;
                    }
                    case TAG_OPEN_END: {
                        style = (TextStyle)styles.peek();
                        switch (tagName) {
                            case "p": {
                                break;
                            }
                            case "a": {
                                break;
                            }
                            case "b": {
                                style = style.clone();
                                style.bold = true;
                                styles.add(style);
                                break;
                            }
                            case "i": {
                                style = style.clone();
                                style.italic = true;
                                styles.add(style);
                                break;
                            }
                            case "u": {
                                style = style.clone();
                                style.underlined = true;
                                styles.add(style);
                                break;
                            }
                            case "font": {
                                String size;
                                style = style.clone();
                                String face = (String)attributes.get("face");
                                if (face != null && face.length() > 0) {
                                    style.fontFace = face;
                                }
                                if ((size = (String)attributes.get("size")) != null && size.length() > 0 && style.fontFace != null && text.useOutlines) {
                                    CharacterTag ct = text.getSwf().getCharacterByExportName(style.fontFace);
                                    style.font = ct != null && ct instanceof FontTag ? (FontTag)ct : text.getSwf().getFontByNameInTag(style.fontFace, style.bold, style.italic);
                                    if (style.font == null) {
                                        style.fontFace = null;
                                    } else {
                                        fontId = text.getSwf().getCharacterId(style.font);
                                        if (fontNewScale.containsKey(fontId)) {
                                            if (text2 == null) {
                                                if (inPlace) {
                                                    text2 = text;
                                                } else {
                                                    try {
                                                        text2 = (DefineEditTextTag)text.cloneTag();
                                                    }
                                                    catch (IOException | InterruptedException ex) {
                                                        return;
                                                    }
                                                }
                                                outTexts.put(textId, text2);
                                                text2.setModified(true);
                                            }
                                            try {
                                                char firstChar = size.charAt(0);
                                                if (firstChar != '+' && firstChar != '-') {
                                                    int fontSize = Integer.parseInt(size);
                                                    attributes.put("size", "" + Math.round((double)fontSize / fontNewScale.get(fontId)));
                                                } else {
                                                    int fontSizeDelta = (int)Math.round((double)Integer.parseInt(size.substring(1)) * 20.0);
                                                    attributes.put("size", "" + firstChar + Math.round((double)fontSizeDelta / fontNewScale.get(fontId)));
                                                }
                                                style.fontLeading = text.leading;
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                }
                                styles.add(style);
                                break;
                            }
                        }
                        sb.append("<").append(tagName);
                        for (String key : attributes.keySet()) {
                            sb.append(" ").append(key).append("=").append("\"").append((String)attributes.get(key)).append("\"");
                        }
                        sb.append(">");
                        tagName = null;
                        break;
                    }
                    case TAG_CLOSE: {
                        tagName = (String)s.value;
                        switch (tagName) {
                            case "b": 
                            case "i": 
                            case "u": 
                            case "font": {
                                styles.pop();
                                break;
                            }
                        }
                        sb.append("</").append(tagName).append(">");
                        tagName = null;
                        break;
                    }
                    case ENTITY: {
                        sb.append("&").append(s.value).append(";");
                        break;
                    }
                    case CHARACTER: {
                        sb.append(s.value);
                    }
                }
                s = lexer.yylex();
            }
            if (text2 == null) return;
            text2.initialText = sb.toString();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (XmlException xmlException) {
            // empty catch block
        }
    }

    private static double percentile(List<Double> values, double p) {
        if (values.isEmpty()) {
            return 0.0;
        }
        Collections.sort(values);
        double rank = p / 100.0 * (double)(values.size() - 1);
        int lo = (int)Math.floor(rank);
        int hi = (int)Math.ceil(rank);
        if (lo == hi) {
            return values.get(lo);
        }
        double w = rank - (double)lo;
        return values.get(lo) * (1.0 - w) + values.get(hi) * w;
    }

    private void transformSHAPE(Matrix matrix, SHAPE shape) {
        int x = 0;
        int y = 0;
        StyleChangeRecord lastStyleChangeRecord = null;
        boolean wasMoveTo = false;
        for (SHAPERECORD rec : shape.shapeRecords) {
            Point currentPoint;
            if (rec instanceof StyleChangeRecord) {
                StyleChangeRecord scr;
                lastStyleChangeRecord = scr = (StyleChangeRecord)rec;
                if (scr.stateNewStyles) {
                    // empty if block
                }
                if (scr.stateMoveTo) {
                    Point nextPoint = new Point(scr.moveDeltaX, scr.moveDeltaY);
                    x = scr.changeX(x);
                    y = scr.changeY(y);
                    Point nextPoint2 = matrix.transform(nextPoint);
                    scr.moveDeltaX = nextPoint2.x;
                    scr.moveDeltaY = nextPoint2.y;
                    scr.calculateBits();
                    wasMoveTo = true;
                }
            }
            if ((rec instanceof StraightEdgeRecord || rec instanceof CurvedEdgeRecord) && !wasMoveTo && lastStyleChangeRecord != null) {
                Point nextPoint2 = matrix.transform(new Point(x, y));
                if (nextPoint2.x != 0 || nextPoint2.y != 0) {
                    lastStyleChangeRecord.stateMoveTo = true;
                    lastStyleChangeRecord.moveDeltaX = nextPoint2.x;
                    lastStyleChangeRecord.moveDeltaY = nextPoint2.y;
                    lastStyleChangeRecord.calculateBits();
                    wasMoveTo = true;
                }
            }
            if (rec instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)rec;
                ser.generalLineFlag = true;
                ser.vertLineFlag = false;
                currentPoint = new Point(x, y);
                Point nextPoint = new Point(x + ser.deltaX, y + ser.deltaY);
                x = ser.changeX(x);
                y = ser.changeY(y);
                Point currentPoint2 = matrix.transform(currentPoint);
                Point nextPoint2 = matrix.transform(nextPoint);
                ser.deltaX = nextPoint2.x - currentPoint2.x;
                ser.deltaY = nextPoint2.y - currentPoint2.y;
                ser.simplify();
            }
            if (!(rec instanceof CurvedEdgeRecord)) continue;
            CurvedEdgeRecord cer = (CurvedEdgeRecord)rec;
            currentPoint = new Point(x, y);
            Point controlPoint = new Point(x + cer.controlDeltaX, y + cer.controlDeltaY);
            Point anchorPoint = new Point(x + cer.controlDeltaX + cer.anchorDeltaX, y + cer.controlDeltaY + cer.anchorDeltaY);
            x = cer.changeX(x);
            y = cer.changeY(y);
            Point currentPoint2 = matrix.transform(currentPoint);
            Point controlPoint2 = matrix.transform(controlPoint);
            Point anchorPoint2 = matrix.transform(anchorPoint);
            cer.controlDeltaX = controlPoint2.x - currentPoint2.x;
            cer.controlDeltaY = controlPoint2.y - currentPoint2.y;
            cer.anchorDeltaX = anchorPoint2.x - controlPoint2.x;
            cer.anchorDeltaY = anchorPoint2.y - controlPoint2.y;
            cer.calculateBits();
        }
    }
}

