/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.RenameType;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class AVM2Deobfuscation {
    private static final int DEFAULT_FOO_SIZE = 10;
    public static final String VALID_FIRST_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$";
    public static final String VALID_NEXT_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$0123456789";
    public static final String VALID_NS_CHARACTERS = ".:";
    private final SWF swf;
    private final AVM2ConstantPool constants;
    private final Map<String, Integer> usageTypesCount = new HashMap<String, Integer>();
    public static final DottedChain FLASH_PROXY = new DottedChain(new String[]{"flash", "utils", "flash_proxy"});
    public static final DottedChain BUILTIN = new DottedChain(new String[]{"-"});

    public AVM2Deobfuscation(SWF swf, AVM2ConstantPool constants) {
        this.swf = swf;
        this.constants = constants;
    }

    public boolean isValidNSPart(String s) {
        Pattern pat;
        boolean isValid = true;
        if (IdentifiersDeobfuscation.isReservedWord2(s)) {
            isValid = false;
        }
        if (Configuration.autoDeobfuscateIdentifiers.get().booleanValue() && (s.contains("_SafeStr_") || s.contains("_SafePkg_") || s.contains("_SafeCls_"))) {
            return false;
        }
        if (isValid) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) <= '\u007f') continue;
                isValid = false;
                break;
            }
        }
        if (isValid && !(pat = Pattern.compile("^([" + Pattern.quote(VALID_FIRST_CHARACTERS) + "][" + Pattern.quote("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$0123456789.:") + "]*)*$")).matcher(s).matches()) {
            isValid = false;
        }
        return isValid;
    }

    public DottedChain builtInNs(String ns) {
        if (ns == null) {
            return null;
        }
        if (ns.equals("http://www.adobe.com/2006/actionscript/flash/proxy")) {
            return FLASH_PROXY;
        }
        if (ns.equals("http://adobe.com/AS3/2006/builtin")) {
            return BUILTIN;
        }
        return null;
    }

    private String fooString(HashMap<DottedChain, DottedChain> deobfuscated, String orig, boolean firstUppercase, String usageType, RenameType renameType, boolean autoAdd) {
        boolean found;
        if (usageType == null) {
            usageType = "name";
        }
        String ret = null;
        int rndSize = 10;
        do {
            found = false;
            if (renameType == RenameType.TYPENUMBER) {
                ret = Helper.getNextId(usageType, this.usageTypesCount, true);
            } else if (renameType == RenameType.RANDOMWORD) {
                ret = IdentifiersDeobfuscation.fooString(firstUppercase, rndSize);
            }
            if (!this.swf.as3StringConstantExists(ret) && !IdentifiersDeobfuscation.isReservedWord2(ret) && !deobfuscated.containsValue(DottedChain.parseNoSuffix(ret))) continue;
            found = true;
            ++rndSize;
        } while (found);
        if (autoAdd) {
            deobfuscated.put(DottedChain.parseNoSuffix(orig), DottedChain.parseNoSuffix(ret));
        }
        return ret;
    }

    public boolean isValidPackageName(int strIndex) {
        if (strIndex <= 0) {
            return true;
        }
        String s = this.constants.getString(strIndex);
        if (this.builtInNs(s) != null) {
            return true;
        }
        return this.isValidNSPart(s);
    }

    public int deobfuscatePackageName(Map<Integer, String> stringUsageTypes, Set<Integer> stringUsages, HashMap<DottedChain, DottedChain> namesMap, int strIndex, RenameType renameType) {
        if (!this.isValidPackageName(strIndex)) {
            String s = this.constants.getString(strIndex);
            DottedChain sChain = DottedChain.parseWithSuffix(s);
            if (namesMap.containsKey(sChain)) {
                DottedChain newName = namesMap.get(sChain);
                return this.constants.getStringId(newName.toRawString(), true);
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (int p = 0; p < sChain.size(); ++p) {
                String part = sChain.get(p);
                if (!this.isValidNSPart(part)) {
                    ret.add(this.fooString(namesMap, part, false, "package", renameType, true));
                    continue;
                }
                ret.add(part);
            }
            DottedChain newName = new DottedChain(ret);
            namesMap.put(sChain, newName);
            if (stringUsages.contains(strIndex)) {
                strIndex = this.constants.addString(newName.toRawString());
            } else {
                this.constants.setString(strIndex, newName.toRawString());
            }
        }
        return strIndex;
    }

    public boolean isValidName(int strIndex) {
        Pattern pat;
        if (strIndex <= 0) {
            return true;
        }
        String s = this.constants.getString(strIndex);
        if (Configuration.autoDeobfuscateIdentifiers.get().booleanValue() && (s.startsWith("_SafeStr_") || s.startsWith("_SafePkg_") || s.startsWith("_SafeCls_"))) {
            return false;
        }
        boolean isValid = true;
        if (IdentifiersDeobfuscation.isReservedWord2(s)) {
            isValid = false;
        }
        if (isValid) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) <= '\u007f') continue;
                isValid = false;
                break;
            }
        }
        if (isValid && !(pat = Pattern.compile("^[" + Pattern.quote(VALID_FIRST_CHARACTERS) + "][" + Pattern.quote("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$0123456789") + "]*$")).matcher(s).matches()) {
            isValid = false;
        }
        return isValid;
    }

    public int deobfuscateName(Map<Integer, String> stringUsageTypes, Set<Integer> stringUsages, Set<Integer> namespaceUsages, HashMap<DottedChain, DottedChain> namesMap, int strIndex, boolean firstUppercase, RenameType renameType) {
        if (!this.isValidName(strIndex)) {
            String s = this.constants.getString(strIndex);
            DottedChain sChain = DottedChain.parseNoSuffix(s);
            if (namesMap.containsKey(sChain)) {
                DottedChain newname = namesMap.get(sChain);
                return this.constants.getStringId(newname, true);
            }
            String str = this.fooString(namesMap, this.constants.getString(strIndex), firstUppercase, stringUsageTypes.get(strIndex), renameType, false);
            DottedChain newname = DottedChain.parseNoSuffix(str);
            if (stringUsages.contains(strIndex) || namespaceUsages.contains(strIndex)) {
                String usageType = stringUsageTypes.get(strIndex);
                strIndex = this.constants.addString(s);
                stringUsageTypes.put(strIndex, usageType);
            }
            this.constants.setString(strIndex, newname.toRawString());
            if (!namesMap.containsKey(sChain)) {
                namesMap.put(sChain, DottedChain.parseNoSuffix(this.constants.getString(strIndex)));
            }
        }
        return strIndex;
    }
}

