/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.fastavm2;

import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.fastavm2.AVM2InstructionItem;
import com.jpexs.decompiler.flash.abc.avm2.fastavm2.FastAVM2ListIterator;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.IfTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.JumpIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.LookupSwitchIns;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FastAVM2List
implements Collection<AVM2InstructionItem> {
    private int size;
    private AVM2InstructionItem firstItem;
    private final Map<AVM2Instruction, AVM2InstructionItem> actionItemMap;
    private final Set<AVM2InstructionItem> actionItemSet;

    public FastAVM2List(MethodBody body) {
        AVM2Code avm2code = body.getCode();
        List<AVM2Instruction> code = avm2code.code;
        this.actionItemMap = new HashMap<AVM2Instruction, AVM2InstructionItem>(code.size());
        this.actionItemSet = new HashSet<AVM2InstructionItem>(code.size());
        for (AVM2Instruction action : code) {
            this.insertItemAfter(null, action);
        }
        this.size = code.size();
        this.getJumps(avm2code, this.actionItemMap);
    }

    public final AVM2InstructionItem insertItemBefore(AVM2InstructionItem item, AVM2Instruction action) {
        AVM2InstructionItem newItem = new AVM2InstructionItem(action);
        return this.insertItemBefore(item, newItem);
    }

    public final AVM2InstructionItem insertItemBefore(AVM2InstructionItem item, AVM2InstructionItem newItem) {
        this.insertItemAfter(item.prev, newItem);
        if (item == this.firstItem) {
            this.firstItem = newItem;
        }
        return newItem;
    }

    public final AVM2InstructionItem insertItemAfter(AVM2InstructionItem item, AVM2Instruction action) {
        AVM2InstructionItem newItem = new AVM2InstructionItem(action);
        return this.insertItemAfter(item, newItem);
    }

    public final AVM2InstructionItem insertItemAfter(AVM2InstructionItem item, AVM2InstructionItem newItem) {
        if (item == null && this.firstItem == null) {
            this.firstItem = newItem;
            newItem.next = newItem;
            newItem.prev = newItem;
        } else {
            if (item == null) {
                item = this.firstItem.prev;
            }
            AVM2InstructionItem oldNext = item.next;
            newItem.prev = item;
            newItem.next = oldNext;
            item.next = newItem;
            oldNext.prev = newItem;
        }
        ++this.size;
        this.actionItemMap.put(newItem.ins, newItem);
        this.actionItemSet.add(newItem);
        return newItem;
    }

    public AVM2InstructionItem removeItem(AVM2InstructionItem item) {
        AVM2InstructionItem next = null;
        if (item == this.firstItem) {
            if (item.next == item) {
                this.firstItem = null;
            } else {
                this.firstItem = next = item.next;
                next.prev = item.prev;
                item.prev.next = next;
            }
        } else {
            item.prev.next = next = item.next;
            next.prev = item.prev;
        }
        --this.size;
        this.actionItemMap.remove(item.ins);
        this.actionItemSet.remove(item);
        item.removeJumpTarget();
        item.removeContainerLastInstructions();
        if (item.jumpsHere != null) {
            for (AVM2InstructionItem item1 : new ArrayList<AVM2InstructionItem>(item.jumpsHere)) {
                item1.setJumpTarget(item.next);
            }
        }
        if (item.lastInsOf != null) {
            for (AVM2InstructionItem item1 : new ArrayList<AVM2InstructionItem>(item.lastInsOf)) {
                item1.replaceContainerLastInstruction(item, item.prev);
            }
        }
        return next;
    }

    public void removeItem(int index, int count) {
        FastAVM2ListIterator iterator = new FastAVM2ListIterator(this, index);
        for (int i = 0; i < count; ++i) {
            iterator.next();
            iterator.remove();
        }
    }

    public AVM2InstructionItem get(int index) {
        FastAVM2ListIterator iterator = new FastAVM2ListIterator(this, index);
        return iterator.next();
    }

    public void replaceJumpTargets(AVM2InstructionItem target, AVM2InstructionItem newTarget) {
        if (target.jumpsHere != null) {
            for (AVM2InstructionItem item : new ArrayList<AVM2InstructionItem>(target.jumpsHere)) {
                item.setJumpTarget(newTarget);
            }
        }
    }

    private long getNearAddress(List<AVM2Instruction> instructions, long address, boolean next) {
        int min = 0;
        int max = instructions.size() - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            long midValue = instructions.get(mid).getAddress();
            if (midValue == address) {
                return address;
            }
            if (midValue < address) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return next ? (min < instructions.size() ? instructions.get(min).getAddress() : -1L) : (max >= 0 ? instructions.get(max).getAddress() : -1L);
    }

    private void getJumps(AVM2Code actions, Map<AVM2Instruction, AVM2InstructionItem> actionItemMap) {
        AVM2InstructionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        do {
            AVM2Instruction action = item.ins;
            long target = -1L;
            if (action.definition instanceof IfTypeIns) {
                target = action.getTargetAddress();
            } else if (action.definition instanceof LookupSwitchIns) {
                // empty if block
            }
            if (target < 0L) continue;
            AVM2Instruction targetAction = actions.adr2ins(target);
            item.setJumpTarget(actionItemMap.get(targetAction));
        } while ((item = item.next) != this.firstItem);
    }

    private void updateActionAddressesAndLengths() {
        AVM2InstructionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        long offset = item.ins.getAddress();
        do {
            AVM2Instruction action = item.ins;
            action.setAddress(offset);
            offset += (long)action.getBytesLength();
        } while ((item = item.next) != this.firstItem);
    }

    private void updateJumps() {
        AVM2InstructionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        long endAddress = item.prev.ins.getAddress();
        do {
            AVM2Instruction action = item.ins;
            if (action.definition instanceof IfTypeIns) {
                AVM2Instruction target = item.getJumpTargetInstruction();
                long offset = target != null ? target.getAddress() - action.getAddress() - (long)action.getBytesLength() : endAddress - action.getAddress() - (long)action.getBytesLength();
                action.setTargetOffset((int)offset);
                continue;
            }
            if (!(action.definition instanceof LookupSwitchIns)) continue;
        } while ((item = item.next) != this.firstItem);
    }

    private void updateContainerSizes() {
        AVM2InstructionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        do {
            AVM2Instruction action;
            if (!((action = item.ins) instanceof GraphSourceItemContainer)) continue;
            GraphSourceItemContainer container = (GraphSourceItemContainer)((Object)action);
            List<AVM2InstructionItem> lastActions = item.getContainerLastInstructions();
            long startAddress = action.getAddress() + container.getHeaderSize();
            for (int j = 0; j < lastActions.size(); ++j) {
                AVM2Instruction lastAction = lastActions.get((int)j).ins;
                int length = (int)(lastAction.getAddress() + (long)lastAction.getBytesLength() - startAddress);
                container.setContainerSize(j, length);
                startAddress += (long)length;
            }
        } while ((item = item.next) != this.firstItem);
    }

    public AVM2InstructionItem getContainer(AVM2InstructionItem item) {
        while (!(item.ins instanceof GraphSourceItemContainer) && item != this.firstItem) {
            item = item.prev;
        }
        if (item.ins instanceof GraphSourceItemContainer) {
            return item;
        }
        return null;
    }

    public void removeZeroJumps() {
        AVM2Instruction ins;
        AVM2InstructionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        do {
            ins = item.ins;
        } while ((item = ins.definition instanceof JumpIns && item.getJumpTarget() == item.next && item.getJumpTarget() != this.firstItem ? this.removeItem(item) : item.next) != this.firstItem);
    }

    public void removeUnreachableActions() {
        AVM2InstructionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        this.updateReachableFlags(null, null);
        while ((item = item.reachable == 0 ? this.removeItem(item) : item.next) != this.firstItem) {
        }
    }

    public void removeIncludedActions() {
        AVM2InstructionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        while ((item = !item.excluded ? this.removeItem(item) : item.next) != this.firstItem) {
        }
    }

    public int getUnreachableActionCount(AVM2InstructionItem jump, AVM2InstructionItem jumpTarget) {
        AVM2InstructionItem item = this.firstItem;
        if (item == null) {
            return 0;
        }
        this.updateReachableFlags(jump, jumpTarget);
        jump.reachable = 0;
        int count = 0;
        do {
            if (item.reachable != 0) continue;
            ++count;
        } while ((item = item.next) != this.firstItem);
        return count;
    }

    private void clearReachableFlags() {
        AVM2InstructionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        do {
            item.reachable = 0;
        } while ((item = item.next) != this.firstItem);
    }

    public void setExcludedFlags(boolean value) {
        AVM2InstructionItem item = this.firstItem;
        if (item == null) {
            return;
        }
        do {
            item.excluded = value;
        } while ((item = item.next) != this.firstItem);
    }

    private void updateReachableFlags(AVM2InstructionItem jump, AVM2InstructionItem jumpTarget) {
        if (this.firstItem == null) {
            return;
        }
        this.clearReachableFlags();
        this.firstItem.reachable = 1;
        AVM2InstructionItem firstItem2 = this.firstItem;
        boolean modified = true;
        while (modified) {
            AVM2InstructionItem next;
            modified = false;
            AVM2InstructionItem item = firstItem2;
            do {
                AVM2InstructionItem target;
                next = item.next;
                AVM2Instruction action = item.ins;
                if (item.reachable != 1) continue;
                item.reachable = 2;
                modified = true;
                if (item == firstItem2) {
                    firstItem2 = next;
                }
                if (item == jump) {
                    if (jumpTarget.reachable != 0) continue;
                    jumpTarget.reachable = 1;
                    continue;
                }
                if (!action.isExit() && !(action.definition instanceof JumpIns) && next.reachable == 0) {
                    next.reachable = 1;
                }
                if (action instanceof GraphSourceItemContainer) {
                    for (AVM2InstructionItem lastActionItem : item.getContainerLastInstructions()) {
                        if (lastActionItem == null || lastActionItem.next == null || lastActionItem.next.reachable != 0) continue;
                        lastActionItem.next.reachable = 1;
                    }
                }
                if ((target = item.getJumpTarget()) == null || target.reachable != 0) continue;
                target.reachable = 1;
            } while ((item = next) != this.firstItem);
        }
    }

    public void updateActions(MethodBody body) {
        AVM2Code result = new AVM2Code(this.size);
        AVM2InstructionItem item = this.firstItem;
        if (item == null) {
            body.setCode(result);
            body.exceptions = new ABCException[0];
            return;
        }
        List<AVM2Instruction> resultList = result.code;
        do {
            resultList.add(item.ins);
        } while ((item = item.next) != this.firstItem);
        this.updateActionAddressesAndLengths();
        this.updateJumps();
        this.updateContainerSizes();
    }

    public AVM2InstructionItem first() {
        return this.firstItem;
    }

    public AVM2InstructionItem last() {
        return this.firstItem == null ? null : this.firstItem.prev;
    }

    public void toMethodBody(MethodBody body) {
        this.updateActions(body);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof AVM2InstructionItem) {
            return this.actionItemSet.contains(o);
        }
        if (o instanceof AVM2Instruction) {
            return this.actionItemMap.containsKey((AVM2Instruction)o);
        }
        return false;
    }

    public FastAVM2ListIterator iterator() {
        return new FastAVM2ListIterator(this);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        AVM2InstructionItem item = this.firstItem;
        if (item == null) {
            return result;
        }
        int i = 0;
        do {
            result[i] = item.ins;
            item = item.next;
            ++i;
        } while (item != this.firstItem);
        return null;
    }

    @Override
    public <T> T[] toArray(T[] value) {
        AVM2InstructionItem item;
        if (value.length != this.size) {
            value = new AVM2InstructionItem[this.size];
        }
        if ((item = this.firstItem) == null) {
            return value;
        }
        int i = 0;
        do {
            value[i] = item;
            item = item.next;
            ++i;
        } while (item != this.firstItem);
        return null;
    }

    @Override
    public boolean add(AVM2InstructionItem e) {
        this.insertItemAfter(null, e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        AVM2InstructionItem item = null;
        if (o instanceof AVM2InstructionItem) {
            item = (AVM2InstructionItem)o;
        } else if (o instanceof AVM2Instruction) {
            item = this.actionItemMap.get((AVM2Instruction)o);
        }
        if (item == null) {
            return false;
        }
        this.removeItem(item);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object c1 : c) {
            if (this.contains(c1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends AVM2InstructionItem> c) {
        for (AVM2InstructionItem aVM2InstructionItem : c) {
            this.insertItemAfter(null, aVM2InstructionItem);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object c1 : c) {
            result |= this.remove(c1);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        AVM2InstructionItem item = this.firstItem;
        if (item == null) {
            return false;
        }
        boolean modified = false;
        do {
            if (!c.contains(item)) {
                item = this.removeItem(item);
                modified = true;
                continue;
            }
            item = item.next;
        } while (item != this.firstItem);
        return modified;
    }

    @Override
    public void clear() {
        this.firstItem = null;
        this.size = 0;
    }
}

