/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions.localregs;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.LocalDataArea;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.instructions.SetTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.model.DecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FindPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewActivationAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.PostDecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.PostIncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetLocalAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.StoreNewActivationAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.PreDecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.PreIncrementAVM2Item;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.CommaExpressionItem;
import com.jpexs.decompiler.graph.model.CompoundableBinaryOp;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import com.jpexs.decompiler.graph.model.PopItem;
import java.util.List;

public abstract class SetLocalTypeIns
extends InstructionDefinition
implements SetTypeIns {
    public SetLocalTypeIns(int instructionCode, String instructionName, int[] operands, boolean canThrow) {
        super(instructionCode, instructionName, operands, canThrow, new AVM2InstructionFlag[0]);
    }

    @Override
    public boolean execute(LocalDataArea lda, AVM2ConstantPool constants, AVM2Instruction ins) {
        lda.localRegisters.put(this.getRegisterId(ins), lda.operandStack.pop());
        return true;
    }

    @Override
    public void translate(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) {
        CompoundableBinaryOp binaryOp;
        GraphTargetItem inside;
        int regId = this.getRegisterId(ins);
        GraphTargetItem value = stack.pop();
        if (value instanceof CommaExpressionItem) {
            CommaExpressionItem ce = (CommaExpressionItem)value;
            if (!ce.commands.isEmpty()) {
                localData.localRegs.put(regId, ce.commands.get(ce.commands.size() - 1));
            }
        } else if (!(value instanceof PopItem)) {
            localData.localRegs.put(regId, value);
        }
        if (!localData.localRegAssignmentIps.containsKey(regId)) {
            localData.localRegAssignmentIps.put(regId, 0);
        }
        localData.localRegAssignmentIps.put(regId, localData.localRegAssignmentIps.get(regId) + 1);
        if (value.getThroughDuplicate() instanceof NewActivationAVM2Item) {
            stack.addToOutput(new StoreNewActivationAVM2Item(ins, localData.lineStartInstruction, regId));
            return;
        }
        if (value instanceof FindPropertyAVM2Item) {
            return;
        }
        if (value.getNotCoerced() instanceof IncrementAVM2Item && (inside = ((IncrementAVM2Item)value.getNotCoerced()).value.getNotCoerced().getThroughDuplicate()) instanceof LocalRegAVM2Item && ((LocalRegAVM2Item)inside).regIndex == regId) {
            if (!stack.isEmpty()) {
                GraphTargetItem top = stack.peek().getNotCoerced().getThroughDuplicate();
                if (top == inside) {
                    GraphTargetItem.checkDup(stack, output, stack.pop(), value.getNotCoerced().value);
                    stack.push(new PostIncrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside, SetLocalTypeIns.getNumberType(value)));
                } else if (top instanceof IncrementAVM2Item && ((IncrementAVM2Item)top).value == inside) {
                    GraphTargetItem.checkDup(stack, output, stack.pop(), value);
                    stack.push(new PreIncrementAVM2Item(ins, localData.lineStartInstruction, inside, SetLocalTypeIns.getNumberType(value)));
                } else {
                    stack.addToOutput(new PostIncrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside, SetLocalTypeIns.getNumberType(value)));
                }
            } else {
                stack.addToOutput(new PostIncrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside, SetLocalTypeIns.getNumberType(value)));
            }
            return;
        }
        if (value.getNotCoerced() instanceof DecrementAVM2Item && (inside = ((DecrementAVM2Item)value.getNotCoerced()).value.getNotCoerced().getThroughDuplicate()) instanceof LocalRegAVM2Item && ((LocalRegAVM2Item)inside).regIndex == regId) {
            if (!stack.isEmpty()) {
                GraphTargetItem top = stack.peek().getNotCoerced().getThroughDuplicate();
                if (top == inside) {
                    GraphTargetItem.checkDup(stack, output, stack.pop(), value.getNotCoerced().value);
                    stack.push(new PostDecrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside, SetLocalTypeIns.getNumberType(value)));
                } else if (top instanceof DecrementAVM2Item && ((DecrementAVM2Item)top).value == inside) {
                    GraphTargetItem.checkDup(stack, output, stack.pop(), value);
                    stack.push(new PreDecrementAVM2Item(ins, localData.lineStartInstruction, inside, SetLocalTypeIns.getNumberType(value)));
                } else {
                    stack.addToOutput(new PostDecrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside, SetLocalTypeIns.getNumberType(value)));
                }
            } else {
                stack.addToOutput(new PostDecrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside, SetLocalTypeIns.getNumberType(value)));
            }
            return;
        }
        SetLocalAVM2Item result = new SetLocalAVM2Item(ins, localData.lineStartInstruction, regId, value, value.returnType());
        if (value.getNotCoerced() instanceof CompoundableBinaryOp && (binaryOp = (CompoundableBinaryOp)((Object)value.getNotCoerced())).getLeftSide().getNotCoerced() instanceof LocalRegAVM2Item) {
            LocalRegAVM2Item loc = (LocalRegAVM2Item)binaryOp.getLeftSide().getNotCoerced();
            if (loc.regIndex == regId) {
                result.setCompoundValue(binaryOp.getRightSide());
                result.setCompoundOperator(binaryOp.getOperator());
            }
        }
        if (value instanceof DuplicateItem) {
            result.directlyCausedByDup = true;
        }
        SetTypeIns.handleResult(value, stack, output, localData, result, regId, value.returnType());
    }

    @Override
    public int getStackPopCount(AVM2Instruction ins, ABC abc) {
        return 1;
    }

    public abstract int getRegisterId(AVM2Instruction var1);
}

