/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions.stack;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.LocalDataArea;
import com.jpexs.decompiler.flash.abc.avm2.graph.AVM2GraphTargetDialect;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.model.NewActivationAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ExceptionAVM2Item;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SimpleValue;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import com.jpexs.decompiler.graph.model.DuplicateSourceItem;
import com.jpexs.decompiler.graph.model.HasTempIndex;
import com.jpexs.decompiler.graph.model.SetTemporaryItem;
import java.util.List;

public class DupIns
extends InstructionDefinition {
    public DupIns() {
        super(42, "dup", new int[0], false, new AVM2InstructionFlag[0]);
    }

    @Override
    public boolean execute(LocalDataArea lda, AVM2ConstantPool constants, AVM2Instruction ins) {
        Object obj = lda.operandStack.pop();
        lda.operandStack.push(obj);
        lda.operandStack.push(obj);
        return true;
    }

    @Override
    public void translate(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) {
        SimpleValue sv;
        GraphTargetItem v = stack.pop();
        int temp = 0;
        if (v instanceof SimpleValue && (sv = (SimpleValue)((Object)v)).isSimpleValue()) {
            stack.push(v);
            stack.push(v);
            return;
        }
        if (v instanceof NewActivationAVM2Item || v instanceof ExceptionAVM2Item) {
            stack.push(v);
        } else if (v instanceof HasTempIndex) {
            temp = ((HasTempIndex)((Object)v)).getTempIndex();
            stack.push(v);
        } else {
            temp = (Integer)localData.maxTempIndex.getVal() + 1;
            localData.maxTempIndex.setVal(temp);
            stack.finishBlock(output);
            stack.addToOutput(new SetTemporaryItem(AVM2GraphTargetDialect.INSTANCE, ins, localData.lineStartInstruction, v, temp, "dup", 2));
            stack.finishBlock(output);
            stack.push(new DuplicateSourceItem(AVM2GraphTargetDialect.INSTANCE, (GraphSourceItem)ins, localData.lineStartInstruction, v, temp));
        }
        stack.push(new DuplicateItem(AVM2GraphTargetDialect.INSTANCE, (GraphSourceItem)ins, localData.lineStartInstruction, v, temp));
    }

    @Override
    public int getStackPopCount(AVM2Instruction ins, ABC abc) {
        return 1;
    }

    @Override
    public int getStackPushCount(AVM2Instruction ins, ABC abc) {
        return 2;
    }
}

