/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.graph.AVM2GraphTargetDialect;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.model.ApplyTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FindPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NextNameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NextValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.ExceptionAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AVM2SourceGenerator;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public abstract class AVM2Item
extends GraphTargetItem {
    private AVM2Instruction instruction;
    private AVM2Instruction lineStartIns;

    public AVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, int precedence) {
        this(instruction, lineStartIns, precedence, null);
    }

    public AVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, int precedence, GraphTargetItem value) {
        super(AVM2GraphTargetDialect.INSTANCE, instruction, lineStartIns, precedence, value);
        if (instruction instanceof AVM2Instruction) {
            this.instruction = (AVM2Instruction)instruction;
        }
        if (lineStartIns instanceof AVM2Instruction) {
            this.lineStartIns = (AVM2Instruction)lineStartIns;
        }
    }

    public AVM2Instruction getInstruction() {
        return this.instruction;
    }

    public AVM2Instruction getLineStartIns() {
        return this.lineStartIns;
    }

    @Override
    public boolean needsSemicolon() {
        return true;
    }

    protected GraphTextWriter formatProperty(GraphTextWriter writer, GraphTargetItem object, GraphTargetItem propertyName, LocalData localData, boolean isStatic, boolean nullCondition) throws InterruptedException {
        boolean empty = object.getThroughDuplicate() instanceof FindPropertyAVM2Item;
        if (object instanceof LocalRegAVM2Item && ((LocalRegAVM2Item)object).computedValue != null && ((LocalRegAVM2Item)object).computedValue.getThroughNotCompilable() instanceof FindPropertyAVM2Item) {
            empty = true;
        }
        if (object.getThroughDuplicate() instanceof FindPropertyAVM2Item) {
            FindPropertyAVM2Item fp = (FindPropertyAVM2Item)object.getThroughDuplicate();
            if (fp.propertyName instanceof FullMultinameAVM2Item) {
                if (propertyName instanceof FullMultinameAVM2Item && !((FullMultinameAVM2Item)propertyName).property) {
                    ((FullMultinameAVM2Item)fp.propertyName).property = false;
                }
                propertyName = fp.propertyName;
            }
        }
        if (!empty && object != null) {
            if (object.getPrecedence() > 0 || object instanceof IntegerValueAVM2Item) {
                writer.append("(");
                object.toString(writer, localData);
                writer.append(")");
                empty = false;
            } else {
                int writerLength = writer.getLength();
                object.toString(writer, localData);
                if (writerLength == writer.getLength()) {
                    empty = true;
                }
            }
        }
        if (empty) {
            return propertyName.toString(writer, localData);
        }
        if (propertyName instanceof FullMultinameAVM2Item) {
            String operator;
            HighlightData data = new HighlightData();
            int multinameIndex = ((FullMultinameAVM2Item)propertyName).multinameIndex;
            int namespaceIndex = localData.constantsAvm2.getMultiname((int)multinameIndex).namespace_index;
            GraphTargetItem returnType = object.returnType();
            if (returnType instanceof ApplyTypeAVM2Item) {
                ApplyTypeAVM2Item ati = (ApplyTypeAVM2Item)returnType;
                data.propertyType = ati.object.toString();
                data.propertySubType = ati.params.get(0).toString();
            } else {
                data.propertyType = returnType.toString();
            }
            data.namespaceIndex = namespaceIndex;
            data.isStatic = isStatic;
            String string = operator = nullCondition ? "?." : ".";
            if (((FullMultinameAVM2Item)propertyName).name != null) {
                if (((FullMultinameAVM2Item)propertyName).namespace != null) {
                    writer.allowWrapHere().hilightSpecial(operator, HighlightSpecialType.PROPERTY_TYPE, 0, data);
                }
                return propertyName.toString(writer, localData);
            }
            writer.allowWrapHere().hilightSpecial(operator, HighlightSpecialType.PROPERTY_TYPE, 0, data);
            return propertyName.toString(writer, localData);
        }
        writer.append("[").allowWrapHere();
        propertyName.toString(writer, localData);
        return writer.append("]");
    }

    public static String localRegName(SWF swf, HashMap<Integer, String> localRegNames, int reg, Set<String> usedDeobfuscations) {
        if (localRegNames.containsKey(reg)) {
            return IdentifiersDeobfuscation.printIdentifier(swf, usedDeobfuscations, true, localRegNames.get(reg), new String[0]);
        }
        if (reg == 0) {
            return "this";
        }
        return String.format(Configuration.registerNameFormat.get(), reg);
    }

    @Override
    public List<GraphSourceItem> toSourceIgnoreReturnValue(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        if (!this.hasReturnValue()) {
            return this.toSource(localData, generator);
        }
        List<GraphSourceItem> ret = this.toSource(localData, generator);
        ret.add(new AVM2Instruction(0L, 41, null));
        return ret;
    }

    public static AVM2Instruction ins(int instructionCode, Integer ... operands) {
        InstructionDefinition def = AVM2Code.instructionSet[instructionCode];
        ArrayList<Integer> ops = new ArrayList<Integer>();
        for (Integer o : operands) {
            if (o == null) continue;
            ops.add(o);
        }
        int[] opArr = new int[ops.size()];
        for (int i = 0; i < ops.size(); ++i) {
            opArr[i] = (Integer)ops.get(i);
        }
        return new AVM2Instruction(0L, def, opArr);
    }

    public static int getFreeRegister(SourceGeneratorLocalData localData, SourceGenerator generator) {
        AVM2SourceGenerator g = (AVM2SourceGenerator)generator;
        return g.getFreeRegister(localData);
    }

    public static void killRegister(SourceGeneratorLocalData localData, SourceGenerator generator, int regNumber) {
        AVM2SourceGenerator g = (AVM2SourceGenerator)generator;
        g.killRegister(localData, regNumber);
    }

    @Override
    public boolean isIdentical(GraphTargetItem other) {
        GraphTargetItem tiName = this;
        while (tiName instanceof LocalRegAVM2Item && ((LocalRegAVM2Item)tiName).computedValue != null) {
            tiName = ((LocalRegAVM2Item)tiName).computedValue.getThroughNotCompilable().getThroughDuplicate();
        }
        GraphTargetItem tiName2 = other;
        if (tiName2 != null) {
            tiName2 = tiName2.getThroughDuplicate();
        }
        while (tiName2 instanceof LocalRegAVM2Item && ((LocalRegAVM2Item)tiName2).computedValue != null) {
            tiName2 = ((LocalRegAVM2Item)tiName2).computedValue.getThroughNotCompilable().getThroughDuplicate();
        }
        return tiName == tiName2;
    }

    public static boolean mustStayIntact1(GraphTargetItem target) {
        return (target = target.getNotCoerced()) instanceof ExceptionAVM2Item;
    }

    public static boolean mustStayIntact2(GraphTargetItem target) {
        if ((target = target.getNotCoerced()) instanceof NextValueAVM2Item) {
            return true;
        }
        return target instanceof NextNameAVM2Item;
    }
}

