/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FindPropertyAVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class CallSuperAVM2Item
extends AVM2Item {
    public GraphTargetItem receiver;
    public GraphTargetItem multiname;
    public List<GraphTargetItem> arguments;
    public boolean isVoid;

    public CallSuperAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, boolean isVoid, GraphTargetItem receiver, GraphTargetItem multiname, List<GraphTargetItem> arguments) {
        super(instruction, lineStartIns, 0);
        this.receiver = receiver;
        this.multiname = multiname;
        this.arguments = arguments;
        this.isVoid = isVoid;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.receiver);
        visitor.visit(this.multiname);
        visitor.visitAll(this.arguments);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (!this.receiver.toString().equals("this") && !(this.receiver.getThroughDuplicate() instanceof FindPropertyAVM2Item)) {
            this.receiver.toString(writer, localData);
            writer.append(".");
        }
        writer.append("super.");
        this.multiname.toString(writer, localData);
        writer.append("(");
        String args = "";
        for (int a = 0; a < this.arguments.size(); ++a) {
            if (a > 0) {
                writer.append(",");
            }
            this.arguments.get(a).toString(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.receiver);
        hash = 53 * hash + Objects.hashCode(this.multiname);
        hash = 53 * hash + Objects.hashCode(this.arguments);
        hash = 53 * hash + (this.isVoid ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallSuperAVM2Item other = (CallSuperAVM2Item)obj;
        if (this.isVoid != other.isVoid) {
            return false;
        }
        if (!Objects.equals(this.receiver, other.receiver)) {
            return false;
        }
        if (!Objects.equals(this.multiname, other.multiname)) {
            return false;
        }
        return Objects.equals(this.arguments, other.arguments);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

