/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ApplyTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AVM2SourceGenerator;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.UnboundedTypeItem;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CoerceAVM2Item
extends AVM2Item {
    public GraphTargetItem typeObj;

    public CoerceAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem value, GraphTargetItem typeObj) {
        super(instruction, lineStartIns, value.getPrecedence(), value);
        this.typeObj = typeObj;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.typeObj);
        if (this.value != null) {
            visitor.visit(this.value);
        }
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        boolean displayCoerce = true;
        GraphTargetItem valueReturnType = this.value.returnType();
        switch (this.typeObj.toString()) {
            case "*": {
                displayCoerce = false;
                break;
            }
            case "Boolean": {
                displayCoerce = !valueReturnType.equals(TypeItem.BOOLEAN) && !valueReturnType.equals(TypeItem.UNBOUNDED);
                break;
            }
            case "Number": {
                displayCoerce = !valueReturnType.equals(TypeItem.INT) && !valueReturnType.equals(TypeItem.NUMBER) && !valueReturnType.equals(TypeItem.UINT) && !valueReturnType.equals(TypeItem.UNBOUNDED);
                break;
            }
            case "float": {
                displayCoerce = !valueReturnType.equals(TypeItem.INT) && !valueReturnType.equals(new TypeItem("float")) && !valueReturnType.equals(TypeItem.UINT) && !valueReturnType.equals(TypeItem.UNBOUNDED);
                break;
            }
            case "int": {
                displayCoerce = !valueReturnType.equals(TypeItem.INT) && !valueReturnType.equals(TypeItem.UNBOUNDED);
                break;
            }
            case "uint": {
                if (valueReturnType.equals(TypeItem.INT) && this.value instanceof IntegerValueAVM2Item) {
                    displayCoerce = ((IntegerValueAVM2Item)this.value).value < 0;
                    break;
                }
                displayCoerce = !valueReturnType.equals(TypeItem.UINT) && !valueReturnType.equals(TypeItem.UNBOUNDED);
                break;
            }
            case "String": {
                displayCoerce = false;
                break;
            }
            default: {
                displayCoerce = false;
            }
        }
        if (displayCoerce) {
            this.typeObj.toString(writer, localData).append("(");
        }
        this.value.toString(writer, localData);
        if (displayCoerce) {
            writer.append(")");
        }
        return writer;
    }

    @Override
    public GraphTargetItem getNotCoerced() {
        return this.value.getNotCoerced();
    }

    @Override
    public GraphTargetItem getNotCoercedNoDup() {
        return this.value.getNotCoercedNoDup();
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (dependencies.contains(this.value)) {
            return false;
        }
        dependencies.add(this.value);
        switch (this.typeObj.toString()) {
            case "String": 
            case "Boolean": 
            case "int": 
            case "uint": 
            case "Number": 
            case "float": 
            case "float4": {
                return this.value.isConvertedCompileTime(dependencies);
            }
        }
        return false;
    }

    @Override
    public Object getResult() {
        Object ret = this.value.getResult();
        switch (this.typeObj.toString()) {
            case "String": {
                if (ret == Null.INSTANCE) {
                    return ret;
                }
                if (ret == Undefined.INSTANCE) {
                    return Null.INSTANCE;
                }
                return this.value.getResultAsString();
            }
        }
        return ret;
    }

    @Override
    public GraphTargetItem returnType() {
        if (this.typeObj instanceof UnboundedTypeItem) {
            return this.typeObj;
        }
        if (this.typeObj instanceof ApplyTypeAVM2Item) {
            return this.typeObj;
        }
        if (this.typeObj instanceof TypeItem) {
            return this.typeObj;
        }
        return new TypeItem(this.typeObj.toString());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        AVM2Instruction ins;
        switch (this.typeObj.toString()) {
            case "*": {
                ins = new AVM2Instruction(0L, 130, null);
                break;
            }
            case "String": {
                ins = new AVM2Instruction(0L, 133, null);
                break;
            }
            case "Boolean": {
                ins = new AVM2Instruction(0L, 118, null);
                break;
            }
            case "int": {
                ins = new AVM2Instruction(0L, 115, null);
                break;
            }
            case "uint": {
                ins = new AVM2Instruction(0L, 116, null);
                break;
            }
            case "Number": {
                ins = new AVM2Instruction(0L, 117, null);
                break;
            }
            case "float": {
                ins = new AVM2Instruction(0L, 121, null);
                break;
            }
            case "float4": {
                ins = new AVM2Instruction(0L, 123, null);
                break;
            }
            case "decimal": {
                if (localData.numberContext != null) {
                    ins = new AVM2Instruction(0L, 122, new int[]{localData.numberContext});
                    break;
                }
                ins = new AVM2Instruction(0L, 121, null);
                break;
            }
            default: {
                int type_index = AVM2SourceGenerator.resolveType(localData, this.typeObj, ((AVM2SourceGenerator)generator).abcIndex);
                ins = new AVM2Instruction(0L, 128, new int[]{type_index});
            }
        }
        return CoerceAVM2Item.toSourceMerge(localData, generator, this.value, ins);
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.typeObj);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoerceAVM2Item other = (CoerceAVM2Item)obj;
        if (!Objects.equals(this.typeObj, other.typeObj)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }
}

