/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class ConstructSuperAVM2Item
extends AVM2Item {
    public GraphTargetItem object;
    public List<GraphTargetItem> args;

    public ConstructSuperAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem object, List<GraphTargetItem> args) {
        super(instruction, lineStartIns, 0);
        this.object = object;
        this.args = args;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.object);
        visitor.visitAll(this.args);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (!this.object.toString().equals("this")) {
            this.object.toString(writer, localData);
            writer.allowWrapHere().append(".");
        }
        writer.spaceBeforeCallParenthesis(this.args.size());
        writer.append("super(");
        for (int a = 0; a < this.args.size(); ++a) {
            if (a > 0) {
                writer.allowWrapHere().append(",");
            }
            this.args.get(a).toString(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return ConstructSuperAVM2Item.toSourceMerge(localData, generator, this.object, this.args, new AVM2Instruction(0L, 73, new int[]{this.args.size()}));
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.object);
        hash = 71 * hash + Objects.hashCode(this.args);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstructSuperAVM2Item other = (ConstructSuperAVM2Item)obj;
        if (!Objects.equals(this.object, other.object)) {
            return false;
        }
        return Objects.equals(this.args, other.args);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

