/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Reference;
import java.util.Objects;
import java.util.Set;

public class GetLexAVM2Item
extends AVM2Item {
    public Multiname propertyName;
    public GraphTargetItem type;
    public GraphTargetItem callType;
    public boolean isStatic;
    private final DottedChain fullPropertyName;

    public GetLexAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, Multiname propertyName, ABC abc, AVM2ConstantPool constants, GraphTargetItem type, GraphTargetItem callType, boolean isStatic, Set<String> usedDeobfuscations) {
        super(instruction, lineStartIns, 0);
        this.propertyName = propertyName;
        this.type = type;
        this.callType = callType;
        this.fullPropertyName = propertyName.getNameWithNamespace(usedDeobfuscations, abc, constants, true);
        this.isStatic = isStatic;
    }

    public String getRawPropertyName() {
        return this.fullPropertyName.toRawString();
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) {
        Reference<Object> customNsRef = new Reference<Object>(null);
        String localName = this.propertyName.getNameAndCustomNamespace(localData.usedDeobfuscations, localData.abc, localData.fullyQualifiedNames, false, true, customNsRef);
        DottedChain customNs = customNsRef.getVal();
        if (customNs != null) {
            String nsname = customNs.getLast();
            String identifier = IdentifiersDeobfuscation.printIdentifier(localData.abc.getSwf(), localData.usedDeobfuscations, true, nsname, new String[0]);
            writer.hilightSpecial(identifier, HighlightSpecialType.TYPE_NAME, customNs.toRawString());
            writer.appendNoHilight("::");
            this.getSrcData().localName = nsname + "::" + localName;
            return writer.append(localName);
        }
        this.getSrcData().localName = localName;
        return writer.append(localName);
    }

    @Override
    public GraphTargetItem returnType() {
        return this.type;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Objects.hashCode(this.propertyName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetLexAVM2Item other = (GetLexAVM2Item)obj;
        return Objects.equals(this.propertyName, other.propertyName);
    }
}

