/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class InAVM2Item
extends AVM2Item {
    public GraphTargetItem object;
    public GraphTargetItem collection;

    public InAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem object, GraphTargetItem collection) {
        super(instruction, lineStartIns, 17);
        this.object = object;
        this.collection = collection;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.object);
        visitor.visit(this.collection);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        this.object.toString(writer, localData);
        writer.append(" in ");
        return this.collection.toString(writer, localData);
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.BOOLEAN;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return InAVM2Item.toSourceMerge(localData, generator, this.object, this.collection, InAVM2Item.ins(180, new Integer[0]));
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + Objects.hashCode(this.object);
        hash = 89 * hash + Objects.hashCode(this.collection);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InAVM2Item other = (InAVM2Item)obj;
        if (!Objects.equals(this.object, other.object)) {
            return false;
        }
        return Objects.equals(this.collection, other.collection);
    }
}

