/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.ThisAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.UndefinedAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.clauses.FilterAVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Set;

public class LocalRegAVM2Item
extends AVM2Item {
    public final int regIndex;
    public GraphTargetItem computedValue;
    public GraphTargetItem type;
    private final Object computedResult;
    private boolean isCT = false;

    public LocalRegAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, int regIndex, GraphTargetItem computedValue, GraphTargetItem type) {
        super(instruction, lineStartIns, 0);
        this.regIndex = regIndex;
        if (computedValue == null) {
            this.computedResult = null;
        } else if (computedValue.isCompileTime()) {
            this.computedResult = computedValue.getResult();
            this.isCT = true;
        } else {
            this.computedResult = null;
        }
        this.computedValue = computedValue;
        this.type = type;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        String localName;
        if (this.computedValue instanceof FilterAVM2Item) {
            return this.computedValue.toString(writer, localData);
        }
        this.getSrcData().localName = localName = LocalRegAVM2Item.localRegName(localData.abc.getSwf(), localData.localRegNames, this.regIndex, localData.usedDeobfuscations);
        return writer.append(localName);
    }

    @Override
    public GraphTargetItem getThroughRegister() {
        if (this.computedValue == null) {
            return this;
        }
        return this.computedValue.getThroughRegister();
    }

    @Override
    public Object getResult() {
        if (this.computedValue == null) {
            return null;
        }
        return this.computedValue.getResult();
    }

    @Override
    public Double getResultAsNumber() {
        if (this.computedValue == null) {
            return null;
        }
        return this.computedValue.getResultAsNumber();
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        return this.computedValue instanceof UndefinedAVM2Item;
    }

    @Override
    public boolean isConvertedCompileTime(Set<GraphTargetItem> dependencies) {
        if (this.computedValue == null) {
            return false;
        }
        return this.computedValue instanceof ThisAVM2Item && this.computedValue.isConvertedCompileTime(dependencies);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        AVM2Instruction ins;
        switch (this.regIndex) {
            case 0: {
                ins = new AVM2Instruction(0L, 208, null);
                break;
            }
            case 1: {
                ins = new AVM2Instruction(0L, 209, null);
                break;
            }
            case 2: {
                ins = new AVM2Instruction(0L, 210, null);
                break;
            }
            case 3: {
                ins = new AVM2Instruction(0L, 211, null);
                break;
            }
            default: {
                ins = new AVM2Instruction(0L, 98, new int[]{this.regIndex});
            }
        }
        return LocalRegAVM2Item.toSourceMerge(localData, generator, ins);
    }

    @Override
    public GraphTargetItem returnType() {
        return this.type;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + this.regIndex;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalRegAVM2Item other = (LocalRegAVM2Item)obj;
        return this.regIndex == other.regIndex;
    }
}

