/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types;

import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.graph.DottedChain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class NamespaceSet {
    @Internal
    public boolean deleted;
    public int[] namespaces;

    public NamespaceSet() {
    }

    public NamespaceSet(int[] namespaces) {
        this.namespaces = namespaces;
    }

    public String toString(AVM2ConstantPool constants) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.namespaces.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(constants.getNamespace(this.namespaces[i]).getNameWithKind(constants));
        }
        return sb.toString();
    }

    public boolean isApiVersioned(AVM2ConstantPool constants) {
        HashSet<String> namespaceNames = new HashSet<String>();
        HashSet<Integer> namespaceKinds = new HashSet<Integer>();
        for (int n : this.namespaces) {
            Namespace ns = constants.getNamespace(n);
            String nsName = ns.getRawName(constants);
            if (nsName == null || nsName.length() <= 0) continue;
            int lastChar = nsName.codePointAt(nsName.length() - 1);
            if (lastChar >= 57344 && lastChar <= 63743) {
                namespaceNames.add(nsName.substring(0, nsName.length() - 1));
                namespaceKinds.add(ns.kind);
                continue;
            }
            return false;
        }
        if (namespaceNames.size() != 1) {
            return false;
        }
        return namespaceKinds.size() == 1;
    }

    public List<Integer> getApiVersions(AVM2ConstantPool constants) {
        HashSet<String> namespaceNames = new HashSet<String>();
        HashSet<Integer> namespaceKinds = new HashSet<Integer>();
        ArrayList<Integer> apiVersions = new ArrayList<Integer>();
        for (int n : this.namespaces) {
            Namespace ns = constants.getNamespace(n);
            String nsName = ns.getRawName(constants);
            if (nsName == null || nsName.length() <= 0) continue;
            int lastChar = nsName.codePointAt(nsName.length() - 1);
            if (lastChar >= 57344 && lastChar <= 63743) {
                namespaceNames.add(nsName.substring(0, nsName.length() - 1));
                namespaceKinds.add(ns.kind);
                int apiVersion = lastChar - 57344;
                if (apiVersion == 0) continue;
                apiVersions.add(apiVersion);
                continue;
            }
            return new ArrayList<Integer>();
        }
        if (namespaceNames.size() != 1) {
            return new ArrayList<Integer>();
        }
        if (namespaceKinds.size() != 1) {
            return new ArrayList<Integer>();
        }
        return apiVersions;
    }

    public int getNonversionedKind(AVM2ConstantPool constants) {
        HashSet<String> namespaceNames = new HashSet<String>();
        HashSet<Integer> namespaceKinds = new HashSet<Integer>();
        for (int n : this.namespaces) {
            Namespace ns = constants.getNamespace(n);
            String nsName = ns.getRawName(constants);
            namespaceKinds.add(ns.kind);
            if (nsName != null && nsName.length() > 0) {
                int lastChar = nsName.codePointAt(nsName.length() - 1);
                if (lastChar >= 57344 && lastChar <= 63743) {
                    namespaceNames.add(nsName.substring(0, nsName.length() - 1));
                    continue;
                }
                namespaceNames.add(nsName);
                continue;
            }
            namespaceNames.add(nsName);
        }
        if (namespaceNames.size() != 1) {
            return 0;
        }
        if (namespaceKinds.size() != 1) {
            return 0;
        }
        return (Integer)namespaceKinds.iterator().next();
    }

    public DottedChain getNonversionedName(AVM2ConstantPool constants) {
        HashSet<String> namespaceNames = new HashSet<String>();
        for (int n : this.namespaces) {
            String nsName = constants.getNamespace(n).getRawName(constants);
            if (nsName != null && nsName.length() > 0) {
                int lastChar = nsName.codePointAt(nsName.length() - 1);
                if (lastChar >= 57344 && lastChar <= 63743) {
                    namespaceNames.add(nsName.substring(0, nsName.length() - 1));
                    continue;
                }
                namespaceNames.add(nsName);
                continue;
            }
            namespaceNames.add(nsName);
        }
        if (namespaceNames.size() != 1) {
            return null;
        }
        return DottedChain.parseNoSuffix((String)namespaceNames.iterator().next());
    }
}

