/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action;

import com.jpexs.decompiler.flash.AppResources;
import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.DisassemblyListener;
import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.ValueTooLargeException;
import com.jpexs.decompiler.flash.action.ActionGraph;
import com.jpexs.decompiler.flash.action.ActionGraphTargetDialect;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.ActionLocalData;
import com.jpexs.decompiler.flash.action.ActionTreeOperation;
import com.jpexs.decompiler.flash.action.ConstantPoolTooBigException;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.as2.Trait;
import com.jpexs.decompiler.flash.action.deobfuscation.ActionDeobfuscator;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.ConstantPool;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.FunctionActionItem;
import com.jpexs.decompiler.flash.action.model.GetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.GetPropertyActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.SetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.SetPropertyActionItem;
import com.jpexs.decompiler.flash.action.model.SetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.StoreRegisterActionItem;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.ASMParsedSymbol;
import com.jpexs.decompiler.flash.action.parser.pcode.FlasmLexer;
import com.jpexs.decompiler.flash.action.parser.script.VariableActionItem;
import com.jpexs.decompiler.flash.action.special.ActionEnd;
import com.jpexs.decompiler.flash.action.special.ActionStore;
import com.jpexs.decompiler.flash.action.swf3.ActionSetTarget;
import com.jpexs.decompiler.flash.action.swf4.ActionIf;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.ActionSetTarget2;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionConstantPool;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineFunction;
import com.jpexs.decompiler.flash.action.swf5.ActionWith;
import com.jpexs.decompiler.flash.action.swf7.ActionDefineFunction2;
import com.jpexs.decompiler.flash.action.swf7.ActionTry;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.helpers.SWFDecompilerPlugin;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphPartChangeException;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SecondPassData;
import com.jpexs.decompiler.graph.SecondPassException;
import com.jpexs.decompiler.graph.TranslateException;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.CommentItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.ScriptEndItem;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Reference;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Action
implements GraphSourceItem {
    private static final int INFORM_LISTENER_RESOLUTION = 1000;
    private boolean ignored = false;
    public long fileOffset = -1L;
    private int actionCode;
    protected int actionLength;
    private long address;
    private long virtualAddress = -1L;
    protected String charset;
    public static final String[] propertyNames = new String[]{"_X", "_Y", "_xscale", "_yscale", "_currentframe", "_totalframes", "_alpha", "_visible", "_width", "_height", "_rotation", "_target", "_framesloaded", "_name", "_droptarget", "_url", "_highquality", "_focusrect", "_soundbuftime", "_quality", "_xmouse", "_ymouse"};
    public static final List<String> propertyNamesList = Arrays.asList(propertyNames);
    public static final List<String> propertyNamesListLowerCase = new ArrayList<String>();
    private static final Logger logger;

    @Override
    public long getLineOffset() {
        return this.fileOffset;
    }

    public String getCharset() {
        return this.charset;
    }

    public Action(int actionCode, int actionLength, String charset) {
        this.actionCode = actionCode;
        this.actionLength = actionLength;
        this.charset = charset;
    }

    public Action() {
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    public int getActionCode() {
        return this.actionCode;
    }

    public void getRef(Set<Long> refs) {
    }

    public static Set<Long> getActionsAllRefs(List<Action> list) {
        HashSet<Long> ret = new HashSet<Long>();
        for (Action a : list) {
            a.getRef(ret);
        }
        return ret;
    }

    public int getTotalActionLength() {
        return this.actionLength + 1 + (this.actionCode >= 128 ? 2 : 0);
    }

    public void setAddress(long address) {
        this.address = address;
    }

    public String toString() {
        return "Action" + this.actionCode;
    }

    protected String lexString(FlasmLexer lex) throws IOException, ActionParseException {
        ASMParsedSymbol symb = lex.lex();
        if (symb.type != 1) {
            throw new ActionParseException("String expected", lex.yyline());
        }
        return (String)symb.value;
    }

    protected void lexBlockOpen(FlasmLexer lex) throws IOException, ActionParseException {
        ASMParsedSymbol symb = lex.lex();
        if (symb.type != 10) {
            throw new ActionParseException("Block startServer ", lex.yyline());
        }
    }

    protected String lexIdentifier(FlasmLexer lex) throws IOException, ActionParseException {
        ASMParsedSymbol symb = lex.lex();
        if (symb.type != 6) {
            throw new ActionParseException("Identifier expected", lex.yyline());
        }
        return (String)symb.value;
    }

    protected long lexLong(FlasmLexer lex) throws IOException, ActionParseException {
        ASMParsedSymbol symb = lex.lex();
        if (symb.type != 4) {
            throw new ActionParseException("Integer expected", lex.yyline());
        }
        return (Long)symb.value;
    }

    protected boolean lexBoolean(FlasmLexer lex) throws IOException, ActionParseException {
        ASMParsedSymbol symb = lex.lex();
        if (symb.type != 11) {
            throw new ActionParseException("Boolean expected", lex.yyline());
        }
        return (Boolean)symb.value;
    }

    protected void lexOptionalComma(FlasmLexer lex) throws IOException, ActionParseException {
        ASMParsedSymbol symb = lex.lex();
        if (symb.type != 18) {
            lex.pushback(symb);
        }
    }

    public final byte[] getBytes(int version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(baos, version, this.charset);
        try {
            this.getContentBytes(sos);
            sos.close();
        }
        catch (IOException e) {
            throw new Error("This should never happen.", e);
        }
        return this.surroundWithAction(baos.toByteArray(), version);
    }

    protected void getContentBytes(SWFOutputStream sos) throws IOException {
    }

    @Override
    public final int getBytesLength() {
        return this.getContentBytesLength() + (this.actionCode >= 128 ? 3 : 1);
    }

    protected int getContentBytesLength() {
        return 0;
    }

    public void updateLength() {
        int length = this.getBytesLength();
        this.actionLength = length - 1 - (this.actionCode >= 128 ? 2 : 0);
    }

    private byte[] surroundWithAction(byte[] data, int version) {
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        SWFOutputStream sos2 = new SWFOutputStream(baos2, version, this.charset);
        try {
            sos2.writeUI8(this.actionCode);
            if (this.actionCode >= 128) {
                sos2.writeUI16(data.length);
            }
            sos2.write(data);
            sos2.close();
        }
        catch (IOException e) {
            throw new Error("This should never happen.", e);
        }
        return baos2.toByteArray();
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    public static byte[] actionsToBytes(List<Action> list, boolean addZero, int version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Action lastAction = null;
        for (Action a : list) {
            try {
                lastAction = a;
                baos.write(a.getBytes(version));
            }
            catch (IOException iOException) {}
        }
        if (addZero && (lastAction == null || !(lastAction instanceof ActionEnd))) {
            baos.write(0);
        }
        return baos.toByteArray();
    }

    public static ByteArrayRange actionsToByteArrayRange(List<Action> list, boolean addZero, int version) {
        byte[] bytes = Action.actionsToBytes(list, addZero, version);
        return new ByteArrayRange(bytes);
    }

    public static void setConstantPools(ASMSource src, List<List<String>> constantPools, boolean tryInline) throws ConstantPoolTooBigException {
        try {
            ActionList actions = src.getActions();
            int poolIdx = 0;
            for (Action action : actions) {
                if (!(action instanceof ActionConstantPool)) continue;
                ActionConstantPool cPool = (ActionConstantPool)action;
                List<String> constantPool = constantPools.get(poolIdx);
                int size = ActionConstantPool.calculateSize(constantPool, action.getCharset());
                if (size > 65535 && tryInline) {
                    for (int i = 0; i < constantPool.size(); ++i) {
                        int refCount = actions.getConstantPoolIndexReferenceCount(i);
                        if (refCount != 1) continue;
                        actions.inlineConstantPoolString(i, constantPool.get(i));
                        constantPool.set(i, "");
                    }
                    size = ActionConstantPool.calculateSize(constantPool, action.getCharset());
                }
                if (size > 65535) {
                    throw new ConstantPoolTooBigException(poolIdx, size);
                }
                cPool.constantPool = constantPool;
                if (constantPools.size() > ++poolIdx) continue;
                break;
            }
            actions.removeNonReferencedConstantPoolItems();
            src.setActions(actions);
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public static void setActionsAddresses(List<Action> list, long baseAddress) {
        long offset = baseAddress;
        for (Action a : list) {
            a.setAddress(offset);
            offset += (long)a.getTotalActionLength();
        }
    }

    private static void informListeners(List<DisassemblyListener> listeners, int pos, int count) {
        DisassemblyListener[] listenersArray;
        for (DisassemblyListener listener : listenersArray = listeners.toArray(new DisassemblyListener[listeners.size()])) {
            listener.progressToString(pos + 1, count);
        }
    }

    public static GraphTextWriter actionsToString(List<DisassemblyListener> listeners, long address, ActionList list, int version, ScriptExportMode exportMode, GraphTextWriter writer) {
        if (exportMode == ScriptExportMode.CONSTANTS) {
            return Action.constantPoolActionsToString(listeners, address, list, version, exportMode, writer);
        }
        Set<Long> importantOffsets = Action.getActionsAllRefs(list);
        HashMap containers = new HashMap();
        HashMap<GraphSourceItemContainer, Integer> containersPos = new HashMap<GraphSourceItemContainer, Integer>();
        long offset = address;
        boolean lastPush = false;
        byte[] fileData = list.fileData;
        for (int pos = 0; pos < list.size(); ++pos) {
            Action a = (Action)list.get(pos);
            if ((pos + 1) % 1000 == 0) {
                Action.informListeners(listeners, pos, list.size());
            }
            if (exportMode == ScriptExportMode.PCODE_HEX) {
                byte[] bytes;
                if (lastPush) {
                    writer.newLine();
                    lastPush = false;
                }
                writer.appendNoHilight("; ");
                long fileOffset = a.getFileOffset();
                if (Configuration.showFileOffsetInPcodeHex.get().booleanValue()) {
                    writer.appendNoHilight("@");
                    writer.appendNoHilight(Helper.formatHex(fileOffset, 8));
                    writer.appendNoHilight(" ");
                }
                try {
                    bytes = a.getBytes(version);
                    writer.appendNoHilight(Helper.bytesToHexString(bytes));
                }
                catch (ValueTooLargeException tooLarge) {
                    bytes = new byte[]{};
                    writer.appendNoHilight("!TOO LARGE!");
                }
                if (Configuration.showOriginalBytesInPcodeHex.get().booleanValue() && fileData != null && fileOffset != -1L && (long)fileData.length > fileOffset + (long)bytes.length - 1L) {
                    int i;
                    boolean same = true;
                    for (i = 0; i < bytes.length; ++i) {
                        byte b = fileData[(int)(fileOffset + (long)i)];
                        if (b == bytes[i]) continue;
                        same = false;
                        break;
                    }
                    if (!same) {
                        writer.appendNoHilight(" (");
                        for (i = 0; i < bytes.length; ++i) {
                            if (i != 0) {
                                writer.appendNoHilight(" ");
                            }
                            writer.appendNoHilight(Helper.byteToHex(fileData[(int)(fileOffset + (long)i)]));
                        }
                        writer.appendNoHilight(")");
                    }
                }
                writer.newLine();
            }
            offset = a.getAddress();
            if (!a.isIgnored() && a instanceof GraphSourceItemContainer) {
                GraphSourceItemContainer cnt = (GraphSourceItemContainer)((Object)a);
                containersPos.put(cnt, 0);
                List<Long> sizes = cnt.getContainerSizes();
                long addr = ((Action)((Object)cnt)).getAddress() + cnt.getHeaderSize();
                for (Long size : sizes) {
                    if (!containers.containsKey(addr += size.longValue())) {
                        containers.put(addr, new ArrayList());
                    }
                    ((List)containers.get(addr)).add(cnt);
                }
            }
            if (containers.containsKey(offset)) {
                for (int i = ((List)containers.get(offset)).size() - 1; i >= 0; --i) {
                    GraphSourceItemContainer cnt = (GraphSourceItemContainer)((List)containers.get(offset)).get(i);
                    int cntPos = (Integer)containersPos.get(cnt);
                    if (lastPush) {
                        writer.newLine();
                        lastPush = false;
                    }
                    writer.appendNoHilight("}").newLine();
                    writer.appendNoHilight(cnt.getASMSourceBetween(cntPos));
                    containersPos.put(cnt, ++cntPos);
                }
            }
            if (Configuration.showAllAddresses.get().booleanValue() || importantOffsets.contains(offset)) {
                if (lastPush) {
                    writer.newLine();
                    lastPush = false;
                }
                writer.appendNoHilight("loc");
                writer.appendNoHilight(Helper.formatAddress(offset));
                writer.appendNoHilight(":");
            }
            if (a.isIgnored()) {
                if (lastPush) {
                    writer.newLine();
                    lastPush = false;
                }
                if (!(a instanceof ActionEnd)) {
                    int len = a.getTotalActionLength();
                    for (int i = 0; i < len; ++i) {
                        writer.appendNoHilight("Nop").newLine();
                    }
                }
            } else {
                String add = "";
                if (lastPush) {
                    writer.newLine();
                }
                writer.append("", offset, a.getFileOffset());
                int fixBranch = -1;
                if (a instanceof ActionIf) {
                    ActionIf aif = (ActionIf)a;
                    if (aif.jumpUsed && !aif.ignoreUsed) {
                        fixBranch = 0;
                    }
                    if (!aif.jumpUsed && aif.ignoreUsed) {
                        fixBranch = 1;
                    }
                }
                if (fixBranch > -1) {
                    writer.appendNoHilight("FFDec_DeobfuscatePop");
                    if (fixBranch == 0) {
                        writer.newLine();
                        writer.appendNoHilight("Jump loc");
                        writer.appendNoHilight(Helper.formatAddress(((ActionIf)a).getTargetAddress()));
                    }
                } else {
                    a.getASMSourceReplaced(list, importantOffsets, exportMode, writer);
                }
                writer.appendNoHilight(a.isIgnored() ? "; ignored" : "");
                writer.appendNoHilight(add);
                if (!(a instanceof ActionPush)) {
                    writer.newLine();
                }
                lastPush = a instanceof ActionPush;
            }
            offset += (long)a.getTotalActionLength();
        }
        if (lastPush) {
            writer.newLine();
        }
        if (containers.containsKey(offset)) {
            for (int i = 0; i < ((List)containers.get(offset)).size(); ++i) {
                writer.appendNoHilight("}");
                writer.newLine();
                GraphSourceItemContainer cnt = (GraphSourceItemContainer)((List)containers.get(offset)).get(i);
                int cntPos = (Integer)containersPos.get(cnt);
                writer.appendNoHilight(cnt.getASMSourceBetween(cntPos));
                containersPos.put(cnt, ++cntPos);
            }
        }
        if (importantOffsets.contains(offset)) {
            writer.appendNoHilight("loc");
            writer.appendNoHilight(Helper.formatAddress(offset));
            writer.appendNoHilight(":");
            writer.newLine();
        }
        return writer;
    }

    public static GraphTextWriter constantPoolActionsToString(List<DisassemblyListener> listeners, long address, ActionList list, int version, ScriptExportMode exportMode, GraphTextWriter writer) {
        int poolIdx = 0;
        writer.appendNoHilight(Helper.constants).newLine();
        for (Action a : list) {
            if (!(a instanceof ActionConstantPool)) continue;
            if (poolIdx > 0) {
                writer.appendNoHilight("---").newLine();
            }
            ActionConstantPool cPool = (ActionConstantPool)a;
            int constIdx = 0;
            for (String c : cPool.constantPool) {
                writer.appendNoHilight(constIdx);
                writer.appendNoHilight("|");
                writer.appendNoHilight(Helper.escapeString(c));
                writer.newLine();
                ++constIdx;
            }
            ++poolIdx;
        }
        return writer;
    }

    public String getASMSource(ActionList container, Set<Long> knownAddresses, ScriptExportMode exportMode) {
        return this.toString();
    }

    public abstract boolean execute(LocalDataArea var1);

    @Override
    public int getStackPopCount(BaseLocalData localData, TranslateStack stack) {
        return 0;
    }

    @Override
    public int getStackPushCount(BaseLocalData localData, TranslateStack stack) {
        return 0;
    }

    protected long popLong(TranslateStack stack) {
        GraphTargetItem item = stack.pop();
        if (item instanceof DirectValueActionItem) {
            return (long)EcmaScript.toNumberAs2(((DirectValueActionItem)item).value).doubleValue();
        }
        return 0L;
    }

    public static long ip2adr(List<Action> actions, int ip) {
        if (ip >= actions.size()) {
            if (actions.isEmpty()) {
                return 0L;
            }
            return actions.get(actions.size() - 1).getAddress() + (long)actions.get(actions.size() - 1).getTotalActionLength();
        }
        if (ip == -1) {
            return 0L;
        }
        return actions.get(ip).getAddress();
    }

    public static int adr2ip(List<Action> actions, long addr) {
        long outpos;
        for (int ip = 0; ip < actions.size(); ++ip) {
            if (actions.get(ip).getAddress() != addr) continue;
            return ip;
        }
        if (actions.size() > 0 && addr == (outpos = actions.get(actions.size() - 1).getAddress() + (long)actions.get(actions.size() - 1).getTotalActionLength())) {
            return actions.size();
        }
        return -1;
    }

    public static GraphTextWriter actionsToSource(Map<String, Map<String, Trait>> uninitializedClassTraits, ASMSource asm, List<Action> actions, String path, GraphTextWriter writer, String charset) throws InterruptedException {
        return Action.actionsToSource(uninitializedClassTraits, asm, actions, path, writer, charset, new ArrayList<ActionTreeOperation>());
    }

    public static GraphTextWriter actionsToSource(final Map<String, Map<String, Trait>> uninitializedClassTraits, final ASMSource asm, final List<Action> actions, final String path, GraphTextWriter writer, final String charset, final List<ActionTreeOperation> treeOperations) throws InterruptedException {
        writer.suspendMeasure();
        final Set<String> usedDeobfuscations = Collections.synchronizedSet(new LinkedHashSet());
        List<GraphTargetItem> tree = null;
        Throwable convertException = null;
        int timeout = Configuration.decompilationTimeoutSingleMethod.get();
        final SWF swf = asm == null ? null : asm.getSwf();
        final int version = swf == null ? 10 : swf.version;
        try {
            tree = CancellableWorker.call("script.actionsToSource", new Callable<List<GraphTargetItem>>(){

                @Override
                public List<GraphTargetItem> call() throws Exception {
                    int staticOperation = 0;
                    boolean insideDoInitAction = asm instanceof DoInitActionTag;
                    List<GraphTargetItem> tree = Action.actionsToTree(usedDeobfuscations, asm == null ? false : swf.needsCalculatingAS2UninitializeClassTraits(asm), uninitializedClassTraits, insideDoInitAction, false, new HashMap<Integer, String>(), new HashMap<String, GraphTargetItem>(), new HashMap<String, GraphTargetItem>(), actions, version, staticOperation, path, charset);
                    SWFDecompilerPlugin.fireActionTreeCreated(tree, swf);
                    for (ActionTreeOperation treeOperation : treeOperations) {
                        treeOperation.run(tree);
                    }
                    if (Configuration.autoDeobfuscate.get().booleanValue()) {
                        new ActionDeobfuscator().actionTreeCreated(tree, swf);
                    }
                    Graph.graphToString(tree, new NulWriter(), LocalData.create(new ConstantPool(), swf, usedDeobfuscations));
                    return tree;
                }
            }, timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Exception | OutOfMemoryError | StackOverflowError ex) {
            convertException = ex;
            Throwable cause = ex.getCause();
            if (ex instanceof ExecutionException && cause instanceof Exception) {
                convertException = cause;
            }
            if (ex instanceof ExecutionException && cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            if (convertException instanceof TimeoutException) {
                logger.log(Level.SEVERE, "Decompilation timeout in: " + path, convertException);
            }
            logger.log(Level.SEVERE, "Decompilation error in: " + path, convertException);
        }
        writer.continueMeasure();
        if (asm != null) {
            asm.getActionSourcePrefix(writer);
        }
        if (convertException == null) {
            Graph.graphToString(tree, writer, LocalData.create(new ConstantPool(), swf, usedDeobfuscations));
        } else if (convertException instanceof TimeoutException) {
            Helper.appendTimeoutCommentAs2(writer, timeout, actions.size());
        } else {
            Helper.appendErrorComment(writer, convertException);
        }
        if (asm != null) {
            asm.getActionSourceSuffix(writer);
        }
        IdentifiersDeobfuscation.writeCurrentScriptReplacements(writer, usedDeobfuscations, swf);
        return writer;
    }

    public static List<GraphTargetItem> actionsToTree(Set<String> usedDeobfuscations, boolean needsUninitializedClassFieldsDetection, Map<String, Map<String, Trait>> uninitializedClassTraits, boolean insideDoInitAction, boolean insideFunction, List<Action> actions, int version, int staticOperation, String path, String charset) throws InterruptedException {
        return Action.actionsToTree(usedDeobfuscations, needsUninitializedClassFieldsDetection, uninitializedClassTraits, insideDoInitAction, insideFunction, new HashMap<Integer, String>(), new HashMap<String, GraphTargetItem>(), new HashMap<String, GraphTargetItem>(), actions, version, staticOperation, path, charset);
    }

    public static List<GraphTargetItem> actionsToTree(Set<String> usedDeobfuscations, boolean needsUninitializedClassFieldsDetection, Map<String, Map<String, Trait>> uninitializedClassTraits, boolean insideDoInitAction, boolean insideFunction, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, List<Action> actions, int version, int staticOperation, String path, String charset) throws InterruptedException {
        LinkedHashMap<String, GraphTargetItem> variablesBackup = new LinkedHashMap<String, GraphTargetItem>(variables);
        LinkedHashMap<String, GraphTargetItem> functionsBackup = new LinkedHashMap<String, GraphTargetItem>(functions);
        try {
            return ActionGraph.translateViaGraph(usedDeobfuscations, needsUninitializedClassFieldsDetection, uninitializedClassTraits, null, insideDoInitAction, insideFunction, regNames, variables, functions, Action.crippleActionsClassHeader(actions, needsUninitializedClassFieldsDetection, charset, path), version, staticOperation, path, charset, 0);
        }
        catch (SecondPassException spe) {
            variables.clear();
            variables.putAll(variablesBackup);
            functions.clear();
            functions.putAll(functionsBackup);
            return ActionGraph.translateViaGraph(usedDeobfuscations, needsUninitializedClassFieldsDetection, uninitializedClassTraits, spe.getData(), insideDoInitAction, insideFunction, regNames, variables, functions, actions, version, staticOperation, path, charset, 0);
        }
    }

    private static List<Action> crippleActionsClassHeader(List<Action> actions, boolean needsUninitializedClassFieldsDetection, String charset, String path) {
        return actions;
    }

    public void translate(Set<String> usedDeobfuscations, Map<String, Map<String, Trait>> uninitializedClassTraits, SecondPassData secondPassData, boolean insideDoInitAction, GraphSourceItem lineStartIns, TranslateStack stack, List<GraphTargetItem> output, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, int staticOperation, String path) throws InterruptedException {
    }

    @Override
    public void translate(BaseLocalData localData, TranslateStack stack, List<GraphTargetItem> output, int staticOperation, String path) throws InterruptedException {
        ActionLocalData aLocalData = (ActionLocalData)localData;
        this.translate(localData.usedDeobfuscations, aLocalData.uninitializedClassTraits, aLocalData.secondPassData, aLocalData.insideDoInitAction, aLocalData.lineStartAction, stack, output, aLocalData.regNames, aLocalData.variables, aLocalData.functions, staticOperation, path);
    }

    @Override
    public boolean isJump() {
        return false;
    }

    @Override
    public boolean isBranch() {
        return false;
    }

    @Override
    public boolean isExit() {
        return false;
    }

    @Override
    public List<Integer> getBranches(GraphSource code) {
        return new ArrayList<Integer>();
    }

    @Override
    public boolean isIgnored() {
        return this.ignored;
    }

    @Override
    public void setIgnored(boolean ignored, int pos) {
        this.ignored = ignored;
    }

    private static HashMap<String, GraphTargetItem> prepareVariables(GraphSourceItemContainer cnt, HashMap<String, GraphTargetItem> variables) {
        LinkedHashMap<String, GraphTargetItem> variables2 = new LinkedHashMap<String, GraphTargetItem>(variables);
        if (cnt instanceof ActionDefineFunction || cnt instanceof ActionDefineFunction2) {
            for (int r = 0; r < 256; ++r) {
                if (!variables2.containsKey("__register" + r)) continue;
                variables2.remove("__register" + r);
            }
        }
        return variables2;
    }

    public static void actionsPartToTree(Set<String> usedDeobfuscations, List<GraphTargetItem> output, ActionGraph graph, Set<GraphPart> switchParts, SecondPassData secondPassData, boolean insideDoInitAction, Reference<GraphSourceItem> lineStartActionRef, HashMap<Integer, String> registerNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, TranslateStack stack, List<Action> actions, int start, int end, int version, int staticOperation, String path, String charset) throws InterruptedException, GraphPartChangeException {
        if (start < actions.size() && end > 0 && start > 0) {
            logger.log(Level.FINE, "Entering {0}-{1}{2}", new Object[]{start, end, actions.size() > 0 ? " (" + actions.get(start).toString() + " - " + actions.get(end == actions.size() ? end - 1 : end) + ")" : ""});
        }
        ActionLocalData localData = new ActionLocalData(switchParts, secondPassData, insideDoInitAction, registerNames, variables, functions, graph.getUninitializedClassTraits(), usedDeobfuscations);
        localData.lineStartAction = lineStartActionRef.getVal();
        int ip = start;
        boolean isWhile = false;
        boolean isForIn = false;
        Object inItem = null;
        boolean loopStart = false;
        while (ip <= end) {
            Action action;
            long addr = Action.ip2adr(actions, ip);
            if (ip > end) break;
            if (ip >= actions.size()) {
                output.add(new ScriptEndItem(ActionGraphTargetDialect.INSTANCE));
                break;
            }
            if (Configuration.simplifyExpressions.get().booleanValue()) {
                stack.simplify();
            }
            if ((action = actions.get(ip)).isIgnored()) {
                ++ip;
                continue;
            }
            boolean isStackEmpty = true;
            for (int i = 0; i < stack.size(); ++i) {
                if (stack.get(i) instanceof FunctionActionItem) continue;
                isStackEmpty = false;
                break;
            }
            if (isStackEmpty) {
                localData.lineStartAction = action;
                lineStartActionRef.setVal(action);
            }
            if (action instanceof GraphSourceItemContainer) {
                GraphSourceItemContainer cnt = (GraphSourceItemContainer)((Object)action);
                long endAddr = action.getAddress() + cnt.getHeaderSize();
                String cntName = cnt.getName();
                ArrayList<List<GraphTargetItem>> outs = new ArrayList<List<GraphTargetItem>>();
                HashMap<String, GraphTargetItem> variables2 = Action.prepareVariables(cnt, variables);
                for (long size : cnt.getContainerSizes()) {
                    List<Object> out;
                    if (size == 0L) {
                        outs.add(new ArrayList());
                        continue;
                    }
                    try {
                        HashMap<Integer, String> regNames = cnt.getRegNames();
                        if (action instanceof ActionWith || action instanceof ActionTry) {
                            for (Map.Entry<Integer, String> e : registerNames.entrySet()) {
                                if (regNames.containsKey(e.getKey())) continue;
                                regNames.put(e.getKey(), e.getValue());
                            }
                        }
                        int startIp = Action.adr2ip(actions, endAddr);
                        try {
                            out = ActionGraph.translateViaGraph(usedDeobfuscations, graph.doesNeedUninitializedClassFieldsDetection(), graph.getUninitializedClassTraits(), null, insideDoInitAction, true, regNames, variables2, functions, actions.subList(0, Action.adr2ip(actions, endAddr + size)), version, staticOperation, path + (cntName == null ? "" : "/" + cntName), charset, startIp);
                        }
                        catch (SecondPassException spe) {
                            variables2 = Action.prepareVariables(cnt, variables);
                            out = ActionGraph.translateViaGraph(usedDeobfuscations, graph.doesNeedUninitializedClassFieldsDetection(), graph.getUninitializedClassTraits(), spe.getData(), insideDoInitAction, true, regNames, variables2, functions, actions.subList(0, Action.adr2ip(actions, endAddr + size)), version, staticOperation, path + (cntName == null ? "" : "/" + cntName), charset, startIp);
                        }
                    }
                    catch (TranslateException | OutOfMemoryError | StackOverflowError ex) {
                        logger.log(Level.SEVERE, "Decompilation error in: " + path, ex);
                        if (ex instanceof OutOfMemoryError) {
                            Helper.freeMem();
                        }
                        out = new ArrayList();
                        String[] lines = new String[]{"", " * " + AppResources.translate("decompilationError"), " * " + AppResources.translate("decompilationError.obfuscated"), Helper.decompilationErrorAdd == null ? null : " * " + Helper.decompilationErrorAdd, " * " + AppResources.translate("decompilationError.errorType") + ": " + ex.getClass().getSimpleName(), ""};
                        out.add(new CommentItem(lines));
                    }
                    outs.add(out);
                    endAddr += size;
                }
                ((GraphSourceItemContainer)((Object)action)).translateContainer(outs, action, stack, output, registerNames, variables, functions);
                ip = Action.adr2ip(actions, endAddr);
                continue;
            }
            int nip = graph.checkIp(ip);
            if (nip != ip) {
                ip = nip;
                if (ip > end) break;
                action = actions.get(ip);
            }
            if (action instanceof ActionStore) {
                ActionStore store = (ActionStore)((Object)action);
                store.setStore(actions.subList(ip + 1, ip + 1 + store.getStoreSize()));
                ip = ip + 1 + store.getStoreSize() - 1;
            }
            action.translate(localData, stack, output, staticOperation, path);
            if ((action instanceof ActionSetTarget || action instanceof ActionSetTarget2) && !stack.isEmpty()) {
                GraphTargetItem lastItem = output.remove(output.size() - 1);
                graph.makeAllCommands(output, stack);
                output.add(lastItem);
            }
            ++ip;
        }
        if (ip > end + 1) {
            throw new GraphPartChangeException(output, ip);
        }
        logger.log(Level.FINE, "Leaving {0}-{1}", new Object[]{start, end});
    }

    public static GraphTargetItem getWithoutGlobal(GraphTargetItem ti) {
        GraphTargetItem t = ti;
        if (!(t instanceof GetMemberActionItem)) {
            return ti;
        }
        GetMemberActionItem lastMember = null;
        while (((GetMemberActionItem)t).object instanceof GetMemberActionItem) {
            lastMember = (GetMemberActionItem)t;
            t = ((GetMemberActionItem)t).object;
        }
        if (((GetMemberActionItem)t).object instanceof GetVariableActionItem) {
            GetVariableActionItem v = (GetVariableActionItem)((GetMemberActionItem)t).object;
            if (v.name instanceof DirectValueActionItem && ((DirectValueActionItem)v.name).value instanceof String && ((DirectValueActionItem)v.name).value.equals("_global")) {
                GetVariableActionItem gvt = new GetVariableActionItem(null, null, ((GetMemberActionItem)t).memberName);
                if (lastMember == null) {
                    return gvt;
                }
                lastMember.object = gvt;
            }
        }
        return ti;
    }

    public static void setConstantPool(List<? extends GraphSourceItem> actions, ConstantPool cpool) {
        for (GraphSourceItem graphSourceItem : actions) {
            if (graphSourceItem instanceof ActionPush && cpool != null) {
                ((ActionPush)graphSourceItem).constantPool = cpool.constants;
            }
            if (!(graphSourceItem instanceof ActionDefineFunction) || cpool != null) {
                // empty if block
            }
            if (graphSourceItem instanceof ActionDefineFunction2 && cpool == null) continue;
        }
    }

    public GraphTextWriter getASMSourceReplaced(ActionList container, Set<Long> knownAddresses, ScriptExportMode exportMode, GraphTextWriter writer) {
        writer.appendNoHilight(this.getASMSource(container, knownAddresses, exportMode));
        return writer;
    }

    public static double toFloatPoint(Object o) {
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        if (o == Null.INSTANCE) {
            return Double.NaN;
        }
        if (o == Undefined.INSTANCE) {
            return Double.NaN;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        if (o instanceof String) {
            try {
                return Double.parseDouble((String)o);
            }
            catch (NumberFormatException nfe) {
                return Double.NaN;
            }
        }
        return 0.0;
    }

    public static GraphTargetItem gettoset(GraphTargetItem get, GraphTargetItem value, List<VariableActionItem> variables) {
        GraphTargetItem ret = get;
        boolean boxed = false;
        if (get instanceof VariableActionItem) {
            boxed = true;
            ret = ((VariableActionItem)ret).getBoxedValue();
        }
        if (ret instanceof GetVariableActionItem) {
            GetVariableActionItem gv = (GetVariableActionItem)ret;
            ret = new SetVariableActionItem(null, null, gv.name, value);
        } else if (ret instanceof GetMemberActionItem) {
            GetMemberActionItem mem = (GetMemberActionItem)ret;
            ret = new SetMemberActionItem(null, null, mem.object, mem.memberName, value);
        } else if (ret instanceof DirectValueActionItem && ((DirectValueActionItem)ret).value instanceof RegisterNumber) {
            ret = new StoreRegisterActionItem(null, null, (RegisterNumber)((DirectValueActionItem)ret).value, value, false);
        } else if (ret instanceof GetPropertyActionItem) {
            GetPropertyActionItem gp = (GetPropertyActionItem)ret;
            ret = new SetPropertyActionItem(null, null, gp.target, gp.propertyIndex, value);
        }
        if (boxed) {
            GraphTargetItem b = ret;
            ret = new VariableActionItem(((VariableActionItem)get).getVariableName(), value, ((VariableActionItem)get).isDefinition());
            ((VariableActionItem)ret).setBoxedValue((ActionItem)b);
            variables.remove((VariableActionItem)get);
            variables.add((VariableActionItem)ret);
        }
        return ret;
    }

    @Override
    public boolean isDeobfuscatePop() {
        return false;
    }

    @Override
    public int getLine() {
        return 0;
    }

    @Override
    public String getFile() {
        return null;
    }

    @Override
    public long getVirtualAddress() {
        return this.virtualAddress;
    }

    @Override
    public void setVirtualAddress(long virtualAddress) {
        this.virtualAddress = virtualAddress;
    }

    static {
        for (String s : propertyNamesList) {
            propertyNamesListLowerCase.add(s.toLowerCase());
        }
        logger = Logger.getLogger(Action.class.getName());
    }
}

