/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.swf5.ActionGetMember;
import com.jpexs.decompiler.flash.helpers.CodeFormatting;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.StringBuilderTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class GetMemberActionItem
extends ActionItem {
    public GraphTargetItem object;
    public final GraphTargetItem memberName;
    public boolean printObfuscatedMemberName = false;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.object);
        visitor.visit(this.memberName);
    }

    public GetMemberActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem object, GraphTargetItem memberName) {
        super(instruction, lineStartIns, 0);
        this.object = object;
        this.memberName = memberName;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        this.object.toString(writer, localData);
        if (this.memberName instanceof DirectValueActionItem && this.printObfuscatedMemberName) {
            writer.allowWrapHere().append(".");
            StringBuilder sb = new StringBuilder();
            StringBuilderTextWriter sbw = new StringBuilderTextWriter(new CodeFormatting(), sb);
            this.stripQuotes(this.memberName, localData, sbw);
            writer.append(IdentifiersDeobfuscation.printIdentifier(localData.swf, localData.usedDeobfuscations, false, sb.toString(), new String[0]));
            return writer;
        }
        if (!(this.memberName instanceof DirectValueActionItem) || !((DirectValueActionItem)this.memberName).isString() || !this.printObfuscatedMemberName && !IdentifiersDeobfuscation.isValidName(false, ((DirectValueActionItem)this.memberName).toStringNoQuotes(localData), new String[0])) {
            writer.append("[");
            this.memberName.toString(writer, localData);
            return writer.append("]");
        }
        writer.allowWrapHere().append(".");
        return this.stripQuotes(this.memberName, localData, writer);
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.object.getNeededSources());
        ret.addAll(this.memberName.getNeededSources());
        return ret;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + Objects.hashCode(this.object);
        hash = 47 * hash + Objects.hashCode(this.memberName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetMemberActionItem other = (GetMemberActionItem)obj;
        if (!Objects.equals(this.object, other.object)) {
            return false;
        }
        return Objects.equals(this.memberName, other.memberName);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetMemberActionItem other = (GetMemberActionItem)obj;
        if (!GraphTargetItem.objectsValueEquals(this.object, other.object)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.memberName, other.memberName);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return GetMemberActionItem.toSourceMerge(localData, generator, this.object, this.memberName, new ActionGetMember());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }
}

