/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class ImplementsOpActionItem
extends ActionItem {
    public GraphTargetItem subclass;
    public List<GraphTargetItem> superclasses;

    public ImplementsOpActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem subclass, List<GraphTargetItem> superclasses) {
        super(instruction, lineStartIns, 0);
        this.subclass = subclass;
        this.superclasses = superclasses;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        this.subclass.toString(writer, localData);
        writer.append(" implements ");
        for (int i = 0; i < this.superclasses.size(); ++i) {
            if (i > 0) {
                writer.append(",");
            }
            this.superclasses.get(i).toString(writer, localData);
        }
        return writer;
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.subclass.getNeededSources());
        for (GraphTargetItem ti : this.superclasses) {
            ret.addAll(ti.getNeededSources());
        }
        return ret;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.subclass);
        hash = 89 * hash + Objects.hashCode(this.superclasses);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImplementsOpActionItem other = (ImplementsOpActionItem)obj;
        if (!Objects.equals(this.subclass, other.subclass)) {
            return false;
        }
        return Objects.equals(this.superclasses, other.superclasses);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImplementsOpActionItem other = (ImplementsOpActionItem)obj;
        if (!GraphTargetItem.objectsValueEquals(this.subclass, other.subclass)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.superclasses, other.superclasses);
    }
}

