/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.swf5.ActionNewObject;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class NewObjectActionItem
extends ActionItem {
    public GraphTargetItem objectName;
    public List<GraphTargetItem> arguments;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.objectName);
        visitor.visitAll(this.arguments);
    }

    public NewObjectActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem objectName, List<GraphTargetItem> arguments) {
        super(instruction, lineStartIns, 0);
        this.objectName = objectName;
        this.arguments = arguments;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("new ");
        writer.append(IdentifiersDeobfuscation.printIdentifier(localData.swf, localData.usedDeobfuscations, false, this.objectName.toStringNoQuotes(localData), new String[0]));
        writer.spaceBeforeCallParenthesis(this.arguments.size());
        writer.append("(");
        for (int t = 0; t < this.arguments.size(); ++t) {
            if (t > 0) {
                writer.append(",");
            }
            this.arguments.get(t).toString(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.objectName.getNeededSources());
        for (GraphTargetItem ti : this.arguments) {
            ret.addAll(ti.getNeededSources());
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return NewObjectActionItem.toSourceMerge(localData, generator, this.toSourceCall(localData, generator, this.arguments), this.objectName, new ActionNewObject());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.objectName);
        hash = 97 * hash + Objects.hashCode(this.arguments);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewObjectActionItem other = (NewObjectActionItem)obj;
        if (!Objects.equals(this.objectName, other.objectName)) {
            return false;
        }
        return Objects.equals(this.arguments, other.arguments);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewObjectActionItem other = (NewObjectActionItem)obj;
        if (!GraphTargetItem.objectsValueEquals(this.objectName, other.objectName)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.arguments, other.arguments);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

