/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionGraphTargetDialect;
import com.jpexs.decompiler.flash.action.model.CompoundableBinaryOpAs12;
import com.jpexs.decompiler.flash.action.swf4.ActionAdd;
import com.jpexs.decompiler.flash.action.swf5.ActionAdd2;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.EcmaType;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;

public class AddActionItem
extends BinaryOpItem
implements CompoundableBinaryOpAs12 {
    boolean version2;

    public AddActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem leftSide, GraphTargetItem rightSide, boolean version2) {
        super(ActionGraphTargetDialect.INSTANCE, instruction, lineStartIns, 4, leftSide, rightSide, "+", "", "");
        this.version2 = version2;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.rightSide.getPrecedence() >= this.precedence) {
            if (this.leftSide.getPrecedence() > this.precedence) {
                writer.append("(");
                this.leftSide.toString(writer, localData);
                writer.append(")");
            } else {
                this.leftSide.toString(writer, localData);
            }
            writer.append(" ");
            writer.append(this.operator);
            writer.append(" ");
            writer.append("(");
            this.rightSide.toString(writer, localData);
            return writer.append(")");
        }
        return super.appendTo(writer, localData);
    }

    @Override
    public Object getResult() {
        return AddActionItem.getResult(this.rightSide.getResult(), this.leftSide.getResult(), this.version2);
    }

    public static Object getResult(Object rightResult, Object leftResult, boolean version2) {
        if (version2) {
            if (EcmaScript.type(leftResult) == EcmaType.STRING || EcmaScript.type(rightResult) == EcmaType.STRING) {
                return EcmaScript.toString(leftResult) + EcmaScript.toString(rightResult);
            }
            return EcmaScript.toNumberAs2(leftResult) + EcmaScript.toNumberAs2(rightResult);
        }
        return Action.toFloatPoint(leftResult) + Action.toFloatPoint(rightResult);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return AddActionItem.toSourceMerge(localData, generator, this.leftSide, this.rightSide, this.version2 ? new ActionAdd2() : new ActionAdd());
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.BOOLEAN;
    }

    @Override
    public List<GraphSourceItem> getOperatorInstruction() {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(new ActionAdd2());
        return ret;
    }
}

