/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.swf4;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.as2.Trait;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.FSCommandActionItem;
import com.jpexs.decompiler.flash.action.model.GetURL2ActionItem;
import com.jpexs.decompiler.flash.action.model.LoadMovieActionItem;
import com.jpexs.decompiler.flash.action.model.LoadMovieNumActionItem;
import com.jpexs.decompiler.flash.action.model.LoadVariablesActionItem;
import com.jpexs.decompiler.flash.action.model.LoadVariablesNumActionItem;
import com.jpexs.decompiler.flash.action.model.PrintActionItem;
import com.jpexs.decompiler.flash.action.model.PrintAsBitmapActionItem;
import com.jpexs.decompiler.flash.action.model.PrintAsBitmapNumActionItem;
import com.jpexs.decompiler.flash.action.model.PrintNumActionItem;
import com.jpexs.decompiler.flash.action.model.UnLoadMovieActionItem;
import com.jpexs.decompiler.flash.action.model.UnLoadMovieNumActionItem;
import com.jpexs.decompiler.flash.action.model.operations.StringAddActionItem;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.ASMParsedSymbol;
import com.jpexs.decompiler.flash.action.parser.pcode.FlasmLexer;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SecondPassData;
import com.jpexs.decompiler.graph.TranslateStack;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SWFVersion(from=4)
public class ActionGetURL2
extends Action {
    public int sendVarsMethod;
    public static final int GET = 1;
    public static final int POST = 2;
    public boolean loadTargetFlag;
    public boolean loadVariablesFlag;
    @Reserved
    public int reserved;

    public ActionGetURL2(int sendVarsMethod, boolean loadVariablesFlag, boolean loadTargetFlag, String charset) {
        super(154, 1, charset);
        this.loadTargetFlag = loadTargetFlag;
        this.loadVariablesFlag = loadVariablesFlag;
        this.sendVarsMethod = sendVarsMethod;
    }

    public ActionGetURL2(int actionLength, SWFInputStream sis, String charset) throws IOException {
        super(154, actionLength, charset);
        this.loadVariablesFlag = sis.readUB(1, "loadVariablesFlag") == 1L;
        this.loadTargetFlag = sis.readUB(1, "loadTargetFlag") == 1L;
        this.reserved = (int)sis.readUB(4, "reserved");
        this.sendVarsMethod = (int)sis.readUB(2, "sendVarsMethod");
    }

    @Override
    public String toString() {
        return "GetURL2 " + this.loadVariablesFlag + ", " + this.loadTargetFlag + ", " + this.sendVarsMethod;
    }

    @Override
    protected void getContentBytes(SWFOutputStream sos) throws IOException {
        sos.writeUB(1, this.loadVariablesFlag ? 1L : 0L);
        sos.writeUB(1, this.loadTargetFlag ? 1L : 0L);
        sos.writeUB(4, this.reserved);
        sos.writeUB(2, this.sendVarsMethod);
    }

    @Override
    protected int getContentBytesLength() {
        return 1;
    }

    public ActionGetURL2(FlasmLexer lexer, String charset) throws IOException, ActionParseException {
        super(154, -1, charset);
        ASMParsedSymbol symb = lexer.lex();
        boolean sendVarsMethodLast = false;
        if (symb.type == 11) {
            sendVarsMethodLast = true;
        }
        lexer.pushback(symb);
        if (!sendVarsMethodLast) {
            this.sendVarsMethod = (int)this.lexLong(lexer);
            this.lexOptionalComma(lexer);
        }
        this.loadVariablesFlag = this.lexBoolean(lexer);
        this.lexOptionalComma(lexer);
        this.loadTargetFlag = this.lexBoolean(lexer);
        if (sendVarsMethodLast) {
            this.lexOptionalComma(lexer);
            this.sendVarsMethod = (int)this.lexLong(lexer);
        }
    }

    @Override
    public boolean execute(LocalDataArea lda) {
        if (!lda.stackHasMinSize(2)) {
            return false;
        }
        String target = EcmaScript.toString(lda.pop());
        String urlString = EcmaScript.toString(lda.pop());
        return true;
    }

    @Override
    public void translate(Set<String> usedDeobfuscations, Map<String, Map<String, Trait>> uninitializedClassTraits, SecondPassData secondPassData, boolean insideDoInitAction, GraphSourceItem lineStartAction, TranslateStack stack, List<GraphTargetItem> output, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, int staticOperation, String path) {
        String levelPrefix;
        String tarStr;
        Object res;
        GraphTargetItem targetString = stack.pop();
        GraphTargetItem urlString = stack.pop();
        GraphTargetItem num = null;
        if (targetString.isCompileTime() && (res = targetString.getResult()) instanceof String && (tarStr = (String)res).startsWith(levelPrefix = "_level")) {
            try {
                num = new DirectValueActionItem(Long.valueOf(tarStr.substring(levelPrefix.length())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (num == null && targetString instanceof StringAddActionItem) {
            String levelPrefix2;
            String tarStr2;
            Object res2;
            StringAddActionItem sa = (StringAddActionItem)targetString;
            if (sa.leftSide.isCompileTime() && (res2 = sa.leftSide.getResult()) instanceof String && (tarStr2 = (String)res2).equals(levelPrefix2 = "_level")) {
                num = sa.rightSide;
            }
        }
        if (this.loadVariablesFlag) {
            if (num != null) {
                output.add(new LoadVariablesNumActionItem(this, lineStartAction, urlString, num, this.sendVarsMethod));
            } else {
                output.add(new LoadVariablesActionItem(this, lineStartAction, urlString, targetString, this.sendVarsMethod));
            }
        } else if (this.loadTargetFlag) {
            if (urlString instanceof DirectValueActionItem && "".equals(urlString.getResult())) {
                output.add(new UnLoadMovieActionItem((GraphSourceItem)this, lineStartAction, targetString));
            } else {
                output.add(new LoadMovieActionItem(this, lineStartAction, urlString, targetString, this.sendVarsMethod));
            }
        } else {
            String printPrefix = "print:#";
            String printAsBitmapPrefix = "printasbitmap:#";
            String fscommandPrefix = "FSCommand:";
            GraphTargetItem printType = null;
            boolean doPrint = false;
            boolean doPrintAsBitmap = false;
            boolean doFSCommand = false;
            boolean doUnload = false;
            if (urlString.isCompileTime() && urlString.getResult() instanceof String) {
                String urlStr = (String)urlString.getResult();
                if ("".equals(urlStr)) {
                    doUnload = true;
                } else if (urlStr.startsWith("print:#")) {
                    printType = new DirectValueActionItem(urlStr.substring("print:#".length()));
                    doPrint = true;
                } else if (urlStr.startsWith("printasbitmap:#")) {
                    printType = new DirectValueActionItem(urlStr.substring("printasbitmap:#".length()));
                    doPrintAsBitmap = true;
                } else if (urlStr.startsWith("FSCommand:")) {
                    urlString = new DirectValueActionItem(urlStr.substring("FSCommand:".length()));
                    doFSCommand = true;
                } else if (urlStr.equals("print:")) {
                    printType = new DirectValueActionItem("bmovie");
                    doPrint = true;
                } else if (urlStr.equals("printasbitmap:")) {
                    printType = new DirectValueActionItem("bmovie");
                    doPrintAsBitmap = true;
                }
            } else if (urlString instanceof StringAddActionItem) {
                Object res3;
                StringAddActionItem sa = (StringAddActionItem)urlString;
                if (sa.leftSide.isCompileTime() && (res3 = sa.leftSide.getResult()) instanceof String) {
                    String urlStr;
                    switch (urlStr = (String)res3) {
                        case "print:#": {
                            printType = sa.rightSide;
                            doPrint = true;
                            urlString = null;
                            break;
                        }
                        case "printasbitmap:#": {
                            printType = sa.rightSide;
                            doPrintAsBitmap = true;
                            urlString = null;
                            break;
                        }
                        case "FSCommand:": {
                            urlString = sa.rightSide;
                            doFSCommand = true;
                        }
                    }
                }
            }
            if (num != null) {
                if (doUnload) {
                    output.add(new UnLoadMovieNumActionItem((GraphSourceItem)this, lineStartAction, num));
                } else if (doPrint) {
                    output.add(new PrintNumActionItem((GraphSourceItem)this, lineStartAction, num, printType));
                } else if (doPrintAsBitmap) {
                    output.add(new PrintAsBitmapNumActionItem((GraphSourceItem)this, lineStartAction, num, printType));
                } else {
                    output.add(new LoadMovieNumActionItem(this, lineStartAction, urlString, num, this.sendVarsMethod));
                }
            } else if (doPrint) {
                output.add(new PrintActionItem((GraphSourceItem)this, lineStartAction, targetString, printType));
            } else if (doPrintAsBitmap) {
                output.add(new PrintAsBitmapActionItem((GraphSourceItem)this, lineStartAction, targetString, printType));
            } else if (doFSCommand) {
                output.add(new FSCommandActionItem((GraphSourceItem)this, lineStartAction, urlString, targetString));
            } else {
                output.add(new GetURL2ActionItem(this, lineStartAction, urlString, targetString, this.sendVarsMethod));
            }
        }
    }

    @Override
    public int getStackPopCount(BaseLocalData localData, TranslateStack stack) {
        return 2;
    }
}

