/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.swf4;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.DisplayObject;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.as2.Trait;
import com.jpexs.decompiler.flash.action.model.GotoFrame2ActionItem;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.FlasmLexer;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SecondPassData;
import com.jpexs.decompiler.graph.TranslateStack;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SWFVersion(from=4)
public class ActionGotoFrame2
extends Action {
    boolean sceneBiasFlag;
    boolean playFlag;
    public int sceneBias;
    @Reserved
    int reserved;

    public ActionGotoFrame2(boolean playFlag, boolean sceneBiasFlag, int sceneBias, String charset) {
        super(159, 0, charset);
        this.sceneBiasFlag = sceneBiasFlag;
        this.playFlag = playFlag;
        this.sceneBias = sceneBias;
    }

    public ActionGotoFrame2(int actionLength, SWFInputStream sis) throws IOException {
        super(159, actionLength, sis.getCharset());
        this.reserved = (int)sis.readUB(6, "reserved");
        this.sceneBiasFlag = sis.readUB(1, "sceneBiasFlag") == 1L;
        boolean bl = this.playFlag = sis.readUB(1, "playFlag") == 1L;
        if (this.sceneBiasFlag) {
            this.sceneBias = sis.readUI16("sceneBias");
        }
    }

    @Override
    protected void getContentBytes(SWFOutputStream sos) throws IOException {
        sos.writeUB(6, this.reserved);
        sos.writeUB(1, this.sceneBiasFlag ? 1L : 0L);
        sos.writeUB(1, this.playFlag ? 1L : 0L);
        if (this.sceneBiasFlag) {
            sos.writeUI16(this.sceneBias);
        }
    }

    @Override
    protected int getContentBytesLength() {
        int res = 1;
        if (this.sceneBiasFlag) {
            res += 2;
        }
        return res;
    }

    @Override
    public String toString() {
        return "GotoFrame2 " + this.sceneBiasFlag + ", " + this.playFlag + (this.sceneBiasFlag ? ", " + this.sceneBias : "");
    }

    public ActionGotoFrame2(FlasmLexer lexer, String charset) throws IOException, ActionParseException {
        super(159, -1, charset);
        this.sceneBiasFlag = this.lexBoolean(lexer);
        this.lexOptionalComma(lexer);
        this.playFlag = this.lexBoolean(lexer);
        if (this.sceneBiasFlag) {
            this.lexOptionalComma(lexer);
            this.sceneBias = (int)this.lexLong(lexer);
        }
    }

    @Override
    public boolean execute(LocalDataArea lda) {
        if (lda.stackIsEmpty()) {
            return false;
        }
        String frame = EcmaScript.toString(lda.pop());
        String target = "/";
        if (frame.contains(":")) {
            target = frame.substring(0, frame.indexOf(58));
            frame = frame.substring(frame.indexOf(58) + 1);
        }
        if (frame.matches("[1-9][0-9]*|0")) {
            int frameNum = Integer.parseInt(frame);
            if (target.equals("/")) {
                lda.stage.gotoFrame(frameNum);
            } else {
                Object member = lda.stage.getMember(target);
                if (member instanceof DisplayObject) {
                    ((DisplayObject)member).gotoFrame(frameNum);
                }
            }
        } else {
            String frameLabel = frame;
            if (target.equals("/")) {
                lda.stage.gotoLabel(frameLabel);
            } else {
                Object member = lda.stage.getMember(target);
                if (member instanceof DisplayObject) {
                    ((DisplayObject)member).gotoLabel(frameLabel);
                }
            }
        }
        return true;
    }

    @Override
    public void translate(Set<String> usedDeobfuscations, Map<String, Map<String, Trait>> uninitializedClassTraits, SecondPassData secondPassData, boolean insideDoInitAction, GraphSourceItem lineStartAction, TranslateStack stack, List<GraphTargetItem> output, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, int staticOperation, String path) {
        GraphTargetItem frame = stack.pop();
        output.add(new GotoFrame2ActionItem(this, lineStartAction, frame, this.sceneBiasFlag, this.playFlag, this.sceneBias));
    }

    @Override
    public int getStackPopCount(BaseLocalData localData, TranslateStack stack) {
        return 1;
    }
}

