/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.swf4;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.EndOfStreamException;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionGraphTargetDialect;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.as2.Trait;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.TemporaryRegister;
import com.jpexs.decompiler.flash.action.model.TemporaryRegisterMark;
import com.jpexs.decompiler.flash.action.model.UnresolvedConstantActionItem;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.ASMParsedSymbol;
import com.jpexs.decompiler.flash.action.parser.pcode.FlasmLexer;
import com.jpexs.decompiler.flash.action.swf4.ConstantIndex;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.dumpview.DumpInfo;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SecondPassData;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.FalseItem;
import com.jpexs.decompiler.graph.model.TrueItem;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SWFVersion(from=4)
public class ActionPush
extends Action {
    public List<Object> values;
    public List<Object> replacement;
    public List<String> constantPool;
    public static final int MAX_CONSTANT_INDEX_TYPE8 = 255;

    public ActionPush(int actionLength, SWFInputStream sis, int version) throws IOException {
        super(150, actionLength, sis.getCharset());
        this.values = new ArrayList<Object>();
        DumpInfo di = sis.dumpInfo;
        sis = sis.getLimitedStream(actionLength);
        sis.dumpInfo = di;
        try {
            while (sis.available() > 0) {
                int type = sis.readUI8("type");
                switch (type) {
                    case 0: {
                        this.values.add(sis.readString("string"));
                        break;
                    }
                    case 1: {
                        this.values.add(Float.valueOf(sis.readFLOAT("float")));
                        break;
                    }
                    case 2: {
                        this.values.add(Null.INSTANCE);
                        break;
                    }
                    case 3: {
                        this.values.add(Undefined.INSTANCE);
                        break;
                    }
                    case 4: {
                        this.values.add(new RegisterNumber(sis.readUI8("registerNumber")));
                        break;
                    }
                    case 5: {
                        int b = sis.readUI8("boolean");
                        if (b == 0) {
                            this.values.add(false);
                            break;
                        }
                        this.values.add(true);
                        break;
                    }
                    case 6: {
                        this.values.add(sis.readDOUBLE("double"));
                        break;
                    }
                    case 7: {
                        long el = sis.readSI32("integer");
                        this.values.add(el);
                        break;
                    }
                    case 8: {
                        this.values.add(new ConstantIndex(sis.readUI8("constantIndex")));
                        break;
                    }
                    case 9: {
                        this.values.add(new ConstantIndex(sis.readUI16("constantIndex")));
                    }
                }
            }
        }
        catch (EndOfStreamException endOfStreamException) {
            // empty catch block
        }
    }

    @Override
    protected void getContentBytes(SWFOutputStream sos) throws IOException {
        List<Object> vals = this.values;
        if (this.replacement != null) {
            vals = this.replacement;
        }
        for (Object o : vals) {
            if (o instanceof String) {
                sos.writeUI8(0);
                sos.writeString((String)o);
                continue;
            }
            if (o instanceof Float) {
                sos.writeUI8(1);
                sos.writeFLOAT(((Float)o).floatValue());
                continue;
            }
            if (o == Null.INSTANCE) {
                sos.writeUI8(2);
                continue;
            }
            if (o == Undefined.INSTANCE) {
                sos.writeUI8(3);
                continue;
            }
            if (o instanceof RegisterNumber) {
                sos.writeUI8(4);
                sos.writeUI8(((RegisterNumber)o).number);
                continue;
            }
            if (o instanceof Boolean) {
                sos.writeUI8(5);
                sos.writeUI8((Boolean)o != false ? 1 : 0);
                continue;
            }
            if (o instanceof Number) {
                long l;
                if (o instanceof Long && ((l = ((Long)o).longValue()) < Integer.MIN_VALUE || l > Integer.MAX_VALUE)) {
                    o = (double)l;
                }
                if (o instanceof Float) {
                    sos.writeUI8(1);
                    sos.writeFLOAT(((Float)o).floatValue());
                    continue;
                }
                if (o instanceof Double) {
                    sos.writeUI8(6);
                    sos.writeDOUBLE((Double)o);
                    continue;
                }
                if (!(o instanceof Long) && !(o instanceof Integer) && !(o instanceof Short) && !(o instanceof Byte)) continue;
                sos.writeUI8(7);
                sos.writeSI32(((Number)o).longValue());
                continue;
            }
            if (!(o instanceof ConstantIndex)) continue;
            int cIndex = ((ConstantIndex)o).index;
            if (cIndex <= 255) {
                sos.writeUI8(8);
                sos.writeUI8(cIndex);
                continue;
            }
            sos.writeUI8(9);
            sos.writeUI16(cIndex);
        }
    }

    @Override
    protected int getContentBytesLength() {
        List<Object> vals = this.values;
        if (this.replacement != null) {
            vals = this.replacement;
        }
        int res = 0;
        for (Object o : vals) {
            if (o instanceof String) {
                res += Utf8Helper.getBytesLength((String)o, this.charset) + 2;
                continue;
            }
            if (o instanceof Float) {
                res += 5;
                continue;
            }
            if (o == Null.INSTANCE) {
                ++res;
                continue;
            }
            if (o == Undefined.INSTANCE) {
                ++res;
                continue;
            }
            if (o instanceof RegisterNumber) {
                res += 2;
                continue;
            }
            if (o instanceof Boolean) {
                res += 2;
                continue;
            }
            if (o instanceof Number) {
                long l;
                if (o instanceof Long && ((l = ((Long)o).longValue()) < Integer.MIN_VALUE || l > Integer.MAX_VALUE)) {
                    o = (double)l;
                }
                if (o instanceof Float) {
                    res += 5;
                    continue;
                }
                if (o instanceof Double) {
                    res += 9;
                    continue;
                }
                if (!(o instanceof Long) && !(o instanceof Integer) && !(o instanceof Short) && !(o instanceof Byte)) continue;
                res += 5;
                continue;
            }
            if (!(o instanceof ConstantIndex)) continue;
            int cIndex = ((ConstantIndex)o).index;
            if (cIndex < 256) {
                res += 2;
                continue;
            }
            res += 3;
        }
        return res;
    }

    public static boolean isValidValue(Object value) {
        long l;
        if (value instanceof String) {
            for (char ch : ((String)value).toCharArray()) {
                if (ch != '\u0000') continue;
                return false;
            }
        }
        return !(value instanceof Long) || (l = ((Long)value).longValue()) >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE;
    }

    public ActionPush(Object value, String charset) {
        super(150, 0, charset);
        this.values = new ArrayList<Object>();
        this.values.add(value);
        this.updateLength();
    }

    public ActionPush(Object[] values, String charset) {
        super(150, 0, charset);
        this.values = new ArrayList<Object>();
        this.values.addAll(Arrays.asList(values));
        this.updateLength();
    }

    public ActionPush(FlasmLexer lexer, List<String> constantPool, String charset) throws IOException, ActionParseException {
        super(150, 0, charset);
        this.constantPool = constantPool;
        this.values = new ArrayList<Object>();
        int count = 0;
        block6: while (true) {
            boolean valueExpected = false;
            ASMParsedSymbol symb = lexer.lex();
            if (symb.type == 18) {
                symb = lexer.lex();
                valueExpected = true;
            }
            switch (symb.type) {
                case 1: {
                    ++count;
                    if (constantPool.contains((String)symb.value)) {
                        this.values.add(new ConstantIndex(constantPool.indexOf(symb.value)));
                        break;
                    }
                    this.values.add(symb.value);
                    break;
                }
                case 4: 
                case 5: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 19: {
                    ++count;
                    this.values.add(symb.value);
                    break;
                }
                case 7: 
                case 16: {
                    if (valueExpected) {
                        throw new ActionParseException("Value expected", lexer.yyline());
                    }
                    if (count != 0) break block6;
                    throw new ActionParseException("Arguments expected", lexer.yyline());
                }
                case 9: {
                    break;
                }
                default: {
                    throw new ActionParseException("Arguments expected, " + symb.type + " " + symb.value + " found", lexer.yyline());
                }
            }
        }
    }

    @Override
    public GraphTextWriter getASMSourceReplaced(ActionList container, Set<Long> knownAddresses, ScriptExportMode exportMode, GraphTextWriter writer) {
        if (this.replacement == null || this.replacement.size() < this.values.size()) {
            return this.toString(writer);
        }
        List<Object> oldVal = this.values;
        this.values = this.replacement;
        this.toString(writer);
        this.values = oldVal;
        return writer;
    }

    public GraphTextWriter paramsToStringReplaced(List<? extends GraphSourceItem> container, Set<Long> knownAddresses, ScriptExportMode exportMode, GraphTextWriter writer) {
        if (this.replacement == null || this.replacement.size() < this.values.size()) {
            return this.paramsToString(writer);
        }
        List<Object> oldVal = this.values;
        this.values = this.replacement;
        this.paramsToString(writer);
        this.values = oldVal;
        return writer;
    }

    public String toStringNoQ(int i) {
        Object value = this.values.get(i);
        String ret = value instanceof ConstantIndex ? ((ConstantIndex)value).toStringNoQ(this.constantPool, Configuration.resolveConstants.get()) : (value instanceof String ? (String)value : (value instanceof RegisterNumber ? ((RegisterNumber)value).toStringNoName() : value.toString()));
        return ret;
    }

    public GraphTextWriter paramsToString(GraphTextWriter writer) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                writer.appendNoHilight(", ");
            }
            writer.append(this.toString(i), this.getAddress() + (long)i, this.getFileOffset());
        }
        return writer;
    }

    public String toString(int i) {
        String ret;
        Object value = this.values.get(i);
        if (value instanceof ConstantIndex) {
            ret = ((ConstantIndex)value).toString(this.constantPool, Configuration.resolveConstants.get());
        } else if (value instanceof String) {
            ret = "\"" + Helper.escapeActionScriptString((String)value) + "\"";
        } else if (value instanceof RegisterNumber) {
            ret = ((RegisterNumber)value).toStringNoName();
        } else if (value instanceof Float || value instanceof Double) {
            String fdString = EcmaScript.toString(value);
            if (value instanceof Double && fdString.matches("^[0-9]+$")) {
                fdString = fdString + ".0";
            }
            if (value instanceof Float) {
                fdString = fdString + "f";
            }
            ret = fdString;
        } else {
            ret = value.toString();
        }
        return ret;
    }

    @Override
    public String toString() {
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), false);
        this.toString(writer);
        writer.finishHilights();
        return writer.toString();
    }

    public GraphTextWriter toString(GraphTextWriter writer) {
        writer.appendNoHilight("Push ");
        this.paramsToString(writer);
        return writer;
    }

    @Override
    public boolean execute(LocalDataArea lda) {
        for (Object value : this.values) {
            if (value instanceof ConstantIndex) {
                ConstantIndex constantIndex = (ConstantIndex)value;
                List<String> cPool = lda.constantPool != null ? lda.constantPool : this.constantPool;
                lda.push(constantIndex.toStringNoQ(cPool, true));
                continue;
            }
            if (value instanceof RegisterNumber) {
                int rn = ((RegisterNumber)value).number;
                if (lda.localRegisters.containsKey(rn)) {
                    lda.push(lda.localRegisters.get(rn));
                    continue;
                }
                lda.push(Undefined.INSTANCE);
                continue;
            }
            lda.push(value);
        }
        return true;
    }

    @Override
    public void translate(Set<String> usedDeobfuscations, Map<String, Map<String, Trait>> uninitializedClassTraits, SecondPassData secondPassData, boolean insideDoInitAction, GraphSourceItem lineStartAction, TranslateStack stack, List<GraphTargetItem> output, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, int staticOperation, String path) {
        int pos = 0;
        for (Object o : this.values) {
            GraphTargetItem toPush = null;
            if (o instanceof ConstantIndex) {
                if (this.constantPool == null || ((ConstantIndex)o).index >= this.constantPool.size()) {
                    toPush = new UnresolvedConstantActionItem(((ConstantIndex)o).index);
                } else {
                    o = this.constantPool.get(((ConstantIndex)o).index);
                }
            }
            if (toPush == null) {
                if (o instanceof Boolean) {
                    Boolean b = (Boolean)o;
                    toPush = b.booleanValue() ? new TrueItem(ActionGraphTargetDialect.INSTANCE, this, lineStartAction) : new FalseItem(ActionGraphTargetDialect.INSTANCE, this, lineStartAction);
                } else {
                    DirectValueActionItem dvt = new DirectValueActionItem(this, lineStartAction, pos, o, this.constantPool);
                    if (o instanceof RegisterNumber) {
                        dvt.computedRegValue = variables.get("__register" + ((RegisterNumber)o).number);
                        if (regNames.containsKey(((RegisterNumber)o).number)) {
                            ((RegisterNumber)o).name = regNames.get(((RegisterNumber)o).number);
                        }
                    }
                    if (dvt.computedRegValue instanceof TemporaryRegister) {
                        ((TemporaryRegister)dvt.computedRegValue).used = true;
                        for (int i = 0; i < output.size(); ++i) {
                            if (!(output.get(i) instanceof TemporaryRegisterMark)) continue;
                            TemporaryRegisterMark trm = (TemporaryRegisterMark)output.get(i);
                            if (trm.tempReg != dvt.computedRegValue) continue;
                            output.remove(i);
                            break;
                        }
                        toPush = new TemporaryRegister(((RegisterNumber)o).number, ((TemporaryRegister)dvt.computedRegValue).value);
                    } else {
                        toPush = dvt;
                    }
                }
            }
            toPush.setPos(pos);
            stack.push(toPush);
            ++pos;
        }
    }

    @Override
    public int getStackPushCount(BaseLocalData localData, TranslateStack stack) {
        return this.values.size();
    }
}

