/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.amf.amf0;

import com.jpexs.decompiler.flash.EndOfStreamException;
import com.jpexs.decompiler.flash.amf.amf0.types.ArrayType;
import com.jpexs.decompiler.flash.amf.amf0.types.BasicType;
import com.jpexs.decompiler.flash.amf.amf0.types.ComplexObject;
import com.jpexs.decompiler.flash.amf.amf0.types.DateType;
import com.jpexs.decompiler.flash.amf.amf0.types.EcmaArrayType;
import com.jpexs.decompiler.flash.amf.amf0.types.ObjectType;
import com.jpexs.decompiler.flash.amf.amf0.types.ReferenceType;
import com.jpexs.decompiler.flash.amf.amf0.types.TypedObjectType;
import com.jpexs.decompiler.flash.amf.amf0.types.XmlDocumentType;
import com.jpexs.decompiler.flash.amf.amf3.Amf3InputStream;
import com.jpexs.decompiler.flash.amf.amf3.NoSerializerExistsException;
import com.jpexs.decompiler.flash.dumpview.DumpInfo;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.MemoryInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Amf0InputStream
extends InputStream {
    private final MemoryInputStream is;
    public DumpInfo dumpInfo;

    public Amf0InputStream(MemoryInputStream is) {
        this.is = is;
    }

    private int readInternal() throws IOException {
        int ret = this.read();
        if (ret == -1) {
            throw new EndOfStreamException();
        }
        return ret;
    }

    public byte[] readBytes(int count) throws IOException {
        DataInputStream dais = new DataInputStream(this.is);
        byte[] ret = new byte[count];
        try {
            dais.readFully(ret);
        }
        catch (EOFException e) {
            throw new EndOfStreamException();
        }
        return ret;
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    public DumpInfo newDumpLevel(String name, String type) {
        if (this.dumpInfo != null) {
            long startByte = this.is.getPos();
            DumpInfo di = new DumpInfo(name, type, null, startByte, 0, 0L, 0);
            di.parent = this.dumpInfo;
            this.dumpInfo.getChildInfos().add(di);
            this.dumpInfo = di;
        }
        return this.dumpInfo;
    }

    public void endDumpLevel() {
        this.endDumpLevel(null);
    }

    public void endDumpLevel(Object value) {
        if (this.dumpInfo != null) {
            this.dumpInfo.lengthBytes = this.is.getPos() - this.dumpInfo.startByte;
            this.dumpInfo.previewValue = value;
            this.dumpInfo = this.dumpInfo.parent;
        }
    }

    public void endDumpLevelUntil(DumpInfo di) {
        if (di != null) {
            while (this.dumpInfo != null && this.dumpInfo != di) {
                this.endDumpLevel();
            }
        }
    }

    public int readU8(String name) throws IOException {
        this.newDumpLevel(name, "U8");
        int ret = this.readInternal();
        this.endDumpLevel(ret);
        return ret;
    }

    public int readU16(String name) throws IOException {
        this.newDumpLevel(name, "U16");
        int b1 = this.readInternal();
        int b2 = this.readInternal();
        int ret = (b1 << 8) + b2;
        this.endDumpLevel(ret);
        return ret;
    }

    public int readS16(String name) throws IOException {
        this.newDumpLevel(name, "S16");
        int b1 = this.readInternal();
        int b2 = this.readInternal();
        int ret = (b1 << 8) + b2;
        ret = (int)this.signExtend(ret, 16);
        this.endDumpLevel(ret);
        return ret;
    }

    public long readU32(String name) throws IOException {
        this.newDumpLevel(name, "U32");
        long ret = this.readU32Internal();
        this.endDumpLevel(ret);
        return ret;
    }

    private long readU32Internal() throws IOException {
        int b1 = this.readInternal();
        int b2 = this.readInternal();
        int b3 = this.readInternal();
        int b4 = this.readInternal();
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4 & 0xFFFFFFFF;
    }

    public long readS32(String name) throws IOException {
        this.newDumpLevel(name, "S32");
        long ret = this.signExtend(this.readU32Internal(), 32);
        this.endDumpLevel(ret);
        return ret;
    }

    private long readLong() throws IOException {
        byte[] readBuffer = new byte[8];
        for (int i = 0; i < 8; ++i) {
            readBuffer[i] = (byte)this.readInternal();
        }
        return ((long)readBuffer[0] << 56) + ((long)(readBuffer[1] & 0xFF) << 48) + ((long)(readBuffer[2] & 0xFF) << 40) + ((long)(readBuffer[3] & 0xFF) << 32) + ((long)(readBuffer[4] & 0xFF) << 24) + (long)((readBuffer[5] & 0xFF) << 16) + (long)((readBuffer[6] & 0xFF) << 8) + (long)(readBuffer[7] & 0xFF);
    }

    public double readDouble(String name) throws IOException {
        this.newDumpLevel(name, "DOUBLE");
        long lval = this.readLong();
        double ret = Double.longBitsToDouble(lval);
        this.endDumpLevel(EcmaScript.toString(ret));
        return ret;
    }

    private long signExtend(long val, int size) {
        if ((val >> size - 1 & 1L) == 1L) {
            long mask = size == 32 ? -1L : (long)((1 << size) - 1);
            long positiveVal = (val - 1L ^ 0xFFFFFFFFFFFFFFFFL) & mask;
            long negativeVal = -positiveVal;
            return negativeVal;
        }
        return val;
    }

    public String readUtf8(String name) throws IOException {
        this.newDumpLevel(name, "UTF-8");
        int len = this.readU16("length");
        byte[] data = len == 0 ? null : this.readBytes(len);
        String retString = data == null ? "" : new String(data, "UTF-8");
        this.endDumpLevel("\"" + Helper.escapeActionScriptString(retString) + "\"");
        return retString;
    }

    public String readUtf8Long(String name) throws IOException {
        this.newDumpLevel(name, "UTF-8-long");
        int len = (int)this.readU32("length");
        byte[] data = len == 0 ? null : this.readBytes(len);
        String retString = data == null ? "" : new String(data, "UTF-8");
        this.endDumpLevel();
        return retString;
    }

    public Object readValueWithReferences(String name) throws IOException, NoSerializerExistsException {
        Object value = this.readValue(name);
        ArrayList<Object> complexObjects = new ArrayList<Object>();
        this.populateComplexObjects(value, complexObjects);
        return this.resolveReferences(value, complexObjects);
    }

    public Object readValue(String name) throws IOException, NoSerializerExistsException {
        this.newDumpLevel(name, "value-type");
        Object result = null;
        int marker = this.readInternal();
        switch (marker) {
            case 0: {
                result = this.readDouble("DOUBLE");
                break;
            }
            case 1: {
                result = this.readU8("U8") > 0;
                break;
            }
            case 2: {
                result = this.readUtf8("UTF-8");
                break;
            }
            case 9: {
                result = BasicType.OBJECT_END;
                break;
            }
            case 3: {
                ObjectType object = new ObjectType();
                while (true) {
                    String propName = this.readUtf8("propertyName");
                    Object val = this.readValue("propertyValue");
                    if (propName.equals("")) break;
                    object.properties.put(propName, val);
                }
                result = object;
                break;
            }
            case 4: {
                throw new IllegalArgumentException("MovieClip not supported in AMF0");
            }
            case 5: {
                result = BasicType.NULL;
                break;
            }
            case 6: {
                result = BasicType.UNDEFINED;
                break;
            }
            case 7: {
                result = new ReferenceType(this.readU16("referenceIndex"));
                break;
            }
            case 8: {
                int associativeCount = (int)this.readU32("associative-count");
                EcmaArrayType ea = new EcmaArrayType();
                for (int a = 0; a < associativeCount; ++a) {
                    String eaKey = this.readUtf8("key");
                    Object eaVal = this.readValue("value");
                    ea.denseValues.put(eaKey, eaVal);
                }
                while (true) {
                    String eaKey = this.readUtf8("key");
                    Object eaVal = this.readValue("value");
                    if ("".equals(eaKey)) break;
                    ea.associativeValues.put(eaKey, eaVal);
                }
                result = ea;
                break;
            }
            case 10: {
                int arrayCount = (int)this.readU32("array-count");
                ArrayType at = new ArrayType();
                for (int a = 0; a < arrayCount; ++a) {
                    at.values.add(this.readValue("value"));
                }
                result = at;
                break;
            }
            case 11: {
                double dval = this.readDouble("epoch-millis");
                int timezone = this.readS16("time-zone");
                result = new DateType(dval, timezone);
                break;
            }
            case 12: {
                result = this.readUtf8Long("long-string");
                break;
            }
            case 13: {
                throw new IllegalArgumentException("Unsupported type");
            }
            case 14: {
                throw new IllegalArgumentException("RecordSet not supported in AMF0");
            }
            case 15: {
                return new XmlDocumentType(this.readUtf8Long("xml"));
            }
            case 16: {
                String className = this.readUtf8("class-name");
                TypedObjectType typedObject = new TypedObjectType();
                typedObject.className = className;
                while (true) {
                    String propName = this.readUtf8("propertyName");
                    Object val = this.readValue("propertyValue");
                    if (propName.equals("")) break;
                    typedObject.properties.put(propName, val);
                }
                result = typedObject;
                break;
            }
            case 17: {
                Amf3InputStream amf3 = new Amf3InputStream(this.is);
                result = amf3.readValue("avm-plus-object");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type");
            }
        }
        this.endDumpLevel();
        return result;
    }

    public void resolveMapReferences(Map<String, Object> map) {
        ArrayList<Object> complexObjects = new ArrayList<Object>();
        this.populateComplexObjects(new ArrayList<Object>(map.values()), complexObjects);
        for (String key : map.keySet()) {
            map.put(key, this.resolveReferences(map.get(key), complexObjects));
        }
    }

    public Object resolveReferences(Object value, List<Object> complexObjects) {
        if (value instanceof ReferenceType) {
            ReferenceType rt = (ReferenceType)value;
            return complexObjects.get(rt.referenceIndex);
        }
        if (value instanceof ObjectType) {
            ObjectType ot = (ObjectType)value;
            for (String key : ot.properties.keySet()) {
                ot.properties.put(key, this.resolveReferences(ot.properties.get(key), complexObjects));
            }
        }
        if (value instanceof TypedObjectType) {
            TypedObjectType tot = (TypedObjectType)value;
            for (String key : tot.properties.keySet()) {
                tot.properties.put(key, this.resolveReferences(tot.properties.get(key), complexObjects));
            }
        }
        if (value instanceof EcmaArrayType) {
            EcmaArrayType eat = (EcmaArrayType)value;
            for (String key : eat.denseValues.keySet()) {
                eat.denseValues.put(key, this.resolveReferences(eat.denseValues.get(key), complexObjects));
            }
            for (String key : eat.associativeValues.keySet()) {
                eat.associativeValues.put(key, this.resolveReferences(eat.associativeValues.get(key), complexObjects));
            }
        }
        if (value instanceof ArrayType) {
            ArrayType at = (ArrayType)value;
            for (int i = 0; i < at.values.size(); ++i) {
                at.values.set(i, this.resolveReferences(at.values.get(i), complexObjects));
            }
        }
        return value;
    }

    public void populateComplexObjects(List<Object> values, List<Object> result) {
        for (Object value : values) {
            this.populateComplexObjects(value, result);
        }
    }

    public void populateComplexObjects(Object value, List<Object> result) {
        if (result.contains(value)) {
            return;
        }
        if (value instanceof ComplexObject) {
            result.add(value);
            for (Object subvalue : ((ComplexObject)value).getSubValues()) {
                this.populateComplexObjects(subvalue, result);
            }
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }
}

