/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.amf.amf3;

import com.jpexs.decompiler.flash.amf.amf3.NoSerializerExistsException;
import com.jpexs.decompiler.flash.amf.amf3.ObjectTypeSerializeHandler;
import com.jpexs.decompiler.flash.amf.amf3.Traits;
import com.jpexs.decompiler.flash.amf.amf3.UnsupportedValueTypeException;
import com.jpexs.decompiler.flash.amf.amf3.types.ArrayType;
import com.jpexs.decompiler.flash.amf.amf3.types.BasicType;
import com.jpexs.decompiler.flash.amf.amf3.types.ByteArrayType;
import com.jpexs.decompiler.flash.amf.amf3.types.DateType;
import com.jpexs.decompiler.flash.amf.amf3.types.DictionaryType;
import com.jpexs.decompiler.flash.amf.amf3.types.ObjectType;
import com.jpexs.decompiler.flash.amf.amf3.types.VectorDoubleType;
import com.jpexs.decompiler.flash.amf.amf3.types.VectorIntType;
import com.jpexs.decompiler.flash.amf.amf3.types.VectorObjectType;
import com.jpexs.decompiler.flash.amf.amf3.types.VectorUIntType;
import com.jpexs.decompiler.flash.amf.amf3.types.XmlDocType;
import com.jpexs.decompiler.flash.amf.amf3.types.XmlType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Amf3OutputStream
extends OutputStream {
    public static final Logger LOGGER = Logger.getLogger(Amf3OutputStream.class.getName());
    private final OutputStream os;
    private static final int NO_REFERENCE_FLAG = 1;
    private static final int NO_TRAIT_REFERENCE_FLAG = 2;
    private static final int TRAIT_EXT_FLAG = 4;
    private static final int DYNAMIC_FLAG = 8;

    public Amf3OutputStream(OutputStream os) {
        this.os = os;
    }

    public void writeU8(int v) throws IOException {
        this.write(v);
    }

    public void writeU16(int v) throws IOException {
        int b1 = v >> 8 & 0xFF;
        int b2 = v & 0xFF;
        this.write(b1);
        this.write(b2);
    }

    private void writeLong(long value) throws IOException {
        byte[] writeBuffer = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        this.write(writeBuffer);
    }

    public void writeU32(long v) throws IOException {
        int b1 = (int)(v >> 24 & 0xFFL);
        int b2 = (int)(v >> 16 & 0xFFL);
        int b3 = (int)(v >> 8 & 0xFFL);
        int b4 = (int)(v & 0xFFL);
        this.write(b1);
        this.write(b2);
        this.write(b3);
        this.write(b4);
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBytes(byte[] data) throws IOException {
        this.os.write(data);
    }

    public void writeU29(long v) throws IOException {
        int USE_NEXT_BYTE_FLAG = 128;
        int SEVEN_BITS_MASK = 127;
        int EIGHT_BITS_MASK = 255;
        if ((v &= 0x3FFFFFFFL) <= 127L) {
            this.write((int)v);
        } else if (v <= 16383L) {
            int b1 = (int)(v >> 7 & 0x7FL) | 0x80;
            int b2 = (int)(v & 0x7FL);
            this.write(b1);
            this.write(b2);
        } else if (v <= 0x1FFFFFL) {
            int b1 = (int)(v >> 14 & 0x7FL) | 0x80;
            int b2 = (int)(v >> 7 & 0x7FL) | 0x80;
            int b3 = (int)(v & 0x7FL);
            this.write(b1);
            this.write(b2);
            this.write(b3);
        } else if (v <= 0x3FFFFFFFL) {
            int b1 = (int)(v >> 21 & 0x7FL) | 0x80;
            int b2 = (int)(v >> 14 & 0x7FL) | 0x80;
            int b3 = (int)(v >> 7 & 0x7FL) | 0x80;
            int b4 = (int)(v & 0xFFL);
            this.write(b1);
            this.write(b2);
            this.write(b3);
            this.write(b4);
        } else {
            throw new IllegalArgumentException("Value too long");
        }
    }

    public void writeUtf8Vr(String val, List<String> stringTable) throws IOException {
        int stringIndex = stringTable.indexOf(val);
        if (stringIndex == -1) {
            if (!val.isEmpty()) {
                stringTable.add(val);
            }
            byte[] data = val.getBytes("UTF-8");
            this.writeU29(data.length << 1 | 1);
            this.writeBytes(data);
        } else {
            this.writeU29(stringIndex << 1);
        }
    }

    private void writeByteArray(ByteArrayType val, List<Object> objectTable) throws IOException {
        int objectIndex = objectTable.indexOf(val);
        if (objectIndex == -1) {
            objectTable.add(val);
            byte[] data = val.getData();
            this.writeU29(data.length << 1 | 1);
            this.writeBytes(data);
        } else {
            this.writeU29(objectIndex << 1);
        }
    }

    private void writeXmlDoc(XmlDocType val, List<Object> objectTable) throws IOException {
        int objectIndex = objectTable.indexOf(val);
        if (objectIndex == -1) {
            objectTable.add(val);
            byte[] data = val.getData().getBytes("UTF-8");
            this.writeU29(data.length << 1 | 1);
            this.writeBytes(data);
        } else {
            this.writeU29(objectIndex << 1);
        }
    }

    private void writeXml(XmlType val, List<Object> objectTable) throws IOException {
        int objectIndex = objectTable.indexOf(val);
        if (objectIndex == -1) {
            objectTable.add(val);
            byte[] data = val.getData().getBytes("UTF-8");
            this.writeU29(data.length << 1 | 1);
            this.writeBytes(data);
        } else {
            this.writeU29(objectIndex << 1);
        }
    }

    @Override
    public void write(int v) throws IOException {
        this.os.write(v);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    private void writeArray(ArrayType val, Map<String, ObjectTypeSerializeHandler> serializers, List<String> stringTable, List<Traits> traitsTable, List<Object> objectTable) throws IOException, NoSerializerExistsException {
        int objectIndex = objectTable.indexOf(val);
        if (objectIndex == -1) {
            objectTable.add(val);
            this.writeU29(val.getDenseValues().size() << 1 | 1);
            for (String key : val.associativeKeySet()) {
                this.writeUtf8Vr(key, stringTable);
                this.writeValue(val.getAssociative(key), serializers, stringTable, traitsTable, objectTable);
            }
            this.writeUtf8Vr("", stringTable);
            for (Object v : val.getDenseValues()) {
                this.writeValue(v, serializers, stringTable, traitsTable, objectTable);
            }
        } else {
            this.writeU29(objectIndex << 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeObject(ObjectType val, Map<String, ObjectTypeSerializeHandler> serializers, List<String> stringTable, List<Traits> traitsTable, List<Object> objectTable) throws IOException, NoSerializerExistsException {
        int objectIndex = objectTable.indexOf(val);
        if (objectIndex == -1) {
            objectTable.add(val);
            Traits traits = val.getTraits();
            int traitsIndex = traitsTable.indexOf(traits);
            if (traitsIndex == -1) {
                if (val.isSerialized()) {
                    this.writeU29(7L);
                    this.writeUtf8Vr(val.getClassName(), stringTable);
                    if (serializers.containsKey(val.getClassName())) {
                        serializers.get(val.getClassName()).writeObject(val.getSerializedMembers(), this.os);
                    } else {
                        if (val.getSerializedData() == null) throw new NoSerializerExistsException(val.getClassName(), null, null);
                        this.writeBytes(val.getSerializedData());
                    }
                } else {
                    traitsTable.add(traits);
                    this.writeU29(val.sealedMembersSize() << 4 | 1 | 2 | (traits.isDynamic() ? 8 : 0));
                    this.writeUtf8Vr(val.getClassName(), stringTable);
                    for (String key : val.sealedMembersKeySet()) {
                        this.writeUtf8Vr(key, stringTable);
                    }
                }
            } else {
                this.writeU29(traitsIndex << 2 | 1);
            }
            for (String key : val.sealedMembersKeySet()) {
                this.writeValue(val.getSealedMember(key), serializers, stringTable, traitsTable, objectTable);
            }
            if (!traits.isDynamic()) return;
            for (String key : val.dynamicMembersKeySet()) {
                this.writeUtf8Vr(key, stringTable);
                this.writeValue(val.getDynamicMember(key), serializers, stringTable, traitsTable, objectTable);
            }
            this.writeUtf8Vr("", stringTable);
            return;
        } else {
            this.writeU29(objectIndex << 1);
        }
    }

    public void writeValue(Object object) throws IOException, NoSerializerExistsException {
        this.writeValue(object, new HashMap<String, ObjectTypeSerializeHandler>());
    }

    public void writeValue(Object object, Map<String, ObjectTypeSerializeHandler> serializers) throws IOException, NoSerializerExistsException {
        this.writeValue(object, serializers, new ArrayList<String>(), new ArrayList<Traits>(), new ArrayList<Object>());
    }

    public void writeValue(Object object, Map<String, ObjectTypeSerializeHandler> serializers, List<String> stringTable, List<Traits> traitsTable, List<Object> objectTable) throws IOException, NoSerializerExistsException {
        if (object == BasicType.UNDEFINED) {
            this.writeU8(0);
        } else if (object == BasicType.NULL) {
            this.writeU8(1);
        } else if (object == Boolean.FALSE) {
            this.writeU8(2);
        } else if (object == Boolean.TRUE) {
            this.writeU8(3);
        } else if (object != BasicType.UNKNOWN) {
            if (object instanceof Long) {
                this.writeU8(4);
                this.writeU29((Long)object);
            } else if (object instanceof Double) {
                this.writeU8(5);
                this.writeDouble((Double)object);
            } else if (object instanceof String) {
                this.writeU8(6);
                this.writeUtf8Vr((String)object, stringTable);
            } else if (object instanceof XmlDocType) {
                this.writeU8(7);
                this.writeXmlDoc((XmlDocType)object, objectTable);
            } else if (object instanceof DateType) {
                this.writeU8(8);
                int dateIndex = objectTable.indexOf(object);
                DateType val = (DateType)object;
                if (dateIndex == -1) {
                    objectTable.add(val);
                    this.writeU29(1L);
                    this.writeDouble(val.getVal());
                } else {
                    this.writeU29(dateIndex << 1);
                }
            } else if (object instanceof ArrayType) {
                this.writeU8(9);
                this.writeArray((ArrayType)object, serializers, stringTable, traitsTable, objectTable);
            } else if (object instanceof ObjectType) {
                this.writeU8(10);
                this.writeObject((ObjectType)object, serializers, stringTable, traitsTable, objectTable);
            } else if (object instanceof XmlType) {
                this.writeU8(11);
                this.writeXml((XmlType)object, objectTable);
            } else if (object instanceof ByteArrayType) {
                this.writeU8(12);
                this.writeByteArray((ByteArrayType)object, objectTable);
            } else if (object instanceof VectorIntType) {
                this.writeU8(13);
                int vectorIndex = objectTable.indexOf(object);
                VectorIntType val = (VectorIntType)object;
                if (vectorIndex == -1) {
                    objectTable.add(val);
                    this.writeU29(val.getValues().size() << 1 | 1);
                    this.writeU8(val.isFixed() ? 1 : 0);
                    Iterator iterator = val.getValues().iterator();
                    while (iterator.hasNext()) {
                        long v = (Long)iterator.next();
                        this.writeU32(v);
                    }
                } else {
                    this.writeU29(vectorIndex << 1);
                }
            } else if (object instanceof VectorUIntType) {
                this.writeU8(14);
                int vectorIndex = objectTable.indexOf(object);
                VectorUIntType val = (VectorUIntType)object;
                if (vectorIndex == -1) {
                    objectTable.add(val);
                    this.writeU29(val.getValues().size() << 1 | 1);
                    this.writeU8(val.isFixed() ? 1 : 0);
                    Iterator iterator = val.getValues().iterator();
                    while (iterator.hasNext()) {
                        long v = (Long)iterator.next();
                        this.writeU32(v);
                    }
                } else {
                    this.writeU29(vectorIndex << 1);
                }
            } else if (object instanceof VectorDoubleType) {
                this.writeU8(15);
                int vectorIndex = objectTable.indexOf(object);
                VectorDoubleType val = (VectorDoubleType)object;
                if (vectorIndex == -1) {
                    objectTable.add(val);
                    this.writeU29(val.getValues().size() << 1 | 1);
                    this.writeU8(val.isFixed() ? 1 : 0);
                    Iterator iterator = val.getValues().iterator();
                    while (iterator.hasNext()) {
                        double v = (Double)iterator.next();
                        this.writeDouble(v);
                    }
                } else {
                    this.writeU29(vectorIndex << 1);
                }
            } else if (object instanceof VectorObjectType) {
                this.writeU8(16);
                int vectorIndex = objectTable.indexOf(object);
                VectorObjectType val = (VectorObjectType)object;
                if (vectorIndex == -1) {
                    objectTable.add(val);
                    this.writeU29(val.getValues().size() << 1 | 1);
                    this.writeU8(val.isFixed() ? 1 : 0);
                    this.writeUtf8Vr(val.getTypeName(), stringTable);
                    for (Object v : val.getValues()) {
                        this.writeValue(v, serializers, stringTable, traitsTable, objectTable);
                    }
                } else {
                    this.writeU29(vectorIndex << 1);
                }
            } else if (object instanceof DictionaryType) {
                this.writeU8(17);
                int dictionaryIndex = objectTable.indexOf(object);
                DictionaryType val = (DictionaryType)object;
                if (dictionaryIndex == -1) {
                    objectTable.add(val);
                    this.writeU29(val.size() << 1 | 1);
                    this.writeU8(val.hasWeakKeys() ? 1 : 0);
                    for (Object key : val.keySet()) {
                        this.writeValue(key, serializers, stringTable, traitsTable, objectTable);
                        this.writeValue(val.get(key), serializers, stringTable, traitsTable, objectTable);
                    }
                } else {
                    this.writeU29(dictionaryIndex << 1);
                }
            } else {
                throw new UnsupportedValueTypeException(object.getClass());
            }
        }
    }
}

