/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.docs;

import com.jpexs.decompiler.flash.docs.As3PCodeDocs;
import com.jpexs.decompiler.flash.docs.DocsOperandLexer;
import com.jpexs.decompiler.flash.docs.ParsedSymbol;
import com.jpexs.helpers.Cache;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbstractDocs {
    protected static Cache<String, String> docsCache = Cache.getInstance(false, true, "abstractDocsCache", false);

    protected static String htmlFooter() {
        StringBuilder sb = new StringBuilder();
        sb.append("</html>");
        return sb.toString();
    }

    public static String getStyle() {
        String cached = docsCache.get("__style");
        if (cached != null) {
            return cached;
        }
        String style = "";
        InputStream is = As3PCodeDocs.class.getResourceAsStream("/com/jpexs/decompiler/flash/docs/docs.css");
        if (is == null) {
            Logger.getLogger(As3PCodeDocs.class.getName()).log(Level.SEVERE, "docs.css needed for documentation not found");
        } else {
            style = new String(Helper.readStream(is), Utf8Helper.charset);
        }
        docsCache.put("__style", style);
        return style;
    }

    protected static String metaProp(String name, String content) {
        return "\t\t<meta property=\"" + name + "\" content=\"" + content + "\">" + "\r\n";
    }

    protected static String meta(String name, String content) {
        return "\t\t<meta name=\"" + name + "\" content=\"" + content + "\">" + "\r\n";
    }

    protected static String meta(String name, Date content) {
        return "\t\t<meta name=\"" + name + "\" content=\"" + AbstractDocs.getISO8601StringForDate(content) + "\">" + "\r\n";
    }

    protected static String getISO8601StringForDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    protected static String hilightArgument(String docs, int argumentIndex) {
        int opEndIndex;
        if (argumentIndex < 0) {
            return docs;
        }
        String opHeader = "<span class=\"instruction-operands\">";
        int opIndex = docs.indexOf(opHeader) + opHeader.length();
        String operandDocs = docs.substring(opIndex, opEndIndex = docs.indexOf("</span>", opIndex)).trim();
        if (operandDocs.isEmpty()) {
            return docs;
        }
        DocsOperandLexer lexer = new DocsOperandLexer(new StringReader(operandDocs));
        try {
            int pos = 0;
            int endPos = 0;
            int startPos = 0;
            while (true) {
                startPos = lexer.yychar();
                ParsedSymbol symb = lexer.lex();
                if (symb.type == ParsedSymbol.TYPE_DOTS) {
                    endPos = lexer.yychar() + 3;
                    break;
                }
                if (symb.type == ParsedSymbol.TYPE_EOF) {
                    endPos = lexer.yychar();
                    break;
                }
                if (symb.type == ParsedSymbol.TYPE_BRACKET_OPEN) {
                    while (symb.type != ParsedSymbol.TYPE_BRACKET_CLOSE && symb.type != ParsedSymbol.TYPE_EOF) {
                        symb = lexer.lex();
                    }
                    endPos = lexer.yychar() + 1;
                    break;
                }
                if (symb.type != ParsedSymbol.TYPE_IDENTIFIER) continue;
                symb = lexer.lex();
                endPos = lexer.yychar();
                if (symb.type == ParsedSymbol.TYPE_COLON) {
                    do {
                        symb = lexer.lex();
                        if (symb.type != ParsedSymbol.TYPE_IDENTIFIER && symb.type != ParsedSymbol.TYPE_STAR) {
                            throw new IOException("type identifier expected");
                        }
                        symb = lexer.lex();
                        endPos = lexer.yychar();
                    } while (symb.type == ParsedSymbol.TYPE_PIPE);
                }
                if (pos == argumentIndex || symb.type != ParsedSymbol.TYPE_COMMA) break;
                ++pos;
            }
            String hilightedOperandDocs = operandDocs.substring(0, startPos) + "<strong class=\"selected-operand\">" + operandDocs.substring(startPos, endPos) + "</strong>" + operandDocs.substring(endPos);
            docs = docs.substring(0, opIndex) + hilightedOperandDocs + docs.substring(opEndIndex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return docs;
    }
}

