/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.docs;

import com.jpexs.decompiler.flash.ApplicationInfo;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.docs.AbstractDocs;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class As3PCodeDocs
extends AbstractDocs {
    static ResourceBundle prop;
    private static final Map<AVM2InstructionFlag, String> flagDescriptions;
    private static final Map<String, InstructionDefinition> nameToDef;
    static final String NEWLINE = "\r\n";

    private static String makeIdent(String name) {
        StringBuilder identName = new StringBuilder();
        boolean cap = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                cap = true;
                continue;
            }
            if (cap) {
                identName.append(c);
                cap = false;
                continue;
            }
            identName.append(Character.toLowerCase(c));
        }
        return identName.toString();
    }

    public static String getDocsForIns(String insName, boolean showDataSize, boolean ui, boolean withStyle, boolean nightMode, int argumentToHilight) {
        if (!nameToDef.containsKey(insName)) {
            return null;
        }
        return As3PCodeDocs.getDocsForIns(nameToDef.get(insName), showDataSize, ui, withStyle, nightMode, argumentToHilight);
    }

    public static String getDocsForIns(InstructionDefinition def, boolean showDataSize, boolean ui, boolean standalone, boolean nightMode, int argumentToHilight) {
        String operandsDoc;
        String cacheKey = def.instructionName + "|" + (showDataSize ? 1 : 0) + "|" + (ui ? 1 : 0) + "|" + (standalone ? 1 : 0);
        String v = (String)docsCache.get(cacheKey);
        if (v != null) {
            return As3PCodeDocs.hilightArgument(v, argumentToHilight);
        }
        StringBuilder sb = new StringBuilder();
        if (standalone) {
            sb.append(As3PCodeDocs.htmlHeader("", As3PCodeDocs.getStyle(), nightMode));
        }
        String insName = def.instructionName;
        String insShortDescription = As3PCodeDocs.getProperty("instruction." + insName + ".shortDescription");
        String insDescription = As3PCodeDocs.getProperty("instruction." + insName + ".description");
        String stackBefore = def.hasFlag(AVM2InstructionFlag.UNKNOWN_STACK) ? "" : As3PCodeDocs.getProperty("instruction." + insName + ".stackBefore");
        String stackAfter = def.hasFlag(AVM2InstructionFlag.UNKNOWN_STACK) ? "" : As3PCodeDocs.getProperty("instruction." + insName + ".stackAfter");
        stackBefore = stackBefore.trim().isEmpty() ? As3PCodeDocs.getProperty("ui.stack.before.empty") : As3PCodeDocs.getProperty("ui.stack.before") + stackBefore;
        stackAfter = stackAfter.trim().isEmpty() ? As3PCodeDocs.getProperty("ui.stack.before.empty") : As3PCodeDocs.getProperty("ui.stack.before") + stackAfter;
        stackBefore = "<span class=\"stack-before\">" + stackBefore + "</span>";
        stackAfter = "<span class=\"stack-after\">" + stackAfter + "</span>";
        String stack = def.hasFlag(AVM2InstructionFlag.UNKNOWN_STACK) ? As3PCodeDocs.getProperty("ui.unknown") : stackBefore + "<span class=\"stack-to\">" + As3PCodeDocs.getProperty("ui.stack.to") + "</span>" + stackAfter;
        String string = operandsDoc = def.hasFlag(AVM2InstructionFlag.UNKNOWN_OPERANDS) ? As3PCodeDocs.getProperty("ui.unknown") : As3PCodeDocs.getProperty("instruction." + insName + ".operands");
        if (standalone) {
            sb.append("<body class=\"");
            if (nightMode) {
                sb.append("standalonenight");
            } else {
                sb.append("standalone");
            }
            sb.append("\">");
        }
        sb.append("<div class=\"instruction");
        for (AVM2InstructionFlag fl : def.flags) {
            sb.append(" instruction-flag-").append(As3PCodeDocs.makeIdent(fl.toString()));
        }
        sb.append("\">");
        sb.append("<div class=\"instruction-signature\"><span class=\"instruction-code\">").append(String.format("0x%02X", def.instructionCode)).append("</span> <strong class=\"instruction-name\">").append(insName).append("</strong>");
        if (def.hasFlag(AVM2InstructionFlag.UNKNOWN_OPERANDS)) {
            sb.append(" ").append(As3PCodeDocs.getProperty("ui.unknown")).append(NEWLINE);
        } else if (ui && insName.equals("lookupswitch")) {
            sb.append(" ");
            sb.append("<span class=\"instruction-operands\">");
            sb.append(As3PCodeDocs.getProperty("instruction.lookupswitch.operands.ui"));
            sb.append("</span>");
        } else {
            String[] operandsDocs = operandsDoc.split(", ?");
            boolean first = true;
            if (def.operands.length > 0) {
                sb.append(" ");
            }
            sb.append("<span class=\"instruction-operands\">");
            for (int i = 0; i < def.operands.length; ++i) {
                int op = def.operands[i];
                String opDoc = operandsDocs[i];
                String operandTypeRaw = AVM2Code.operandTypeToString(op, false);
                String operandTypeCombined = AVM2Code.operandTypeToString(op, true);
                if (operandTypeCombined.contains(", ")) {
                    String[] operandTypesCombined = operandTypeCombined.split(", ?");
                    String[] operandTypesRaw = operandTypeRaw.split(", ?");
                    for (int j = 0; j < operandTypesCombined.length; ++j) {
                        if (!first) {
                            sb.append(", ");
                        } else {
                            first = false;
                        }
                        opDoc = operandsDocs[i + j];
                        operandTypeCombined = operandTypesCombined[j];
                        operandTypeRaw = operandTypesRaw[j];
                        operandTypeRaw = As3PCodeDocs.getProperty("operandType." + operandTypeRaw + (ui ? ".uiName" : ".name"));
                        if (opDoc.equals("...")) {
                            sb.append("...");
                            continue;
                        }
                        sb.append(opDoc);
                        sb.append(":").append(showDataSize ? operandTypeCombined : operandTypeRaw);
                    }
                    continue;
                }
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                operandTypeRaw = As3PCodeDocs.getProperty("operandType." + operandTypeRaw + (ui ? ".uiName" : ".name"));
                if (opDoc.equals(operandTypeRaw)) {
                    sb.append(showDataSize ? operandTypeCombined : operandTypeRaw);
                    continue;
                }
                sb.append(opDoc).append(":").append(showDataSize ? operandTypeCombined : operandTypeRaw);
            }
            sb.append("</span>");
        }
        sb.append("</div>").append(NEWLINE);
        sb.append("<div class=\"short-description\">").append(insShortDescription).append("</div>").append(NEWLINE);
        if (!insDescription.trim().isEmpty()) {
            sb.append("<div class=\"description\">").append("<strong class=\"description-title\">").append(As3PCodeDocs.getProperty("ui.description")).append("</strong>").append(insDescription).append("</div>").append(NEWLINE);
        }
        sb.append("<div class=\"stack\"><strong class=\"stack-title\">").append(As3PCodeDocs.getProperty("ui.stack")).append("</strong><span class=\"stack-values " + (def.hasFlag(AVM2InstructionFlag.UNKNOWN_STACK) ? " unknown" : "") + "\">").append(stack).append("</span>").append("</div>").append(NEWLINE);
        boolean flagsPrinted = false;
        AVM2InstructionFlag[] flags = (AVM2InstructionFlag[])def.flags.clone();
        Arrays.sort(flags, Enum::compareTo);
        for (AVM2InstructionFlag fl : flags) {
            String depDetail;
            if (!flagsPrinted) {
                flagsPrinted = true;
                sb.append("<strong class=\"flags-title\">").append(As3PCodeDocs.getProperty("ui.flags")).append("</strong>").append("<br />").append(NEWLINE).append("<ul class=\"flags\">").append(NEWLINE);
            }
            sb.append("\t<li class=\"flag flag-").append(As3PCodeDocs.makeIdent(fl.toString())).append("\">").append(flagDescriptions.get((Object)fl));
            if (fl == AVM2InstructionFlag.DEPRECATED && (depDetail = As3PCodeDocs.getProperty("instruction." + insName + ".deprecated")) != null) {
                sb.append(": <span class=\"flag-deprecated-detail\">").append(depDetail).append("</span>");
            }
            sb.append("</li>").append(NEWLINE);
        }
        if (flagsPrinted) {
            sb.append("</ul>").append(NEWLINE);
        }
        sb.append("</div>").append(NEWLINE);
        if (standalone) {
            sb.append("</body>");
            sb.append(As3PCodeDocs.htmlFooter());
        }
        String r = sb.toString();
        docsCache.put(cacheKey, r);
        return As3PCodeDocs.hilightArgument(r, argumentToHilight);
    }

    public static String getJs() {
        String cached = (String)docsCache.get("__js");
        if (cached != null) {
            return cached;
        }
        String js = "";
        InputStream is = As3PCodeDocs.class.getResourceAsStream("/com/jpexs/decompiler/flash/docs/docs.js");
        if (is == null) {
            Logger.getLogger(As3PCodeDocs.class.getName()).log(Level.SEVERE, "docs.js needed for documentation not found");
        } else {
            js = new String(Helper.readStream(is), Utf8Helper.charset);
        }
        docsCache.put("__js", js);
        return js;
    }

    public static String getAllInstructionDocs(boolean nightMode) {
        AVM2InstructionFlag[] hideFlags;
        String jsData = "";
        jsData = jsData + "var txt_filter_hide = \"" + As3PCodeDocs.getProperty("ui.filter.hide") + "\";" + NEWLINE;
        jsData = jsData + "var txt_filter_byname = \"" + As3PCodeDocs.getProperty("ui.filter.byname") + "\";" + NEWLINE;
        jsData = jsData + "var txt_filter_order = \"" + As3PCodeDocs.getProperty("ui.filter.order") + "\";" + NEWLINE;
        jsData = jsData + "var txt_filter_order_code = \"" + As3PCodeDocs.getProperty("ui.filter.order.code") + "\";" + NEWLINE;
        jsData = jsData + "var txt_filter_order_name = \"" + As3PCodeDocs.getProperty("ui.filter.order.name") + "\";" + NEWLINE;
        jsData = jsData + "var order_set = \"name\";";
        jsData = jsData + "var flags_set = {};\r\n";
        jsData = jsData + "var flags = {};\r\n";
        for (AVM2InstructionFlag f : AVM2InstructionFlag.values()) {
            jsData = jsData + "flags[\"" + As3PCodeDocs.makeIdent(f.toString()) + "\"] = \"" + Helper.escapeJavaString(flagDescriptions.get((Object)f)) + "\";" + NEWLINE;
            jsData = jsData + "flags_set[\"" + As3PCodeDocs.makeIdent(f.toString()) + "\"] = false;" + NEWLINE;
        }
        for (AVM2InstructionFlag f : hideFlags = new AVM2InstructionFlag[]{AVM2InstructionFlag.UNDOCUMENTED, AVM2InstructionFlag.UNKNOWN_STACK, AVM2InstructionFlag.ES4_NUMERICS_MINOR, AVM2InstructionFlag.FLOAT4_SUPPORT, AVM2InstructionFlag.UNKNOWN_OPERANDS}) {
            jsData = jsData + "flags_set[\"" + As3PCodeDocs.makeIdent(f.toString()) + "\"] = true;" + NEWLINE;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(As3PCodeDocs.htmlHeader(jsData + As3PCodeDocs.getJs(), As3PCodeDocs.getStyle(), nightMode));
        sb.append("<body");
        if (nightMode) {
            sb.append(" class=\"night\"");
        }
        sb.append(">");
        sb.append("\t\t<h1>").append(As3PCodeDocs.getProperty("ui.list.heading")).append("</h1>").append(NEWLINE);
        sb.append("<span id=\"js-switcher\" class=\"js\"></span>");
        sb.append("\t\t<ul class=\"instruction-list\">").append(NEWLINE);
        TreeSet<String> s = new TreeSet<String>(nameToDef.keySet());
        for (String name : s) {
            InstructionDefinition def = nameToDef.get(name);
            if (def == null) continue;
            sb.append("\t\t\t<li class=\"instruction-item\">").append(NEWLINE);
            sb.append("\t\t\t\t").append(As3PCodeDocs.getDocsForIns(def, true, false, false, nightMode, -1).trim().replace(NEWLINE, "\r\n\t\t\t\t")).append(NEWLINE);
            sb.append("\t\t\t</li>").append(NEWLINE);
        }
        sb.append("\t\t</ul>").append(NEWLINE);
        sb.append("\t</body>").append(NEWLINE);
        sb.append(As3PCodeDocs.htmlFooter());
        return sb.toString();
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(As3PCodeDocs.getAllInstructionDocs(false));
    }

    protected static String htmlHeader(String js, String style, boolean nightMode) {
        Date dateGenerated = new Date();
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>").append(NEWLINE).append("<html>").append(NEWLINE).append("\t<head>").append(NEWLINE);
        if (style != null && !style.isEmpty()) {
            sb.append("\t\t<style>").append(style).append("</style>").append(NEWLINE);
        }
        if (js != null && !js.isEmpty()) {
            sb.append("\t\t<script>").append(js).append("</script>").append(NEWLINE);
        }
        sb.append("\t\t<meta charset=\"UTF-8\">").append(NEWLINE).append(As3PCodeDocs.meta("generator", ApplicationInfo.applicationVerName)).append(As3PCodeDocs.meta("description", As3PCodeDocs.getProperty("ui.list.pageDescription"))).append(As3PCodeDocs.metaProp("og:title", As3PCodeDocs.getProperty("ui.list.pageTitle"))).append(As3PCodeDocs.metaProp("og:type", "article")).append(As3PCodeDocs.metaProp("og:description", As3PCodeDocs.getProperty("ui.list.pageDescription"))).append(As3PCodeDocs.meta("date", dateGenerated)).append("\t\t<title>").append(As3PCodeDocs.getProperty("ui.list.documentTitle")).append("</title>").append(NEWLINE).append("\t</head>").append(NEWLINE);
        return sb.toString();
    }

    protected static String getProperty(String name) {
        if (prop.containsKey(name)) {
            return Helper.escapeHTML(prop.getString(name));
        }
        return null;
    }

    static {
        flagDescriptions = new HashMap<AVM2InstructionFlag, String>();
        nameToDef = new HashMap<String, InstructionDefinition>();
        prop = ResourceBundle.getBundle("com.jpexs.decompiler.flash.locales.docs.pcode.AS3");
        for (InstructionDefinition instructionDefinition : AVM2Code.allInstructionSet) {
            if (instructionDefinition == null) continue;
            nameToDef.put(instructionDefinition.instructionName, instructionDefinition);
        }
        for (AVM2InstructionFlag aVM2InstructionFlag : AVM2InstructionFlag.values()) {
            String flagIdent = As3PCodeDocs.makeIdent(aVM2InstructionFlag.toString());
            String flagDescription = As3PCodeDocs.getProperty("instructionFlag." + flagIdent);
            flagDescriptions.put(aVM2InstructionFlag, flagDescription);
        }
    }
}

