/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.settings.BinaryDataExportSettings;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.BinaryDataInterface;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class BinaryDataExporter {
    public List<File> exportBinaryData(AbortRetryIgnoreHandler handler, String outdir, ReadOnlyTagList tags, BinaryDataExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        ArrayList<BinaryDataInterface> binaryDatas = new ArrayList<BinaryDataInterface>();
        for (Tag t : tags) {
            if (!(t instanceof BinaryDataInterface)) continue;
            binaryDatas.add((BinaryDataInterface)((Object)t));
        }
        return this.exportBinaryData(handler, outdir, binaryDatas, settings, evl);
    }

    public List<File> exportBinaryData(AbortRetryIgnoreHandler handler, String outdir, List<BinaryDataInterface> binaryDatas, BinaryDataExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (CancellableWorker.isInterrupted()) {
            return ret;
        }
        if (binaryDatas.isEmpty()) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        int count = binaryDatas.size();
        if (count == 0) {
            return ret;
        }
        int currentIndex = 1;
        for (BinaryDataInterface t : binaryDatas) {
            if (evl != null) {
                evl.handleExportingEvent("binarydata", currentIndex, count, t.getName());
            }
            String ext = t.getInnerSwf() == null ? ".bin" : ".swf";
            File file = new File(outdir + File.separator + Helper.makeFileName(t.getCharacterExportFileName() + ext));
            new RetryTask(() -> {
                try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
                    ((OutputStream)fos).write(t.getDataBytes().getRangeData());
                }
            }, handler).run();
            DefineBinaryDataTag bdt = (DefineBinaryDataTag)t.getTopLevelBinaryData();
            LinkedHashSet<String> classNames = bdt.getClassNames();
            if (Configuration.as3ExportNamesUseClassNamesOnly.get().booleanValue() && !classNames.isEmpty()) {
                for (String className : classNames) {
                    File classFile = new File(outdir + File.separator + Helper.makeFileName(t.getClassExportFileName(className) + ext));
                    new RetryTask(() -> Files.copy(file.toPath(), classFile.toPath(), StandardCopyOption.REPLACE_EXISTING), handler).run();
                    ret.add(classFile);
                }
                file.delete();
            } else {
                ret.add(file);
            }
            if (CancellableWorker.isInterrupted()) break;
            if (evl != null) {
                evl.handleExportedEvent("binarydata", currentIndex, count, t.getName());
            }
            ++currentIndex;
        }
        return ret;
    }
}

