/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.tags.base.HasSeparateAlphaChannel;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.helpers.Helper;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Vector;

public class ImageTagBufferedImage
extends BufferedImage {
    private byte[] imageData;
    private ImageTag tag;
    private final BufferedImage image;

    public ImageTagBufferedImage(ImageTag tag, BufferedImage image) {
        super(1, 1, 1);
        this.image = image;
        this.tag = tag;
    }

    public int getImageId() {
        return this.tag.getCharacterId();
    }

    public boolean isJpeg() {
        return this.tag.getOriginalImageFormat() == ImageFormat.JPEG;
    }

    public byte[] getAlphaChannel() {
        if (this.tag instanceof HasSeparateAlphaChannel) {
            HasSeparateAlphaChannel hsac = (HasSeparateAlphaChannel)((Object)this.tag);
            try {
                return hsac.getImageAlpha();
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public byte[] getImageData() {
        if (this.imageData != null) {
            return this.imageData;
        }
        this.imageData = Helper.readStream(this.tag.getOriginalImageData());
        return this.imageData;
    }

    @Override
    public int getTransparency() {
        return this.image.getTransparency();
    }

    @Override
    public void releaseWritableTile(int tileX, int tileY) {
        this.image.releaseWritableTile(tileX, tileY);
    }

    @Override
    public WritableRaster getWritableTile(int tileX, int tileY) {
        return this.image.getWritableTile(tileX, tileY);
    }

    @Override
    public boolean hasTileWriters() {
        return this.image.hasTileWriters();
    }

    @Override
    public Point[] getWritableTileIndices() {
        return this.image.getWritableTileIndices();
    }

    @Override
    public boolean isTileWritable(int tileX, int tileY) {
        return this.image.isTileWritable(tileX, tileY);
    }

    @Override
    public void removeTileObserver(TileObserver to) {
        this.image.removeTileObserver(to);
    }

    @Override
    public void addTileObserver(TileObserver to) {
        this.image.addTileObserver(to);
    }

    @Override
    public void setData(Raster r) {
        this.image.setData(r);
    }

    @Override
    public WritableRaster copyData(WritableRaster outRaster) {
        return this.image.copyData(outRaster);
    }

    @Override
    public Raster getData(Rectangle rect) {
        return this.image.getData(rect);
    }

    @Override
    public Raster getData() {
        return this.image.getData();
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        return this.image.getTile(tileX, tileY);
    }

    @Override
    public int getTileGridYOffset() {
        return this.image.getTileGridXOffset();
    }

    @Override
    public int getTileGridXOffset() {
        return this.image.getTileGridXOffset();
    }

    @Override
    public int getTileHeight() {
        return this.image.getTileHeight();
    }

    @Override
    public int getTileWidth() {
        return this.image.getTileWidth();
    }

    @Override
    public int getMinTileY() {
        return this.image.getMinTileY();
    }

    @Override
    public int getMinTileX() {
        return this.image.getMinTileX();
    }

    @Override
    public int getNumYTiles() {
        return this.image.getNumYTiles();
    }

    @Override
    public int getNumXTiles() {
        return this.image.getNumXTiles();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.image.getSampleModel();
    }

    @Override
    public int getMinY() {
        return this.image.getMinY();
    }

    @Override
    public int getMinX() {
        return this.image.getMinX();
    }

    @Override
    public String[] getPropertyNames() {
        return this.image.getPropertyNames();
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return this.image.getSources();
    }

    @Override
    public String toString() {
        return this.image.toString();
    }

    @Override
    public void coerceData(boolean isAlphaPremultiplied) {
        this.image.coerceData(isAlphaPremultiplied);
    }

    @Override
    public boolean isAlphaPremultiplied() {
        return this.image.isAlphaPremultiplied();
    }

    @Override
    public BufferedImage getSubimage(int x, int y, int w, int h) {
        return this.image.getSubimage(x, y, w, h);
    }

    @Override
    public Graphics2D createGraphics() {
        return this.image.createGraphics();
    }

    @Override
    public Graphics getGraphics() {
        return this.image.getGraphics();
    }

    @Override
    public Object getProperty(String name) {
        return this.image.getProperty(name);
    }

    @Override
    public Object getProperty(String name, ImageObserver observer) {
        return this.image.getProperty(name, observer);
    }

    @Override
    public ImageProducer getSource() {
        return this.image.getSource();
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.image.getWidth(observer);
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.image.getHeight(observer);
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public void setRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        this.image.setRGB(startX, startY, w, h, rgbArray, offset, scansize);
    }

    @Override
    public void setRGB(int x, int y, int rgb) {
        this.image.setRGB(x, y, rgb);
    }

    @Override
    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        return this.image.getRGB(startX, startY, w, h, rgbArray, offset, scansize);
    }

    @Override
    public int getRGB(int x, int y) {
        return this.image.getRGB(x, y);
    }

    @Override
    public WritableRaster getAlphaRaster() {
        return this.image.getAlphaRaster();
    }

    @Override
    public WritableRaster getRaster() {
        return this.image.getRaster();
    }

    @Override
    public ColorModel getColorModel() {
        return this.image.getColorModel();
    }

    @Override
    public int getType() {
        return this.image.getType();
    }

    @Override
    public float getAccelerationPriority() {
        return this.image.getAccelerationPriority();
    }

    @Override
    public void setAccelerationPriority(float priority) {
        this.image.setAccelerationPriority(priority);
    }

    @Override
    public ImageCapabilities getCapabilities(GraphicsConfiguration gc) {
        return this.image.getCapabilities(gc);
    }

    @Override
    public void flush() {
        this.image.flush();
    }

    @Override
    public Image getScaledInstance(int width, int height, int hints) {
        return this.image.getScaledInstance(width, height, hints);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImageTagBufferedImage) {
            return this.tag.getCharacterId() == ((ImageTagBufferedImage)obj).tag.getCharacterId();
        }
        return this.image.equals(obj);
    }

    public int hashCode() {
        return this.tag.getCharacterId();
    }
}

