/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.commonshape;

import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Point;
import com.jpexs.decompiler.flash.types.MATRIX;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class Matrix
implements Cloneable {
    public double scaleX = 1.0;
    public double scaleY = 1.0;
    public double rotateSkew0;
    public double rotateSkew1;
    public double translateX;
    public double translateY;

    public static Matrix getScaleInstance(double scale) {
        Matrix mat = new Matrix();
        mat.scale(scale);
        return mat;
    }

    public static Matrix getScaleInstance(double scaleX, double scaleY) {
        Matrix mat = new Matrix();
        mat.scale(scaleX, scaleY);
        return mat;
    }

    public static Matrix getRotateInstance(double rotateAngle) {
        return Matrix.getRotateInstance(rotateAngle, 0.0, 0.0);
    }

    public static Matrix getRotateInstance(double rotateAngle, double tx, double ty) {
        double angleRad = -rotateAngle * Math.PI / 180.0;
        Matrix mat = new Matrix();
        mat.rotateSkew0 = -Math.sin(angleRad);
        mat.rotateSkew1 = Math.sin(angleRad);
        mat.scaleX = Math.cos(angleRad);
        mat.scaleY = Math.cos(angleRad);
        mat = mat.preConcatenate(Matrix.getTranslateInstance(tx, ty)).concatenate(Matrix.getTranslateInstance(-tx, -ty));
        return mat;
    }

    public static Matrix getSkewXInstance(double skewAngle) {
        double angleRad = skewAngle * Math.PI / 180.0;
        Matrix mat = new Matrix();
        mat.rotateSkew1 = Math.tan(angleRad);
        return mat;
    }

    public static Matrix getSkewYInstance(double skewAngle) {
        double angleRad = skewAngle * Math.PI / 180.0;
        Matrix mat = new Matrix();
        mat.rotateSkew0 = Math.tan(angleRad);
        return mat;
    }

    public static Matrix getTranslateInstance(double x, double y) {
        Matrix mat = new Matrix();
        mat.translate(x, y);
        return mat;
    }

    public Matrix() {
        this.scaleX = 1.0;
        this.scaleY = 1.0;
    }

    public Matrix(double scaleX, double scaleY, double rotateSkew0, double rotateSkew1, double translateX, double translateY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.rotateSkew0 = rotateSkew0;
        this.rotateSkew1 = rotateSkew1;
        this.translateX = translateX;
        this.translateY = translateY;
    }

    public Matrix(MATRIX matrix) {
        if (matrix == null) {
            matrix = new MATRIX();
        }
        this.translateX = matrix.translateX;
        this.translateY = matrix.translateY;
        if (matrix.hasScale) {
            this.scaleX = matrix.getScaleXFloat();
            this.scaleY = matrix.getScaleYFloat();
        } else {
            this.scaleX = 1.0;
            this.scaleY = 1.0;
        }
        if (matrix.hasRotate) {
            this.rotateSkew0 = matrix.getRotateSkew0Float();
            this.rotateSkew1 = matrix.getRotateSkew1Float();
        }
    }

    public Matrix(AffineTransform transform) {
        this();
        if (transform != null) {
            this.scaleX = transform.getScaleX();
            this.rotateSkew1 = transform.getShearX();
            this.translateX = transform.getTranslateX();
            this.rotateSkew0 = transform.getShearY();
            this.scaleY = transform.getScaleY();
            this.translateY = transform.getTranslateY();
        }
    }

    public Matrix clone() {
        try {
            Matrix mat = (Matrix)super.clone();
            return mat;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException();
        }
    }

    public Point deltaTransform(double x, double y) {
        Point result = new Point(this.scaleX * x + this.rotateSkew1 * y, this.rotateSkew0 * x + this.scaleY * y);
        return result;
    }

    public Point deltaTransform(Point point) {
        return this.deltaTransform(point.x, point.y);
    }

    public java.awt.Point deltaTransform(java.awt.Point point) {
        Point p = this.deltaTransform(point.x, point.y);
        return new java.awt.Point((int)p.x, (int)p.y);
    }

    public Point transform(double x, double y) {
        Point result = new Point(this.scaleX * x + this.rotateSkew1 * y + this.translateX, this.rotateSkew0 * x + this.scaleY * y + this.translateY);
        return result;
    }

    public Point transform(Point point) {
        return this.transform(point.x, point.y);
    }

    public java.awt.Point transform(java.awt.Point point) {
        Point p = this.transform(point.x, point.y);
        return new java.awt.Point((int)Math.round(p.x), (int)Math.round(p.y));
    }

    public Point2D transform(Point2D point) {
        Point p = this.transform(point.getX(), point.getY());
        return new Point2D.Double(p.x, p.y);
    }

    public Rectangle2D transform(Rectangle2D rect) {
        ExportRectangle er = this.transform(new ExportRectangle(rect));
        return new Rectangle2D.Double(er.xMin, er.yMin, er.getWidth(), er.getHeight());
    }

    public ExportRectangle transform(ExportRectangle rect) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        Point point = this.transform(rect.xMin, rect.yMin);
        if (point.x < minX) {
            minX = point.x;
        }
        if (point.x > maxX) {
            maxX = point.x;
        }
        if (point.y < minY) {
            minY = point.y;
        }
        if (point.y > maxY) {
            maxY = point.y;
        }
        point = this.transform(rect.xMax, rect.yMin);
        if (point.x < minX) {
            minX = point.x;
        }
        if (point.x > maxX) {
            maxX = point.x;
        }
        if (point.y < minY) {
            minY = point.y;
        }
        if (point.y > maxY) {
            maxY = point.y;
        }
        point = this.transform(rect.xMin, rect.yMax);
        if (point.x < minX) {
            minX = point.x;
        }
        if (point.x > maxX) {
            maxX = point.x;
        }
        if (point.y < minY) {
            minY = point.y;
        }
        if (point.y > maxY) {
            maxY = point.y;
        }
        point = this.transform(rect.xMax, rect.yMax);
        if (point.x < minX) {
            minX = point.x;
        }
        if (point.x > maxX) {
            maxX = point.x;
        }
        if (point.y < minY) {
            minY = point.y;
        }
        if (point.y > maxY) {
            maxY = point.y;
        }
        return new ExportRectangle(minX, minY, maxX, maxY);
    }

    public void translate(double x, double y) {
        this.translateX = this.scaleX * x + this.rotateSkew1 * y + this.translateX;
        this.translateY = this.rotateSkew0 * x + this.scaleY * y + this.translateY;
    }

    public void scale(double factor) {
        this.scaleX *= factor;
        this.scaleY *= factor;
        this.rotateSkew0 *= factor;
        this.rotateSkew1 *= factor;
    }

    public void scale(double factorX, double factorY) {
        this.scaleX *= factorX;
        this.scaleY *= factorY;
        this.rotateSkew0 *= factorX;
        this.rotateSkew1 *= factorY;
    }

    public Matrix concatenate(Matrix m) {
        Matrix result = new Matrix();
        result.scaleX = this.scaleX * m.scaleX + this.rotateSkew1 * m.rotateSkew0;
        result.rotateSkew0 = this.rotateSkew0 * m.scaleX + this.scaleY * m.rotateSkew0;
        result.rotateSkew1 = this.scaleX * m.rotateSkew1 + this.rotateSkew1 * m.scaleY;
        result.scaleY = this.rotateSkew0 * m.rotateSkew1 + this.scaleY * m.scaleY;
        result.translateX = this.scaleX * m.translateX + this.rotateSkew1 * m.translateY + this.translateX;
        result.translateY = this.rotateSkew0 * m.translateX + this.scaleY * m.translateY + this.translateY;
        return result;
    }

    public Matrix preConcatenate(Matrix m) {
        Matrix result = new Matrix();
        result.scaleX = m.scaleX * this.scaleX + m.rotateSkew1 * this.rotateSkew0;
        result.rotateSkew0 = m.rotateSkew0 * this.scaleX + m.scaleY * this.rotateSkew0;
        result.rotateSkew1 = m.scaleX * this.rotateSkew1 + m.rotateSkew1 * this.scaleY;
        result.scaleY = m.rotateSkew0 * this.rotateSkew1 + m.scaleY * this.scaleY;
        result.translateX = m.scaleX * this.translateX + m.rotateSkew1 * this.translateY + m.translateX;
        result.translateY = m.rotateSkew0 * this.translateX + m.scaleY * this.translateY + m.translateY;
        return result;
    }

    public AffineTransform toTransform() {
        AffineTransform transform = new AffineTransform(this.scaleX, this.rotateSkew0, this.rotateSkew1, this.scaleY, this.translateX, this.translateY);
        return transform;
    }

    public String getSvgTransformationString(double translateDivisor, double unitDivisor) {
        double translateX = this.roundPixels400(this.translateX / translateDivisor);
        double translateY = this.roundPixels400(this.translateY / translateDivisor);
        double rotateSkew0 = this.roundPixels400(this.rotateSkew0 / unitDivisor);
        double rotateSkew1 = this.roundPixels400(this.rotateSkew1 / unitDivisor);
        double scaleX = this.roundPixels400(this.scaleX / unitDivisor);
        double scaleY = this.roundPixels400(this.scaleY / unitDivisor);
        return "matrix(" + scaleX + ", " + rotateSkew0 + ", " + rotateSkew1 + ", " + scaleY + ", " + translateX + ", " + translateY + ")";
    }

    public static String[] parseSvgNumberList(String params) {
        while (params.contains("  ")) {
            params = params.replaceAll("  ", " ");
        }
        params = params.trim();
        params = params.replace(", ", ",");
        params = params.replace(" ", ",");
        String[] args = params.split(",");
        return args;
    }

    public static Matrix parseSvgMatrix(String transformStr, double translateDivisor, double unitDivisor) {
        Matrix ret = new Matrix();
        while (transformStr != null && transformStr.length() > 0) {
            String funcName = transformStr.split("\\(")[0];
            transformStr = transformStr.substring(funcName.length() + 1);
            String params = transformStr.split("\\)")[0];
            transformStr = transformStr.substring(params.length() + 1).trim();
            String[] args = Matrix.parseSvgNumberList(params);
            switch (funcName = funcName.trim()) {
                case "matrix": {
                    if (args.length != 6) break;
                    double scaleX = Double.parseDouble(args[0].trim());
                    double rotateSkew0 = Double.parseDouble(args[1].trim());
                    double rotateSkew1 = Double.parseDouble(args[2].trim());
                    double scaleY = Double.parseDouble(args[3].trim());
                    double translateX = Double.parseDouble(args[4].trim());
                    double translateY = Double.parseDouble(args[5].trim());
                    Matrix result = new Matrix();
                    result.translateX = translateX;
                    result.translateY = translateY;
                    result.rotateSkew0 = rotateSkew0;
                    result.rotateSkew1 = rotateSkew1;
                    result.scaleX = scaleX;
                    result.scaleY = scaleY;
                    ret = ret.concatenate(result);
                    break;
                }
                case "translate": {
                    if (args.length != 1 && args.length != 2) break;
                    double translateX = Double.parseDouble(args[0].trim());
                    double translateY = 0.0;
                    if (args.length == 2) {
                        translateY = Double.parseDouble(args[1].trim());
                    }
                    Matrix result = new Matrix();
                    result.translateX = translateX;
                    result.translateY = translateY;
                    ret = ret.concatenate(result);
                    break;
                }
                case "scale": {
                    double scaleX;
                    if (args.length != 1 && args.length != 2) break;
                    double scaleY = scaleX = Double.parseDouble(args[0].trim());
                    if (args.length == 2) {
                        scaleY = Double.parseDouble(args[1].trim());
                    }
                    Matrix result = new Matrix();
                    result.scaleX = scaleX;
                    result.scaleY = scaleY;
                    ret = ret.concatenate(result);
                    break;
                }
                case "skewX": {
                    if (args.length != 1) break;
                    double angle = Double.parseDouble(args[0].trim()) * Math.PI / 180.0;
                    Matrix result = new Matrix();
                    result.rotateSkew1 = Math.tan(angle);
                    ret = ret.concatenate(result);
                    break;
                }
                case "skewY": {
                    if (args.length != 1) break;
                    double angle = Double.parseDouble(args[0].trim()) * Math.PI / 180.0;
                    Matrix result = new Matrix();
                    result.rotateSkew0 = Math.tan(angle);
                    ret = ret.concatenate(result);
                    break;
                }
                case "rotate": {
                    if (args.length != 1 && args.length != 3) break;
                    double rotateAngle = Double.parseDouble(args[0].trim());
                    double tx = 0.0;
                    double ty = 0.0;
                    if (args.length > 1) {
                        tx = Double.parseDouble(args[1].trim());
                        ty = Double.parseDouble(args[2].trim());
                    }
                    double angleRad = -rotateAngle * Math.PI / 180.0;
                    Matrix result = new Matrix();
                    result.rotateSkew0 = -Math.sin(angleRad);
                    result.rotateSkew1 = Math.sin(angleRad);
                    result.scaleX = Math.cos(angleRad);
                    result.scaleY = Math.cos(angleRad);
                    result = result.preConcatenate(Matrix.getTranslateInstance(tx, ty)).concatenate(Matrix.getTranslateInstance(-tx, -ty));
                    ret = ret.concatenate(result);
                }
            }
        }
        ret.translateX *= translateDivisor;
        ret.translateY *= translateDivisor;
        ret.rotateSkew0 *= unitDivisor;
        ret.rotateSkew1 *= unitDivisor;
        ret.scaleX *= unitDivisor;
        ret.scaleY *= unitDivisor;
        return ret;
    }

    private double roundPixels400(double pixels) {
        return (double)Math.round(pixels * 10000.0) / 10000.0;
    }

    public String toString() {
        return "[Matrix scale:" + this.scaleX + "," + this.scaleY + ", rotate:" + this.rotateSkew0 + "," + this.rotateSkew1 + ", translate:" + this.translateX + "," + this.translateY + "]";
    }

    public Matrix inverse() {
        double a = this.scaleX;
        double b = this.rotateSkew1;
        double tx = this.translateX;
        double c = this.rotateSkew0;
        double d = this.scaleY;
        double ty = this.translateY;
        double det = a * d - b * c;
        double a2 = d / det;
        double b2 = -b / det;
        double tx2 = (b * ty - tx * d) / det;
        double c2 = -c / det;
        double d2 = a / det;
        double ty2 = (tx * c - a * ty) / det;
        Matrix ret = new Matrix();
        ret.scaleX = a2;
        ret.rotateSkew0 = c2;
        ret.rotateSkew1 = b2;
        ret.scaleY = d2;
        ret.translateX = tx2;
        ret.translateY = ty2;
        return ret;
    }

    public double getTotalSkewAngleX() {
        Point px = this.deltaTransform(new Point(0.0, 1.0));
        return 57.29577951308232 * Math.atan2(px.y, px.x) - 90.0;
    }

    public double getTotalSkewAngleY() {
        Point py = this.deltaTransform(new Point(1.0, 0.0));
        return 57.29577951308232 * Math.atan2(py.y, py.x);
    }

    public double getTotalScaleX() {
        return Math.sqrt(this.scaleX * this.scaleX + this.rotateSkew0 * this.rotateSkew0);
    }

    public double getTotalScaleY() {
        return Math.sqrt(this.rotateSkew1 * this.rotateSkew1 + this.scaleY * this.scaleY);
    }

    private int fromFloat(double f) {
        return (int)(f * 65536.0);
    }

    public MATRIX toMATRIX() {
        MATRIX result = new MATRIX();
        result.translateX = (int)this.translateX;
        result.translateY = (int)this.translateY;
        result.hasRotate = true;
        result.hasScale = true;
        result.scaleX = (float)this.scaleX;
        result.scaleY = (float)this.scaleY;
        result.rotateSkew0 = (float)this.rotateSkew0;
        result.rotateSkew1 = (float)this.rotateSkew1;
        return result;
    }
}

