/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.morphshape;

import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.morphshape.CurvedMorphEdge;
import com.jpexs.decompiler.flash.exporters.morphshape.IMorphEdge;
import com.jpexs.decompiler.flash.exporters.morphshape.IMorphShapeExporter;
import com.jpexs.decompiler.flash.exporters.morphshape.StraightMorphEdge;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FOCALGRADIENT;
import com.jpexs.decompiler.flash.types.ILINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MorphShapeExporterBase
implements IMorphShapeExporter {
    protected final SHAPE shape;
    protected final SHAPE shapeEnd;
    protected List<FILLSTYLE> _fillStyles;
    protected List<ILINESTYLE> _lineStyles;
    protected List<FILLSTYLE> _fillStylesEnd;
    protected List<ILINESTYLE> _lineStylesEnd;
    protected List<Map<Integer, List<IMorphEdge>>> _fillEdgeMaps;
    protected List<Map<Integer, List<IMorphEdge>>> _lineEdgeMaps;
    private boolean edgeMapsCreated;
    protected ColorTransform colorTransform;
    protected int morphShapeNum;

    public MorphShapeExporterBase(int morphShapeNum, SHAPE shape, SHAPE endShape, ColorTransform colorTransform) {
        SHAPEWITHSTYLE shapeWithStyle;
        this.shape = shape;
        this.shapeEnd = endShape;
        this.colorTransform = colorTransform;
        this.morphShapeNum = morphShapeNum;
        this._fillStyles = new ArrayList<FILLSTYLE>();
        this._lineStyles = new ArrayList<ILINESTYLE>();
        if (shape instanceof SHAPEWITHSTYLE) {
            shapeWithStyle = (SHAPEWITHSTYLE)shape;
            this._fillStyles.addAll(Arrays.asList(shapeWithStyle.fillStyles.fillStyles));
            if (morphShapeNum == 2) {
                this._lineStyles.addAll(Arrays.asList(shapeWithStyle.lineStyles.lineStyles2));
            } else {
                this._lineStyles.addAll(Arrays.asList(shapeWithStyle.lineStyles.lineStyles));
            }
        }
        this._fillStylesEnd = new ArrayList<FILLSTYLE>();
        this._lineStylesEnd = new ArrayList<ILINESTYLE>();
        if (endShape instanceof SHAPEWITHSTYLE) {
            shapeWithStyle = (SHAPEWITHSTYLE)endShape;
            this._fillStylesEnd.addAll(Arrays.asList(shapeWithStyle.fillStyles.fillStyles));
            if (morphShapeNum == 2) {
                this._lineStylesEnd.addAll(Arrays.asList(shapeWithStyle.lineStyles.lineStyles2));
            } else {
                this._lineStylesEnd.addAll(Arrays.asList(shapeWithStyle.lineStyles.lineStyles));
            }
        }
    }

    public void export() {
        this._fillEdgeMaps = new ArrayList<Map<Integer, List<IMorphEdge>>>();
        this._lineEdgeMaps = new ArrayList<Map<Integer, List<IMorphEdge>>>();
        this.createEdgeMaps(this.morphShapeNum, this._fillStyles, this._lineStyles, this._fillStylesEnd, this._lineStylesEnd, this._fillEdgeMaps, this._lineEdgeMaps);
        this.beginShape();
        for (int i = 0; i < this._lineEdgeMaps.size(); ++i) {
            this.exportFillPath(i);
            this.exportLinePath(i);
        }
        this.endShape();
    }

    protected void createEdgeMaps(int morphShapeNum, List<FILLSTYLE> fillStyles, List<ILINESTYLE> lineStyles, List<FILLSTYLE> fillStylesEnd, List<ILINESTYLE> lineStylesEnd, List<Map<Integer, List<IMorphEdge>>> fillEdgeMaps, List<Map<Integer, List<IMorphEdge>>> lineEdgeMaps) {
        if (!this.edgeMapsCreated) {
            int xPos = 0;
            int yPos = 0;
            int xPosEnd = 0;
            int yPosEnd = 0;
            int fillStyleIdxOffset = 0;
            int lineStyleIdxOffset = 0;
            int currentFillStyleIdx0 = 0;
            int currentFillStyleIdx1 = 0;
            int currentLineStyleIdx = 0;
            ArrayList<IMorphEdge> subPath = new ArrayList<IMorphEdge>();
            HashMap<Integer, List<IMorphEdge>> currentFillEdgeMap = new HashMap<Integer, List<IMorphEdge>>();
            HashMap<Integer, List<IMorphEdge>> currentLineEdgeMap = new HashMap<Integer, List<IMorphEdge>>();
            List<SHAPERECORD> records = this.shape.shapeRecords;
            List<SHAPERECORD> recordsEnd = this.shapeEnd.shapeRecords;
            if (records.size() != recordsEnd.size()) {
                throw new Error("Begin and end shaperecord list length should be the same.");
            }
            for (int i = 0; i < records.size(); ++i) {
                int yPosFrom;
                SHAPERECORD shapeRecord = records.get(i);
                SHAPERECORD shapeRecordEnd = recordsEnd.get(i);
                if (shapeRecord instanceof StyleChangeRecord && !(shapeRecordEnd instanceof StyleChangeRecord) || shapeRecord instanceof StraightEdgeRecord && !(shapeRecordEnd instanceof StraightEdgeRecord) || shapeRecord instanceof CurvedEdgeRecord && !(shapeRecordEnd instanceof CurvedEdgeRecord) || shapeRecord instanceof EndShapeRecord && !(shapeRecordEnd instanceof EndShapeRecord)) {
                    throw new Error("Begin and end shaperecord should have the same type.");
                }
                if (shapeRecord instanceof StyleChangeRecord) {
                    StyleChangeRecord styleChangeRecord = (StyleChangeRecord)shapeRecord;
                    if (styleChangeRecord.stateLineStyle || styleChangeRecord.stateFillStyle0 || styleChangeRecord.stateFillStyle1) {
                        this.processSubPath(subPath, currentLineStyleIdx, currentFillStyleIdx0, currentFillStyleIdx1, currentFillEdgeMap, currentLineEdgeMap);
                        subPath = new ArrayList();
                    }
                    if (styleChangeRecord.stateNewStyles) {
                        fillStyleIdxOffset = fillStyles.size();
                        lineStyleIdxOffset = lineStyles.size();
                        this.appendFillStyles(fillStyles, styleChangeRecord.fillStyles.fillStyles);
                        if (morphShapeNum == 2) {
                            this.appendLineStyles(lineStyles, styleChangeRecord.lineStyles.lineStyles2);
                        } else {
                            this.appendLineStyles(lineStyles, styleChangeRecord.lineStyles.lineStyles);
                        }
                        this.appendFillStyles(fillStylesEnd, styleChangeRecord.fillStyles.fillStyles);
                        if (morphShapeNum == 2) {
                            this.appendLineStyles(lineStylesEnd, styleChangeRecord.lineStyles.lineStyles2);
                        } else {
                            this.appendLineStyles(lineStylesEnd, styleChangeRecord.lineStyles.lineStyles);
                        }
                    }
                    if (styleChangeRecord.stateLineStyle && styleChangeRecord.lineStyle == 0 && styleChangeRecord.stateFillStyle0 && styleChangeRecord.fillStyle0 == 0 && styleChangeRecord.stateFillStyle1 && styleChangeRecord.fillStyle1 == 0) {
                        fillEdgeMaps.add(currentFillEdgeMap);
                        lineEdgeMaps.add(currentLineEdgeMap);
                        currentFillEdgeMap = new HashMap();
                        currentLineEdgeMap = new HashMap();
                        currentLineStyleIdx = 0;
                        currentFillStyleIdx0 = 0;
                        currentFillStyleIdx1 = 0;
                    } else {
                        if (styleChangeRecord.stateLineStyle && (currentLineStyleIdx = styleChangeRecord.lineStyle) > 0) {
                            currentLineStyleIdx += lineStyleIdxOffset;
                        }
                        if (styleChangeRecord.stateFillStyle0 && (currentFillStyleIdx0 = styleChangeRecord.fillStyle0) > 0) {
                            currentFillStyleIdx0 += fillStyleIdxOffset;
                        }
                        if (styleChangeRecord.stateFillStyle1 && (currentFillStyleIdx1 = styleChangeRecord.fillStyle1) > 0) {
                            currentFillStyleIdx1 += fillStyleIdxOffset;
                        }
                    }
                    if (styleChangeRecord.stateMoveTo) {
                        xPos = styleChangeRecord.moveDeltaX;
                        yPos = styleChangeRecord.moveDeltaY;
                    }
                    StyleChangeRecord styleChangeRecordEnd = (StyleChangeRecord)shapeRecordEnd;
                    if (!styleChangeRecordEnd.stateMoveTo) continue;
                    xPosEnd = styleChangeRecordEnd.moveDeltaX;
                    yPosEnd = styleChangeRecordEnd.moveDeltaY;
                    continue;
                }
                if (shapeRecord instanceof StraightEdgeRecord) {
                    StraightEdgeRecord straightEdgeRecord = (StraightEdgeRecord)shapeRecord;
                    int xPosFrom = xPos;
                    yPosFrom = yPos;
                    if (straightEdgeRecord.generalLineFlag) {
                        xPos += straightEdgeRecord.deltaX;
                        yPos += straightEdgeRecord.deltaY;
                    } else if (straightEdgeRecord.vertLineFlag) {
                        yPos += straightEdgeRecord.deltaY;
                    } else {
                        xPos += straightEdgeRecord.deltaX;
                    }
                    StraightEdgeRecord straightEdgeRecordEnd = (StraightEdgeRecord)shapeRecordEnd;
                    int xPosEndFrom = xPosEnd;
                    int yPosEndFrom = yPosEnd;
                    if (straightEdgeRecordEnd.generalLineFlag) {
                        xPosEnd += straightEdgeRecordEnd.deltaX;
                        yPosEnd += straightEdgeRecordEnd.deltaY;
                    } else if (straightEdgeRecordEnd.vertLineFlag) {
                        yPosEnd += straightEdgeRecordEnd.deltaY;
                    } else {
                        xPosEnd += straightEdgeRecordEnd.deltaX;
                    }
                    subPath.add(new StraightMorphEdge(xPosFrom, yPosFrom, xPos, yPos, xPosEndFrom, yPosEndFrom, xPosEnd, yPosEnd, currentLineStyleIdx, currentFillStyleIdx1));
                    continue;
                }
                if (shapeRecord instanceof CurvedEdgeRecord) {
                    CurvedEdgeRecord curvedEdgeRecord = (CurvedEdgeRecord)shapeRecord;
                    int xPosFrom = xPos;
                    yPosFrom = yPos;
                    int xPosControl = xPos + curvedEdgeRecord.controlDeltaX;
                    int yPosControl = yPos + curvedEdgeRecord.controlDeltaY;
                    xPos = xPosControl + curvedEdgeRecord.anchorDeltaX;
                    yPos = yPosControl + curvedEdgeRecord.anchorDeltaY;
                    CurvedEdgeRecord curvedEdgeRecordEnd = (CurvedEdgeRecord)shapeRecordEnd;
                    int xPosEndFrom = xPosEnd;
                    int yPosEndFrom = yPosEnd;
                    int xPosEndControl = xPosEnd + curvedEdgeRecordEnd.controlDeltaX;
                    int yPosEndControl = yPosEnd + curvedEdgeRecordEnd.controlDeltaY;
                    xPosEnd = xPosEndControl + curvedEdgeRecordEnd.anchorDeltaX;
                    yPosEnd = yPosEndControl + curvedEdgeRecordEnd.anchorDeltaY;
                    subPath.add(new CurvedMorphEdge(xPosFrom, yPosFrom, xPosControl, yPosControl, xPos, yPos, xPosEndFrom, yPosEndFrom, xPosEndControl, yPosEndControl, xPosEnd, yPosEnd, currentLineStyleIdx, currentFillStyleIdx1));
                    continue;
                }
                if (!(shapeRecord instanceof EndShapeRecord)) continue;
                this.processSubPath(subPath, currentLineStyleIdx, currentFillStyleIdx0, currentFillStyleIdx1, currentFillEdgeMap, currentLineEdgeMap);
                fillEdgeMaps.add(currentFillEdgeMap);
                lineEdgeMaps.add(currentLineEdgeMap);
            }
            this.edgeMapsCreated = true;
        }
    }

    protected void processSubPath(List<IMorphEdge> subPath, int lineStyleIdx, int fillStyleIdx0, int fillStyleIdx1, Map<Integer, List<IMorphEdge>> currentFillEdgeMap, Map<Integer, List<IMorphEdge>> currentLineEdgeMap) {
        List<IMorphEdge> path;
        if (fillStyleIdx0 != 0) {
            path = currentFillEdgeMap.get(fillStyleIdx0);
            if (path == null) {
                path = new ArrayList<IMorphEdge>();
                currentFillEdgeMap.put(fillStyleIdx0, path);
            }
            for (int j = subPath.size() - 1; j >= 0; --j) {
                path.add(subPath.get(j).reverseWithNewFillStyle(fillStyleIdx0));
            }
        }
        if (fillStyleIdx1 != 0) {
            path = currentFillEdgeMap.get(fillStyleIdx1);
            if (path == null) {
                path = new ArrayList<IMorphEdge>();
                currentFillEdgeMap.put(fillStyleIdx1, path);
            }
            this.appendEdges(path, subPath);
        }
        if (lineStyleIdx != 0) {
            path = currentLineEdgeMap.get(lineStyleIdx);
            if (path == null) {
                path = new ArrayList<IMorphEdge>();
                currentLineEdgeMap.put(lineStyleIdx, path);
            }
            this.appendEdges(path, subPath);
        }
    }

    protected void exportFillPath(int groupIndex) {
        List<IMorphEdge> path = this.createPathFromEdgeMap(this._fillEdgeMaps.get(groupIndex));
        int posX = Integer.MAX_VALUE;
        int posY = Integer.MAX_VALUE;
        int fillStyleIdx = Integer.MAX_VALUE;
        if (path.size() > 0) {
            this.beginFills();
            for (int i = 0; i < path.size(); ++i) {
                IMorphEdge e = path.get(i);
                if (fillStyleIdx != e.getFillStyleIdx()) {
                    if (fillStyleIdx != Integer.MAX_VALUE) {
                        this.endFill();
                    }
                    fillStyleIdx = e.getFillStyleIdx();
                    posX = Integer.MAX_VALUE;
                    posY = Integer.MAX_VALUE;
                    if (fillStyleIdx - 1 < this._fillStyles.size()) {
                        FILLSTYLE fillStyle = this._fillStyles.get(fillStyleIdx - 1);
                        FILLSTYLE fillStyleEnd = this._fillStylesEnd.get(fillStyleIdx - 1);
                        switch (fillStyle.fillStyleType) {
                            case 0: {
                                if (this.colorTransform == null) {
                                    this.beginFill(fillStyle.color, fillStyleEnd.color);
                                    break;
                                }
                                this.beginFill(this.colorTransform.apply(fillStyle.color), this.colorTransform.apply(fillStyleEnd.color));
                                break;
                            }
                            case 16: 
                            case 18: 
                            case 19: {
                                Matrix matrix = new Matrix(fillStyle.gradientMatrix);
                                Matrix matrixEnd = new Matrix(fillStyleEnd.gradientMatrix);
                                this.beginGradientFill(fillStyle.fillStyleType, this.colorTransform == null ? fillStyle.gradient.gradientRecords : this.colorTransform.apply(fillStyle.gradient.gradientRecords), this.colorTransform == null ? fillStyleEnd.gradient.gradientRecords : this.colorTransform.apply(fillStyleEnd.gradient.gradientRecords), matrix, matrixEnd, fillStyle.gradient.spreadMode, fillStyle.gradient.interpolationMode, fillStyle.gradient instanceof FOCALGRADIENT ? ((FOCALGRADIENT)fillStyle.gradient).focalPoint : 0.0f, fillStyleEnd.gradient instanceof FOCALGRADIENT ? ((FOCALGRADIENT)fillStyleEnd.gradient).focalPoint : 0.0f);
                                break;
                            }
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: {
                                Matrix matrix = new Matrix(fillStyle.bitmapMatrix);
                                Matrix matrixEnd = new Matrix(fillStyleEnd.bitmapMatrix);
                                this.beginBitmapFill(fillStyle.bitmapId, matrix, matrixEnd, fillStyle.fillStyleType == 64 || fillStyle.fillStyleType == 66, fillStyle.fillStyleType == 64 || fillStyle.fillStyleType == 65, this.colorTransform);
                            }
                        }
                    } else {
                        this.beginFill(null, null);
                    }
                }
                if (posX != e.getFromX() || posY != e.getFromY()) {
                    this.moveTo(e.getFromX(), e.getFromY(), e.getFromEndX(), e.getFromEndY());
                }
                if (e instanceof CurvedMorphEdge) {
                    CurvedMorphEdge c = (CurvedMorphEdge)e;
                    this.curveTo(c.getControlX(), c.getControlY(), c.toX, c.toY, c.getControlEndX(), c.getControlEndY(), c.toEndX, c.toEndY);
                } else {
                    this.lineTo(e.getToX(), e.getToY(), e.getToEndX(), e.getToEndY());
                }
                posX = e.getToX();
                posY = e.getToY();
            }
            if (fillStyleIdx != Integer.MAX_VALUE) {
                this.endFill();
            }
            this.endFills();
        }
    }

    protected void exportLinePath(int groupIndex) {
        List<IMorphEdge> path = this.createPathFromEdgeMap(this._lineEdgeMaps.get(groupIndex));
        int posX = Integer.MAX_VALUE;
        int posY = Integer.MAX_VALUE;
        int lastMoveToX = posX;
        int lastMoveToY = posY;
        int lineStyleIdx = Integer.MAX_VALUE;
        boolean autoClose = true;
        if (path.size() > 0) {
            this.beginLines();
            for (int i = 0; i < path.size(); ++i) {
                IMorphEdge e = path.get(i);
                if (lineStyleIdx != e.getLineStyleIdx()) {
                    lineStyleIdx = e.getLineStyleIdx();
                    posX = Integer.MAX_VALUE;
                    posY = Integer.MAX_VALUE;
                    ILINESTYLE lineStyle = null;
                    ILINESTYLE lineStyleEnd = null;
                    try {
                        lineStyle = this._lineStyles.get(lineStyleIdx - 1);
                        lineStyleEnd = this._lineStylesEnd.get(lineStyleIdx - 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (lineStyle != null) {
                        LINESTYLE2 lineStyle2;
                        String scaleMode = "NORMAL";
                        boolean pixelHintingFlag = false;
                        int startCapStyle = 0;
                        int endCapStyle = 0;
                        int joinStyle = 0;
                        float miterLimitFactor = 3.0f;
                        boolean hasFillFlag = false;
                        autoClose = true;
                        if (lineStyle instanceof LINESTYLE2) {
                            lineStyle2 = (LINESTYLE2)lineStyle;
                            if (lineStyle2.noClose) {
                                autoClose = false;
                            }
                            if (lineStyle2.noHScaleFlag && lineStyle2.noVScaleFlag) {
                                scaleMode = "NONE";
                            } else if (lineStyle2.noHScaleFlag) {
                                scaleMode = "VERTICAL";
                            } else if (lineStyle2.noVScaleFlag) {
                                scaleMode = "HORIZONTAL";
                            }
                            pixelHintingFlag = lineStyle2.pixelHintingFlag;
                            startCapStyle = lineStyle2.startCapStyle;
                            endCapStyle = lineStyle2.endCapStyle;
                            joinStyle = lineStyle2.joinStyle;
                            miterLimitFactor = lineStyle2.miterLimitFactor;
                            hasFillFlag = lineStyle2.hasFillFlag;
                        }
                        this.lineStyle(lineStyle.getWidth(), lineStyleEnd.getWidth(), this.colorTransform == null ? lineStyle.getColor() : this.colorTransform.apply(lineStyle.getColor()), this.colorTransform == null ? lineStyleEnd.getColor() : this.colorTransform.apply(lineStyleEnd.getColor()), pixelHintingFlag, scaleMode, startCapStyle, endCapStyle, joinStyle, miterLimitFactor, !autoClose);
                        if (hasFillFlag) {
                            lineStyle2 = (LINESTYLE2)lineStyle;
                            FILLSTYLE fillStyle = lineStyle2.fillType;
                            LINESTYLE2 lineStyle2End = (LINESTYLE2)lineStyleEnd;
                            FILLSTYLE fillStyleEnd = lineStyle2End.fillType;
                            switch (fillStyle.fillStyleType) {
                                case 16: 
                                case 18: 
                                case 19: {
                                    Matrix matrix = new Matrix(fillStyle.gradientMatrix);
                                    Matrix matrixEnd = new Matrix(fillStyleEnd.gradientMatrix);
                                    this.lineGradientStyle(fillStyle.fillStyleType, fillStyle.gradient.gradientRecords, fillStyleEnd.gradient.gradientRecords, matrix, matrixEnd, fillStyle.gradient.spreadMode, fillStyle.gradient.interpolationMode, fillStyle.gradient instanceof FOCALGRADIENT ? ((FOCALGRADIENT)fillStyle.gradient).focalPoint : 0.0f, fillStyleEnd.gradient instanceof FOCALGRADIENT ? ((FOCALGRADIENT)fillStyleEnd.gradient).focalPoint : 0.0f);
                                    break;
                                }
                                case 64: 
                                case 65: 
                                case 66: 
                                case 67: {
                                    Matrix bmatrix = new Matrix(fillStyle.bitmapMatrix);
                                    Matrix bmatrixEnd = new Matrix(fillStyleEnd.bitmapMatrix);
                                    this.lineBitmapStyle(fillStyle.bitmapId, bmatrix, bmatrixEnd, fillStyle.fillStyleType == 64 || fillStyle.fillStyleType == 66, fillStyle.fillStyleType == 64 || fillStyle.fillStyleType == 65, this.colorTransform);
                                }
                            }
                        }
                    } else {
                        this.lineStyle(1.0, 1.0, new RGB(Color.black), new RGB(Color.BLACK), false, "NORMAL", 0, 0, 0, 3.0f, false);
                    }
                }
                if (posX != e.getFromX() || posY != e.getFromY()) {
                    this.moveTo(e.getFromX(), e.getFromY(), e.getFromEndX(), e.getFromEndY());
                    lastMoveToX = e.getFromX();
                    lastMoveToY = e.getFromY();
                }
                if (e instanceof CurvedMorphEdge) {
                    CurvedMorphEdge c = (CurvedMorphEdge)e;
                    this.curveTo(c.getControlX(), c.getControlY(), c.toX, c.toY, c.getControlEndX(), c.getControlEndY(), c.toEndX, c.toEndY);
                } else {
                    this.lineTo(e.getToX(), e.getToY(), e.getToEndX(), e.getToEndY());
                }
                posX = e.getToX();
                posY = e.getToY();
            }
            this.endLines(autoClose && lastMoveToX == posX && lastMoveToY == posY);
        }
    }

    protected List<IMorphEdge> createPathFromEdgeMap(Map<Integer, List<IMorphEdge>> edgeMap) {
        ArrayList<IMorphEdge> newPath = new ArrayList<IMorphEdge>();
        ArrayList<Integer> styleIdxArray = new ArrayList<Integer>();
        for (Integer styleIdx : edgeMap.keySet()) {
            styleIdxArray.add(styleIdx);
        }
        Collections.sort(styleIdxArray);
        for (int i = 0; i < styleIdxArray.size(); ++i) {
            this.appendEdges(newPath, edgeMap.get(styleIdxArray.get(i)));
        }
        return newPath;
    }

    protected void cleanEdgeMap(Map<Integer, List<IMorphEdge>> edgeMap) {
        for (Integer styleIdx : edgeMap.keySet()) {
            List<IMorphEdge> subPath = edgeMap.get(styleIdx);
            if (subPath == null || subPath.size() <= 0) continue;
            IMorphEdge prevEdge = null;
            ArrayList<IMorphEdge> tmpPath = new ArrayList<IMorphEdge>();
            Map<Long, List<IMorphEdge>> coordMap = this.createCoordMap(subPath);
            while (subPath.size() > 0) {
                int idx = 0;
                while (idx < subPath.size()) {
                    if (prevEdge != null) {
                        IMorphEdge subPathEdge = subPath.get(idx);
                        if (prevEdge.getToX() != subPathEdge.getFromX() || prevEdge.getToY() != subPathEdge.getFromY()) {
                            IMorphEdge edge = this.findNextEdgeInCoordMap(coordMap, prevEdge);
                            if (edge != null) {
                                idx = subPath.indexOf(edge);
                                continue;
                            }
                            idx = 0;
                            prevEdge = null;
                            continue;
                        }
                    }
                    IMorphEdge edge = subPath.remove(idx);
                    tmpPath.add(edge);
                    this.removeEdgeFromCoordMap(coordMap, edge);
                    prevEdge = edge;
                }
            }
            edgeMap.put(styleIdx, tmpPath);
        }
    }

    protected Map<Long, List<IMorphEdge>> createCoordMap(List<IMorphEdge> path) {
        HashMap<Long, List<IMorphEdge>> coordMap = new HashMap<Long, List<IMorphEdge>>();
        for (int i = 0; i < path.size(); ++i) {
            IMorphEdge edge = path.get(i);
            long fromLong = (long)edge.getFromX() << 32 | (long)edge.getFromY() & 0xFFFFFFFFL;
            List coordMapArray = (List)coordMap.get(fromLong);
            if (coordMapArray == null) {
                ArrayList<IMorphEdge> list = new ArrayList<IMorphEdge>();
                list.add(path.get(i));
                coordMap.put(fromLong, list);
                continue;
            }
            coordMapArray.add(path.get(i));
        }
        return coordMap;
    }

    protected void removeEdgeFromCoordMap(Map<Long, List<IMorphEdge>> coordMap, IMorphEdge edge) {
        long fromLong = (long)edge.getFromX() << 32 | (long)edge.getFromY() & 0xFFFFFFFFL;
        List<IMorphEdge> coordMapArray = coordMap.get(fromLong);
        if (coordMapArray != null) {
            if (coordMapArray.size() == 1) {
                coordMap.remove(fromLong);
            } else {
                int i = coordMapArray.indexOf(edge);
                if (i > -1) {
                    coordMapArray.remove(i);
                }
            }
        }
    }

    protected IMorphEdge findNextEdgeInCoordMap(Map<Long, List<IMorphEdge>> coordMap, IMorphEdge edge) {
        long toLong = (long)edge.getToX() << 32 | (long)edge.getToY() & 0xFFFFFFFFL;
        List<IMorphEdge> coordMapArray = coordMap.get(toLong);
        if (coordMapArray != null && coordMapArray.size() > 0) {
            return coordMapArray.get(0);
        }
        return null;
    }

    protected void appendFillStyles(List<FILLSTYLE> v1, FILLSTYLE[] v2) {
        v1.addAll(Arrays.asList(v2));
    }

    protected void appendLineStyles(List<ILINESTYLE> v1, LINESTYLE[] v2) {
        v1.addAll(Arrays.asList(v2));
    }

    protected void appendLineStyles(List<ILINESTYLE> v1, LINESTYLE2[] v2) {
        v1.addAll(Arrays.asList(v2));
    }

    protected void appendEdges(List<IMorphEdge> v1, List<IMorphEdge> v2) {
        for (int i = 0; i < v2.size(); ++i) {
            v1.add(v2.get(i));
        }
    }
}

