/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.settings;

import com.jpexs.decompiler.flash.exporters.modes.MorphShapeExportMode;

public class MorphShapeExportSettings {
    public static final String EXPORT_FOLDER_NAME = "morphshapes";
    public MorphShapeExportMode mode;
    public double zoom;
    public int aaScale;
    public Double duration;
    public Integer numberOfFrames;

    public MorphShapeExportSettings(MorphShapeExportMode mode, double zoom, int aaScale, Double duration, Integer numberOfFrames) {
        if (mode.hasFrames() && numberOfFrames == null) {
            throw new IllegalArgumentException("The requested mode requires passing number of frames.");
        }
        if (mode.hasDuration() && duration == null) {
            throw new IllegalArgumentException("The requested mode requires passing duration.");
        }
        this.mode = mode;
        this.zoom = zoom;
        this.aaScale = aaScale;
        this.duration = duration;
        this.numberOfFrames = numberOfFrames;
    }

    public MorphShapeExportSettings(MorphShapeExportMode mode, double zoom, int aaScale) {
        this(mode, zoom, aaScale, null, null);
    }

    public String getFileExtension() {
        switch (this.mode) {
            case PNG_START_END: 
            case PNG_FRAMES: 
            case APNG: {
                return ".png";
            }
            case BMP_START_END: 
            case BMP_FRAMES: {
                return ".bmp";
            }
            case WEBP_START_END: 
            case WEBP_FRAMES: 
            case WEBP: {
                return ".webp";
            }
            case SVG: 
            case SVG_START_END: 
            case SVG_FRAMES: {
                return ".svg";
            }
            case CANVAS: {
                return ".html";
            }
            case SWF: {
                return ".swf";
            }
            case GIF: {
                return ".gif";
            }
            case AVI: {
                return ".avi";
            }
        }
        throw new Error("Unsupported morphshape export mode: " + (Object)((Object)this.mode));
    }
}

