/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.settings;

import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.FileTextWriter;

public class ScriptExportSettings
implements Cloneable {
    public static final String EXPORT_FOLDER_NAME = "scripts";
    public ScriptExportMode mode;
    public boolean singleFile;
    public FileTextWriter singleFileWriter;
    public boolean ignoreFrameScripts;
    public boolean ignoreAccessibility;
    public boolean exportEmbed;
    public boolean exportEmbedFlaMode;
    public boolean resampleWav;
    public String assetsDir;
    public boolean includeAllClasses = true;

    public ScriptExportSettings(ScriptExportMode mode, boolean singleFile, boolean ignoreFrameScripts, boolean exportEmbed, boolean exportEmbedFlaMode) {
        this(mode, singleFile, ignoreFrameScripts, exportEmbed, exportEmbedFlaMode, "/_assets/", false, false);
    }

    public ScriptExportSettings(ScriptExportMode mode, boolean singleFile, boolean ignoreFrameScripts, boolean exportEmbed, boolean exportEmbedFlaMode, String assetsDir, boolean includeAllClasses, boolean ignoreAccessibility) {
        this.mode = mode;
        this.singleFile = singleFile;
        this.ignoreFrameScripts = ignoreFrameScripts;
        this.exportEmbed = exportEmbed;
        this.exportEmbedFlaMode = exportEmbedFlaMode;
        this.assetsDir = assetsDir;
        this.includeAllClasses = includeAllClasses;
        this.ignoreAccessibility = ignoreAccessibility;
    }

    public String getFileExtension() {
        switch (this.mode) {
            case AS: 
            case AS_METHOD_STUBS: {
                return ".as";
            }
            case PCODE_GRAPHVIZ: {
                return ".gv";
            }
            case PCODE: 
            case PCODE_HEX: {
                return ".pcode";
            }
            case HEX: {
                return ".hex";
            }
            case CONSTANTS: {
                return ".txt";
            }
        }
        throw new Error("Unsupported script export mode: " + (Object)((Object)this.mode));
    }

    public ScriptExportSettings clone() {
        try {
            return (ScriptExportSettings)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

