/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.harman;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class HarmanBinaryDataEncrypt {
    private static final String GLOBAL_KEY = "Adobe AIR SDK (c) 2021 HARMAN Internation Industries Incorporated";

    private HarmanBinaryDataEncrypt() {
    }

    public static byte[] encrypt(byte[] data, String key) {
        byte[] result;
        byte[] customKey = null;
        if (key != null) {
            customKey = new byte[16];
            int keyLen = key.length();
            for (int i = 0; i < 16; ++i) {
                customKey[i] = (byte)key.charAt(i % keyLen);
            }
        }
        try {
            SecureRandom random = new SecureRandom();
            int dataLen = data.length;
            int encryptedDataLen = dataLen + 31 & 0xFFFFFFE0;
            int resultLen = 32 + encryptedDataLen;
            byte[] hashBytes = new byte[4];
            byte[] randomBytes1 = new byte[4];
            byte[] randomBytes2 = new byte[4];
            byte[] keyBytes = new byte[16];
            random.nextBytes(hashBytes);
            random.nextBytes(randomBytes1);
            random.nextBytes(randomBytes2);
            random.nextBytes(keyBytes);
            long random1 = HarmanBinaryDataEncrypt.unpack(randomBytes1, 0);
            long random2 = HarmanBinaryDataEncrypt.unpack(randomBytes2, 0);
            byte[] ivBytes = HarmanBinaryDataEncrypt.getIv(hashBytes, random1, random2);
            IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
            SecretKeySpec keySpec = new SecretKeySpec(customKey != null ? customKey : keyBytes, "AES");
            byte[] dataPadded = new byte[encryptedDataLen];
            random.nextBytes(dataPadded);
            System.arraycopy(data, 0, dataPadded, 0, data.length);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)keySpec, ivSpec);
            byte[] encryptedBytes = cipher.doFinal(dataPadded);
            result = new byte[resultLen];
            long hash = HarmanBinaryDataEncrypt.unpack(hashBytes, 0);
            long resultLenXorHash = (long)resultLen ^ hash;
            System.arraycopy(HarmanBinaryDataEncrypt.pack(resultLenXorHash), 0, result, 0, 4);
            long dataLenXorRandom1 = (long)dataLen ^ random1;
            System.arraycopy(HarmanBinaryDataEncrypt.pack(dataLenXorRandom1), 0, result, 4, 4);
            System.arraycopy(randomBytes1, 0, result, 8, 4);
            System.arraycopy(randomBytes2, 0, result, 12, 4);
            HarmanBinaryDataEncrypt.addBytes(keyBytes, 0, randomBytes2, 1);
            HarmanBinaryDataEncrypt.addBytes(keyBytes, 4, randomBytes2, -1);
            HarmanBinaryDataEncrypt.addBytes(keyBytes, 8, randomBytes2, 1);
            HarmanBinaryDataEncrypt.addBytes(keyBytes, 12, randomBytes2, -1);
            System.arraycopy(keyBytes, 0, result, 16, 16);
            System.arraycopy(encryptedBytes, 0, result, 32, encryptedDataLen);
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            result = null;
        }
        return result;
    }

    private static long unpack(byte[] data, int start) {
        return (long)(data[start] & 0xFF) + ((long)(data[start + 1] & 0xFF) << 8) + ((long)(data[start + 2] & 0xFF) << 16) + ((long)(data[start + 3] & 0xFF) << 24);
    }

    private static void addBytes(byte[] toChangeBytes, int offset, byte[] data, int multiplier) {
        for (int i = 0; i < 4; ++i) {
            toChangeBytes[offset + i] = (byte)(toChangeBytes[offset + i] + multiplier * data[i]);
        }
    }

    private static byte[] getIv(byte[] hashBytes, long random1, long random2) throws UnsupportedEncodingException {
        int offset2;
        byte[] ivBytes = new byte[16];
        int offset = 0;
        for (offset2 = 0; offset2 < 4; ++offset2) {
            offset += hashBytes[offset2] & 0xFF;
        }
        offset2 = offset % GLOBAL_KEY.length();
        String hashString = GLOBAL_KEY.substring(offset2) + GLOBAL_KEY.substring(0, offset2) + " EncryptSWF " + offset;
        byte[] hashStringBytes = hashString.getBytes("UTF-8");
        long hashCodeString = 0L;
        for (int i = 0; i < hashStringBytes.length; ++i) {
            hashCodeString = 31L * hashCodeString + (long)(hashStringBytes[i] & 0xFF);
        }
        System.arraycopy(HarmanBinaryDataEncrypt.pack(hashCodeString), 0, ivBytes, 0, 4);
        System.arraycopy(hashBytes, 0, ivBytes, 4, 4);
        long hashSum = HarmanBinaryDataEncrypt.unpack(hashBytes, 0) + hashCodeString;
        long sumXorRandom1 = random1 ^ hashSum;
        long sumXorRandom2 = random2 ^ hashSum;
        System.arraycopy(HarmanBinaryDataEncrypt.pack(sumXorRandom1), 0, ivBytes, 8, 4);
        System.arraycopy(HarmanBinaryDataEncrypt.pack(sumXorRandom2), 0, ivBytes, 12, 4);
        return ivBytes;
    }

    private static byte[] pack(long value) {
        byte[] ret = new byte[]{(byte)(value & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL)};
        return ret;
    }

    public static byte[] decrypt(byte[] data, String key) {
        if (data.length < 32) {
            return null;
        }
        byte[] customKey = null;
        if (key != null) {
            customKey = new byte[16];
            int keyLen = key.length();
            for (int i = 0; i < 16; ++i) {
                customKey[i] = (byte)key.charAt(i % keyLen);
            }
        }
        long encryptedLen = data.length;
        long encryptedLenXorHash = HarmanBinaryDataEncrypt.unpack(data, 0);
        long decryptedLenXorRandom1 = HarmanBinaryDataEncrypt.unpack(data, 4);
        long random1 = HarmanBinaryDataEncrypt.unpack(data, 8);
        long random2 = HarmanBinaryDataEncrypt.unpack(data, 12);
        byte[] random2Bytes = Arrays.copyOfRange(data, 12, 16);
        byte[] keyBytes = Arrays.copyOfRange(data, 16, 32);
        byte[] encryptedBytes = Arrays.copyOfRange(data, 32, data.length);
        long decryptedLen = decryptedLenXorRandom1 ^ random1;
        long hash = encryptedLen ^ encryptedLenXorHash;
        byte[] hashBytes = HarmanBinaryDataEncrypt.pack(hash);
        HarmanBinaryDataEncrypt.addBytes(keyBytes, 0, random2Bytes, -1);
        HarmanBinaryDataEncrypt.addBytes(keyBytes, 4, random2Bytes, 1);
        HarmanBinaryDataEncrypt.addBytes(keyBytes, 8, random2Bytes, -1);
        HarmanBinaryDataEncrypt.addBytes(keyBytes, 12, random2Bytes, 1);
        try {
            byte[] ivBytes = HarmanBinaryDataEncrypt.getIv(hashBytes, random1, random2);
            IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
            SecretKeySpec keySpec = new SecretKeySpec(customKey != null ? customKey : keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)keySpec, ivSpec);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            byte[] ret = new byte[(int)decryptedLen];
            System.arraycopy(decryptedBytes, 0, ret, 0, (int)decryptedLen);
            return ret;
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        byte[] data = new byte[]{65, 66, 67};
        byte[] encrypted = HarmanBinaryDataEncrypt.encrypt(data, null);
        byte[] decrypted = HarmanBinaryDataEncrypt.decrypt(encrypted, null);
        if (!Arrays.equals(data, decrypted)) {
            throw new RuntimeException("Cannot encrypt/decrypt");
        }
    }
}

