/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.helpers;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BMPFile
extends Component {
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private final byte[] bitmapFileHeader = new byte[14];
    private final byte[] bfType = new byte[]{66, 77};
    private int bfSize = 0;
    private final int bfReserved1 = 0;
    private final int bfReserved2 = 0;
    private final int bfOffBits = 54;
    private final byte[] bitmapInfoHeader = new byte[40];
    private final int biSize = 40;
    private int biWidth = 0;
    private int biHeight = 0;
    private final int biPlanes = 1;
    private final int biBitCount = 24;
    private final int biCompression = 0;
    private int biSizeImage = 196608;
    private final int biXPelsPerMeter = 0;
    private final int biYPelsPerMeter = 0;
    private final int biClrUsed = 0;
    private final int biClrImportant = 0;
    private int[] bitmap;
    private OutputStream fo;

    private BMPFile() {
    }

    public static void saveBitmap(Image image, File file) throws IOException {
        BMPFile b = new BMPFile();
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
            b.fo = fos;
            b.save(image, image.getWidth(null), image.getHeight(null));
        }
    }

    private void save(Image parImage, int parWidth, int parHeight) throws IOException {
        this.convertImage(parImage, parWidth, parHeight);
        this.writeBitmapFileHeader();
        this.writeBitmapInfoHeader();
        this.writeBitmap();
    }

    private boolean convertImage(Image parImage, int parWidth, int parHeight) {
        this.bitmap = new int[parWidth * parHeight];
        PixelGrabber pg = new PixelGrabber(parImage, 0, 0, parWidth, parHeight, this.bitmap, 0, parWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            return false;
        }
        int pad = (4 - parWidth * 3 % 4) % 4 * parHeight;
        this.biSizeImage = parWidth * parHeight * 3 + pad;
        this.bfSize = this.biSizeImage + 14 + 40;
        this.biWidth = parWidth;
        this.biHeight = parHeight;
        return true;
    }

    private void writeBitmap() throws IOException {
        byte[] rgb = new byte[3];
        int width = this.biWidth;
        int height = this.biHeight;
        int pad = (4 - width * 3 % 4) % 4;
        int padCount = 0;
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                int value = this.bitmap[y * width + x];
                rgb[0] = (byte)(value & 0xFF);
                rgb[1] = (byte)(value >> 8 & 0xFF);
                rgb[2] = (byte)(value >> 16 & 0xFF);
                this.fo.write(rgb);
            }
            padCount += pad;
            for (int i = 0; i < pad; ++i) {
                this.fo.write(0);
            }
        }
        this.bfSize += padCount;
        this.biSizeImage += padCount;
    }

    private void writeBitmapFileHeader() throws IOException {
        this.fo.write(this.bfType);
        this.fo.write(this.intToDWord(this.bfSize));
        this.fo.write(this.intToWord(0));
        this.fo.write(this.intToWord(0));
        this.fo.write(this.intToDWord(54));
    }

    private void writeBitmapInfoHeader() throws IOException {
        this.fo.write(this.intToDWord(40));
        this.fo.write(this.intToDWord(this.biWidth));
        this.fo.write(this.intToDWord(this.biHeight));
        this.fo.write(this.intToWord(1));
        this.fo.write(this.intToWord(24));
        this.fo.write(this.intToDWord(0));
        this.fo.write(this.intToDWord(this.biSizeImage));
        this.fo.write(this.intToDWord(0));
        this.fo.write(this.intToDWord(0));
        this.fo.write(this.intToDWord(0));
        this.fo.write(this.intToDWord(0));
    }

    private byte[] intToWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF)};
        return retValue;
    }

    private byte[] intToDWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF), (byte)(parValue >> 16 & 0xFF), (byte)(parValue >> 24 & 0xFF)};
        return retValue;
    }
}

