/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.helpers;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.helpers.Helper;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.jpeg.CMYKJPEGImageReader;
import org.monte.media.jpeg.CMYKJPEGImageReaderSpi;

public class ImageHelper {
    public static BufferedImage read(byte[] data) throws IOException {
        return ImageHelper.read(new ByteArrayInputStream(data));
    }

    public static BufferedImage read(InputStream input) throws IOException {
        BufferedImage in;
        byte[] data = Helper.readStream(input);
        try (ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(data));){
            CMYKJPEGImageReader r = new CMYKJPEGImageReader((ImageReaderSpi)new CMYKJPEGImageReaderSpi());
            r.setInput((Object)iis);
            in = r.read(0);
        }
        catch (IOException | ArrayIndexOutOfBoundsException ex) {
            try {
                in = ImageIO.read(ImageIO.createImageInputStream(new ByteArrayInputStream(data)));
            }
            catch (IOException ex1) {
                return null;
            }
        }
        if (in == null) {
            BufferedImage img = new BufferedImage(1, 1, 3);
            Graphics g = img.getGraphics();
            g.setColor(SWF.ERROR_COLOR);
            g.fillRect(0, 0, 1, 1);
            return img;
        }
        int type = in.getType();
        if (type != 3 && type != 1) {
            int width = in.getWidth();
            int height = in.getHeight();
            int[] imgData = in.getRGB(0, 0, width, height, null, 0, width);
            BufferedImage newImage = new BufferedImage(width, height, 3);
            newImage.getRaster().setDataElements(0, 0, width, height, imgData);
            return newImage;
        }
        return in;
    }

    public static void write(BufferedImage image, ImageFormat format, File output) throws IOException {
        String formatName = ImageHelper.getImageFormatString(format).toUpperCase(Locale.ENGLISH);
        if (format == ImageFormat.JPEG) {
            image = ImageHelper.fixImageIOJpegBug(image);
        }
        ImageIO.write((RenderedImage)image, formatName, output);
    }

    public static void write(BufferedImage image, ImageFormat format, OutputStream output) throws IOException {
        String formatName = ImageHelper.getImageFormatString(format).toUpperCase(Locale.ENGLISH);
        if (format == ImageFormat.JPEG) {
            image = ImageHelper.fixImageIOJpegBug(image);
        }
        ImageIO.write((RenderedImage)image, formatName, output);
    }

    public static void write(BufferedImage image, ImageFormat format, ByteArrayOutputStream output) {
        String formatName = ImageHelper.getImageFormatString(format).toUpperCase(Locale.ENGLISH);
        if (format == ImageFormat.JPEG) {
            image = ImageHelper.fixImageIOJpegBug(image);
        } else if (image.getType() == 3) {
            BufferedImage image2 = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            ImageHelper.divideAlpha(pixels);
            int[] pixels2 = ((DataBufferInt)image2.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < pixels.length; ++i) {
                pixels2[i] = pixels[i];
            }
            image = image2;
        }
        try {
            ImageIO.write((RenderedImage)image, formatName, output);
        }
        catch (IOException ex) {
            Logger.getLogger(ImageHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static int max255(float val) {
        if (val > 255.0f) {
            return 255;
        }
        return (int)val;
    }

    private static void divideAlpha(int[] pixels) {
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = ImageHelper.divideAlpha(pixels[i]);
        }
    }

    private static int divideAlpha(int value) {
        int a = value >> 24 & 0xFF;
        int r = value >> 16 & 0xFF;
        int g = value >> 8 & 0xFF;
        int b = value & 0xFF;
        float multiplier = a == 0 ? 0.0f : 255.0f / (float)a;
        r = ImageHelper.max255((float)r * multiplier);
        g = ImageHelper.max255((float)g * multiplier);
        b = ImageHelper.max255((float)b * multiplier);
        return RGBA.toInt(r, g, b, a);
    }

    private static BufferedImage fixImageIOJpegBug(BufferedImage image) {
        int type = image.getType();
        if (type != 1) {
            int width = image.getWidth();
            int height = image.getHeight();
            BufferedImage newImage = new BufferedImage(width, height, 1);
            int[] pixels2 = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            int[] pixels = image.getRGB(0, 0, width, height, null, 0, width);
            for (int i = 0; i < pixels.length; ++i) {
                pixels2[i] = pixels[i] & 0xFFFFFF;
            }
            return newImage;
        }
        return image;
    }

    public static String getImageFormatString(ImageFormat format) {
        switch (format) {
            case UNKNOWN: {
                return "unk";
            }
            case JPEG: {
                return "jpg";
            }
            case GIF: {
                return "gif";
            }
            case PNG: {
                return "png";
            }
            case BMP: {
                return "bmp";
            }
            case WEBP: {
                return "webp";
            }
        }
        throw new Error("Unsupported image format: " + (Object)((Object)format));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static Dimension getDimension(InputStream input) throws IOException {
        block19: {
            try {
                Throwable throwable = null;
                try (ImageInputStream in = ImageIO.createImageInputStream(input);){
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
                    if (!readers.hasNext()) break block19;
                    ImageReader reader = readers.next();
                    try {
                        reader.setInput(in);
                        Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                        reader.dispose();
                        return dimension;
                    }
                    catch (Throwable throwable2) {
                        try {
                            reader.dispose();
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                    }
                }
            }
            catch (IOException in) {
                // empty catch block
            }
        }
        BufferedImage image = ImageHelper.read(input);
        return new Dimension(image.getWidth(), image.getHeight());
    }

    static {
        ImageIO.setUseCache(false);
    }
}

