/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.helpers;

import com.jpexs.decompiler.flash.helpers.CodeFormatting;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.LoopWithType;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import java.util.Stack;

public class NulWriter
extends GraphTextWriter {
    private final Stack<LoopWithType> loopStack = new Stack();
    private final Stack<Boolean> stringAddedStack = new Stack();
    private boolean stringAdded = false;

    public NulWriter() {
        super(new CodeFormatting());
    }

    public void startLoop(long loopId, int loopType) {
        LoopWithType loop = new LoopWithType();
        loop.loopId = loopId;
        loop.type = loopType;
        this.loopStack.add(loop);
    }

    public LoopWithType endLoop(long loopId) {
        LoopWithType loopIdInStack = this.loopStack.pop();
        if (loopId != loopIdInStack.loopId) {
            throw new Error("LoopId mismatch");
        }
        return loopIdInStack;
    }

    public long getLoop() {
        if (this.loopStack.isEmpty()) {
            return -1L;
        }
        return this.loopStack.peek().loopId;
    }

    public long getNonSwitchLoop() {
        LoopWithType loop;
        if (this.loopStack.isEmpty()) {
            return -1L;
        }
        int pos = this.loopStack.size() - 1;
        do {
            loop = (LoopWithType)this.loopStack.get(pos);
        } while (--pos >= 0 && loop.type == LoopWithType.LOOP_TYPE_SWITCH);
        if (loop.type == LoopWithType.LOOP_TYPE_SWITCH) {
            return -1L;
        }
        return loop.loopId;
    }

    public void setLoopUsed(long loopId) {
        if (this.loopStack.isEmpty()) {
            return;
        }
        int pos = this.loopStack.size() - 1;
        LoopWithType loop = null;
        do {
            loop = (LoopWithType)this.loopStack.get(pos);
        } while (--pos >= 0 && loop.loopId != loopId);
        if (loop.loopId == loopId) {
            loop.used = true;
        }
    }

    @Override
    public NulWriter hilightSpecial(String text, HighlightSpecialType type, String specialValue, HighlightData data) {
        this.stringAdded = true;
        return this;
    }

    @Override
    public GraphTextWriter appendWithData(String str, HighlightData data) {
        this.stringAdded = true;
        return this;
    }

    @Override
    public GraphTextWriter append(char value) {
        this.stringAdded = true;
        return this;
    }

    @Override
    public GraphTextWriter append(int value) {
        this.stringAdded = true;
        return this;
    }

    @Override
    public GraphTextWriter append(long value) {
        this.stringAdded = true;
        return this;
    }

    @Override
    public NulWriter append(String str) {
        this.stringAdded = true;
        return this;
    }

    @Override
    public NulWriter append(String str, long offset, long fileOffset) {
        this.stringAdded = true;
        return this;
    }

    @Override
    public NulWriter appendNoHilight(int i) {
        this.stringAdded = true;
        return this;
    }

    @Override
    public NulWriter appendNoHilight(String str) {
        this.stringAdded = true;
        return this;
    }

    public void mark() {
        this.stringAddedStack.add(this.stringAdded);
        this.stringAdded = false;
    }

    public boolean getMark() {
        boolean result = this.stringAdded;
        this.stringAdded = this.stringAddedStack.pop() != false || result;
        return result;
    }
}

