/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.helpers.hilight;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightType;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightingList;
import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;

public class Highlighting
implements Serializable {
    public HighlightType type;
    public String HighlightedText;
    public int startPos;
    public int len;
    private final HighlightData properties;
    private static final Map<HighlightingList, Highlighting[]> listToPosMap = new WeakHashMap<HighlightingList, Highlighting[]>();

    public HighlightData getProperties() {
        return this.properties;
    }

    public static Highlighting search(HighlightingList list, HighlightData properties, long from, long to) {
        Object ret = null;
        for (Highlighting h : list) {
            if (from > -1L && (long)h.startPos < from || to > -1L && (long)h.startPos > to) continue;
            HighlightData hProp = h.getProperties();
            if (properties.declaration && !hProp.declaration || properties.declaredType != null && !properties.declaredType.equals(hProp.declaredType) || properties.localName != null && !properties.localName.equals(hProp.localName) || properties.specialValue != null && !properties.specialValue.equals(hProp.specialValue)) continue;
            return h;
        }
        return null;
    }

    public static Highlighting searchPos(HighlightingList list, long pos) {
        return Highlighting.searchPos(list, pos, -1L, -1L);
    }

    public static Highlighting searchPos(HighlightingList list, long pos, long from, long to) {
        return Highlighting.searchPosNew(list, pos, from, to);
    }

    public static Highlighting searchPosNew(HighlightingList list, long pos, long from, long to) {
        Highlighting[] hmap = Highlighting.posToHighlightMap(list);
        if (pos > -1L) {
            if (pos >= (long)hmap.length) {
                return null;
            }
            return hmap[(int)pos];
        }
        if (from == -1L) {
            from = 0L;
        }
        if (to == -1L) {
            to = hmap.length;
        }
        for (long i = from; i < to; ++i) {
            Highlighting h = hmap[(int)i];
            if (h == null) continue;
            return h;
        }
        return null;
    }

    private static Highlighting[] posToHighlightMap(HighlightingList list) {
        if (list.isEmpty()) {
            return new Highlighting[0];
        }
        if (listToPosMap.containsKey(list)) {
            return listToPosMap.get(list);
        }
        Highlighting lastH = (Highlighting)list.get(list.size() - 1);
        int maxPos = lastH.startPos + Math.max(1, lastH.len);
        Highlighting[] map = new Highlighting[maxPos];
        for (Highlighting h : list) {
            for (int i = h.startPos; i < h.startPos + Math.max(1, h.len); ++i) {
                Highlighting oldH = map[i];
                if (oldH == null) {
                    map[i] = h;
                    continue;
                }
                if (h.len >= oldH.len) continue;
                map[i] = h;
            }
        }
        listToPosMap.put(list, map);
        return map;
    }

    public static Highlighting searchOffset(HighlightingList list, long offset) {
        return Highlighting.searchOffset(list, offset, -1L, -1L);
    }

    public static Highlighting searchOffset(HighlightingList list, long offset, long from, long to) {
        for (Highlighting h : list) {
            if (from > -1L && (long)h.startPos < from || to > -1L && (long)h.startPos > to || h.getProperties().offset != offset) continue;
            return h;
        }
        return null;
    }

    public static Highlighting searchIndex(HighlightingList list, long index) {
        return Highlighting.searchIndex(list, index, -1L, -1L);
    }

    public static Highlighting searchIndex(HighlightingList list, long index, long from, long to) {
        for (Highlighting h : list) {
            if (from > -1L && (long)h.startPos < from || to > -1L && (long)h.startPos > to || h.getProperties().index != index) continue;
            return h;
        }
        return null;
    }

    public static HighlightingList searchAllPos(HighlightingList list, long pos) {
        HighlightingList ret = new HighlightingList();
        for (Highlighting h : list) {
            if (pos != -1L && (pos < (long)h.startPos || pos >= (long)(h.startPos + h.len))) continue;
            ret.add(h);
        }
        return ret;
    }

    public static HighlightingList searchAllIndexes(HighlightingList list, long index) {
        HighlightingList ret = new HighlightingList();
        for (Highlighting h : list) {
            long i = h.getProperties().index;
            if (i != index) continue;
            ret.add(h);
        }
        return ret;
    }

    public static HighlightingList searchAllLocalNames(HighlightingList list, String localName) {
        HighlightingList ret = new HighlightingList();
        for (Highlighting h : list) {
            if (!localName.equals(h.getProperties().localName)) continue;
            ret.add(h);
        }
        return ret;
    }

    public String toString() {
        return this.startPos + "-" + (this.startPos + this.len) + " type:" + (Object)((Object)this.type);
    }

    public Highlighting(int startPos, HighlightData data, HighlightType type, String text) {
        this.startPos = startPos;
        this.type = type;
        if (Configuration._debugMode.get().booleanValue()) {
            this.HighlightedText = text;
        }
        this.properties = data;
    }
}

