/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy;

import com.jpexs.decompiler.flash.iggy.DataType;
import com.jpexs.decompiler.flash.iggy.annotations.IggyFieldType;
import com.jpexs.decompiler.flash.iggy.streams.ReadDataStreamInterface;
import com.jpexs.decompiler.flash.iggy.streams.StructureInterface;
import com.jpexs.decompiler.flash.iggy.streams.WriteDataStreamInterface;
import java.io.IOException;
import java.util.logging.Logger;

public class IggyShapeNode
implements StructureInterface {
    public static final int STRUCT_SIZE = 24;
    private static Logger LOGGER = Logger.getLogger(IggyShapeNode.class.getName());
    public static int NODE_TYPE_MOVE = 1;
    public static int NODE_TYPE_LINE_TO = 2;
    public static int NODE_TYPE_CURVE_POINT = 3;
    @IggyFieldType(value=DataType.float_t)
    float targetX;
    @IggyFieldType(value=DataType.float_t)
    float targetY;
    @IggyFieldType(value=DataType.float_t)
    float controlX;
    @IggyFieldType(value=DataType.float_t)
    float controlY;
    @IggyFieldType(value=DataType.uint8_t)
    int node_type;
    @IggyFieldType(value=DataType.uint8_t)
    int node_subtype;
    @IggyFieldType(value=DataType.uint8_t)
    int zer1;
    @IggyFieldType(value=DataType.uint8_t)
    int zer2;
    @IggyFieldType(value=DataType.uint32_t)
    long isstart;
    private boolean first;

    public IggyShapeNode(float targetX, float targetY, float controlX, float controlY, int node_type, int node_subtype, boolean first) {
        this.targetX = targetX;
        this.targetY = targetY;
        this.controlX = controlX;
        this.controlY = controlY;
        this.node_type = node_type;
        this.node_subtype = node_subtype;
        this.zer1 = 0;
        this.zer2 = 0;
        this.first = first;
        this.isstart = first ? 0L : 1L;
    }

    public IggyShapeNode(ReadDataStreamInterface s, boolean first) throws IOException {
        this.first = first;
        this.readFromDataStream(s);
    }

    @Override
    public void readFromDataStream(ReadDataStreamInterface s) throws IOException {
        this.targetX = s.readFloat();
        this.targetY = s.readFloat();
        this.controlX = s.readFloat();
        this.controlY = s.readFloat();
        this.node_type = s.readUI8();
        this.node_subtype = s.readUI8();
        this.zer1 = s.readUI8();
        this.zer2 = s.readUI8();
        this.isstart = s.readUI32();
        if (this.zer1 != 0 | this.zer2 != 0) {
            LOGGER.fine(String.format("Unknown zeroes at pos %08X\n", s.position() - 6L));
        }
        if (!this.first & this.isstart != 1L) {
            LOGGER.fine(String.format("Unknown format at pos %08X\n", s.position() - 4L));
        }
        if (this.first & this.isstart != 0L) {
            LOGGER.fine(String.format("Unknown format at pos %08X\n", s.position() - 4L));
        }
    }

    @Override
    public void writeToDataStream(WriteDataStreamInterface s) throws IOException {
        s.writeFloat(this.targetX);
        s.writeFloat(this.targetY);
        s.writeFloat(this.controlX);
        s.writeFloat(this.controlY);
        s.writeUI8(this.node_type);
        s.writeUI8(this.node_subtype);
        s.writeUI8(this.zer1);
        s.writeUI8(this.zer2);
        s.writeUI32(this.isstart);
    }

    public float getTargetX() {
        return this.targetX;
    }

    public float getTargetY() {
        return this.targetY;
    }

    public float getControlX() {
        return this.controlX;
    }

    public float getControlY() {
        return this.controlY;
    }

    public int getNodeType() {
        return this.node_type;
    }

    public int getNodeSubType() {
        return this.node_subtype;
    }

    public int getZer1() {
        return this.zer1;
    }

    public int getZer2() {
        return this.zer2;
    }

    public boolean isStart() {
        return this.isstart == 1L;
    }
}

