/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy.streams;

import com.jpexs.decompiler.flash.iggy.streams.DataStreamInterface;
import com.jpexs.decompiler.flash.iggy.streams.SeekMode;
import java.io.EOFException;
import java.io.IOException;

public abstract class AbstractDataStream
implements DataStreamInterface {
    @Override
    public abstract Long available();

    @Override
    public abstract long position();

    @Override
    public long readUI64() throws IOException {
        long lsb = this.readUI32();
        long msb = this.readUI32();
        long result = msb << 32 | lsb;
        return result & 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long readSI64() throws IOException {
        long lsb = this.readUI32();
        long msb = this.readUI32();
        return msb << 32 | lsb;
    }

    @Override
    public boolean writeUI64(long val) throws IOException {
        this.write((int)(val & 0xFFL));
        this.write((int)(val >> 8 & 0xFFL));
        this.write((int)(val >> 16 & 0xFFL));
        this.write((int)(val >> 24 & 0xFFL));
        this.write((int)(val >> 32 & 0xFFL));
        this.write((int)(val >> 40 & 0xFFL));
        this.write((int)(val >> 48 & 0xFFL));
        this.write((int)(val >> 56 & 0xFFL));
        return true;
    }

    @Override
    public boolean writeSI64(long val) throws IOException {
        this.write((int)(val & 0xFFL));
        this.write((int)(val >> 8 & 0xFFL));
        this.write((int)(val >> 16 & 0xFFL));
        this.write((int)(val >> 24 & 0xFFL));
        this.write((int)(val >> 32 & 0xFFL));
        this.write((int)(val >> 40 & 0xFFL));
        this.write((int)(val >> 48 & 0xFFL));
        this.write((int)(val >> 56 & 0xFFL));
        return true;
    }

    @Override
    public long readUI32() throws IOException {
        try {
            return this.readUI8() | this.readUI8() << 8 | this.readUI8() << 16 | this.readUI8() << 24;
        }
        catch (EOFException ex) {
            return -1L;
        }
    }

    @Override
    public boolean writeUI32(long val) throws IOException {
        this.write((int)(val & 0xFFL));
        this.write((int)(val >> 8 & 0xFFL));
        this.write((int)(val >> 16 & 0xFFL));
        this.write((int)(val >> 24 & 0xFFL));
        return true;
    }

    @Override
    public int readUI16() throws IOException {
        try {
            return (this.readUI8() | this.readUI8() << 8) & 0xFFFF;
        }
        catch (EOFException ex) {
            return -1;
        }
    }

    @Override
    public boolean writeUI16(int val) throws IOException {
        this.write(val & 0xFF);
        this.write(val >> 8 & 0xFF);
        return true;
    }

    @Override
    public boolean writeUI8(int val) throws IOException {
        this.write(val);
        return true;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat((int)this.readUI32());
    }

    @Override
    public boolean writeFloat(float val) throws IOException {
        return this.writeUI32(Float.floatToIntBits(val));
    }

    @Override
    public byte[] readBytes(int numBytes) throws IOException {
        byte[] ret = new byte[numBytes];
        for (int i = 0; i < numBytes; ++i) {
            ret[i] = (byte)this.read();
        }
        return ret;
    }

    @Override
    public byte[] getAllBytes() throws IOException {
        long oldPos = this.position();
        this.seek(0L, SeekMode.SET);
        byte[] ret = this.readBytes((int)this.available().longValue());
        this.seek(oldPos, SeekMode.SET);
        return ret;
    }

    @Override
    public void writeBytes(byte[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.write(data[i] & 0xFF);
        }
    }

    @Override
    public abstract int read() throws IOException;

    @Override
    public abstract void seek(long var1, SeekMode var3) throws IOException;

    @Override
    public void write(int val) throws IOException {
    }

    @Override
    public void close() {
    }

    @Override
    public int readUI8() throws IOException {
        try {
            return this.read() & 0xFF;
        }
        catch (EOFException ex) {
            return -1;
        }
    }

    @Override
    public int readUI8(long addr) throws IOException {
        long curPos = this.position();
        this.seek(addr, SeekMode.SET);
        int val = this.readUI8();
        this.seek(curPos, SeekMode.SET);
        return val;
    }

    @Override
    public boolean writeWChar(String name) throws IOException {
        for (int i = 0; i < name.length(); ++i) {
            this.writeUI16(name.charAt(i));
        }
        this.writeUI16(0);
        return true;
    }

    @Override
    public String readWChar() throws IOException {
        char c;
        StringBuilder strBuilder = new StringBuilder();
        while ((c = (char)this.readUI16()) != '\u0000') {
            strBuilder.append(c);
        }
        return strBuilder.toString();
    }

    @Override
    public void pad8bytes() throws IOException {
        int pad8 = (int)(this.position() % 8L);
        switch (pad8) {
            case 1: {
                this.write(0);
            }
            case 2: {
                this.write(0);
            }
            case 3: {
                this.write(0);
            }
            case 4: {
                this.write(0);
            }
            case 5: {
                this.write(0);
            }
            case 6: {
                this.write(0);
            }
            case 7: {
                this.write(0);
            }
        }
    }

    @Override
    public void setOlderOffsetToThisPos(long savedPos) throws IOException {
        long curPos = this.position();
        long actual = curPos - savedPos;
        this.seek(savedPos, SeekMode.SET);
        this.writeUI64(actual);
        this.seek(curPos, SeekMode.SET);
    }

    @Override
    public void setOlderOffsetToThisPosCheck(long savedPos, long expected) throws IOException {
        if (expected == 1L) {
            return;
        }
        long curPos = this.position();
        long actual = curPos - savedPos;
        if (actual != expected) {
            throw new RuntimeException("Expected " + expected + " but found actual " + actual + ". Diff:" + (actual - expected > 0L ? "+" : "") + (actual - expected));
        }
    }
}

