/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy.streams;

import com.jpexs.decompiler.flash.iggy.streams.TemporaryDataStream;
import com.jpexs.decompiler.flash.iggy.streams.WriteDataStreamInterface;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class IggyIndexBuilder {
    private static Logger LOGGER = Logger.getLogger(IggyIndexBuilder.class.getName());
    private static final int CODE_FC_SKIP1 = 252;
    private static final int CODE_FD_OFS8_SKIP_TWICE8 = 253;
    private static final int CODE_FE_OFS8_POSITIVE = 254;
    private static final int CODE_FF_OFS32 = 255;
    private List<Integer> constTable = new ArrayList<Integer>();
    private Map<Integer, List<Integer>> constTableOffsets = new HashMap<Integer, List<Integer>>();
    private Map<Integer, List<Integer>> constTableTypes = new HashMap<Integer, List<Integer>>();
    private WriteDataStreamInterface indexStream = new TemporaryDataStream();
    private static final int CONST_VAL_SHAPE_NODE_SIZE = 24;
    private static final int CONST_VAL_KERNING_RECORD_SIZE = 6;
    private static final int CONST_VAL_CHAR_OFFSET_SIZE = 32;
    private static final int CONST_VAL_BIN_INFO_SIZE = 96;
    private static final int CONST_VAL_TYPE_INFO_SIZE = 24;
    private static final int CONST_VAL_SHAPE_SIZE = 64;
    private static final int CONST_VAL_GENERAL_FONT_INFO_SIZE = 112;
    private static final int CONST_VAL_GENERAL_FONT_INFO2_SIZE = 240;
    private static final int CONST_VAL_TEXT_DATA_SIZE = 104;
    private static final int CONST_VAL_SEQUENCE_SIZE = 16;
    public static final int CONST_SHAPE_NODE_SIZE = 0;
    public static final int CONST_KERNING_RECORD_SIZE = 1;
    public static final int CONST_CHAR_OFFSET_SIZE = 2;
    public static final int CONST_BIN_INFO_SIZE = 3;
    public static final int CONST_TYPE_INFO_SIZE = 4;
    public static final int CONST_SHAPE_SIZE = 5;
    public static final int CONST_GENERAL_FONT_INFO_SIZE = 6;
    public static final int CONST_GENERAL_FONT_INFO2_SIZE = 7;
    public static final int CONST_TEXT_DATA_SIZE = 8;
    public static final int CONST_SEQUENCE_SIZE = 9;
    private long position = 0L;

    public IggyIndexBuilder() throws IOException {
        this.addConst(24, new int[]{0, 4, 8, 12, 18, 20, 22}, new int[]{5, 5, 5, 5, 4, 4, 4});
        this.addConst(6, new int[]{0, 2, 4}, new int[]{4, 4, 4});
        this.addConst(32, new int[]{8, 16, 24}, new int[]{4, 8, 2});
        this.addConst(96, new int[]{0, 9, 12, 16, 20, 24, 28, 32, 36, 40, 48, 56, 58}, new int[]{2, 3, 5, 5, 5, 5, 5, 5, 5, 4, 2, 4, 4});
        this.addConst(24, new int[]{8, 16}, new int[]{2, 5});
        this.addConst(64, new int[]{0, 4, 8, 12, 16, 24, 32, 40, 48}, new int[]{5, 5, 5, 5, 2, 5, 2, 2, 2});
        this.addConst(112, new int[]{1, 2, 8, 16, 32, 34, 36, 38, 43, 48, 56, 64, 72, 76, 80, 84, 88, 96}, new int[]{12, 4, 5, 2, 4, 4, 4, 4, 3, 2, 2, 2, 5, 5, 5, 5, 5, 2});
        this.addConst(240, new int[]{16}, new int[]{2});
        this.addConst(104, new int[]{1, 2, 8, 16, 32, 36, 40, 44, 48, 50, 56, 68, 70, 72, 74, 76, 78, 96}, new int[]{12, 4, 5, 2, 5, 5, 5, 5, 4, 4, 2, 4, 4, 4, 4, 4, 4, 2});
        this.addConst(16, new int[]{0, 8}, new int[]{2, 5});
    }

    private void addConst(int totalLength, int[] localOffsets, int[] types) {
        if (localOffsets.length != types.length) {
            throw new RuntimeException("Size of localOffsets does not match size of types on adding consts with total length " + totalLength);
        }
        this.constTable.add(totalLength);
        int newIndex = this.constTable.size() - 1;
        ArrayList<Integer> localOffsetsList = new ArrayList<Integer>();
        for (int t : localOffsets) {
            localOffsetsList.add(t);
        }
        ArrayList<Integer> typesList = new ArrayList<Integer>();
        for (int t : types) {
            typesList.add(t);
        }
        this.constTableOffsets.put(newIndex, localOffsetsList);
        this.constTableTypes.put(newIndex, typesList);
    }

    private byte[] getIndexTableBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.constTable.size());
        for (int i = 0; i < this.constTable.size(); ++i) {
            baos.write(this.constTable.get(i));
            baos.write(this.constTableOffsets.get(i).size());
            for (int j = 0; j < this.constTableOffsets.get(i).size(); ++j) {
                baos.write(this.constTableOffsets.get(i).get(j));
                baos.write(this.constTableTypes.get(i).get(j));
            }
        }
        return baos.toByteArray();
    }

    public byte[] getIndexBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(this.getIndexTableBytes());
            baos.write(this.indexStream.getAllBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public long writeConstLength(int constIndex) {
        return this.writeIndex(constIndex, false, 0L);
    }

    public long writeConstLengthArray(int constIndex, long cnt) {
        long ret = 0L;
        long rem = cnt;
        while (rem != 0L) {
            if (rem == 1L) {
                ret += this.writeIndex(constIndex, false, 0L);
                break;
            }
            if (rem <= 64L) {
                ret += this.writeIndex(128 + (int)rem - 1, false, constIndex);
                break;
            }
            rem -= 64L;
            ret += this.writeIndex(191, false, constIndex);
        }
        return ret;
    }

    public long pad8bytes() {
        int pad8 = (int)(this.position % 8L);
        switch (pad8) {
            case 2: {
                this.writePaddingBytes(2);
                break;
            }
            case 4: {
                this.writePaddingBytes(1);
                break;
            }
            case 6: {
                this.writePaddingBytes(0);
            }
        }
        return 0L;
    }

    public long writeTwoPaddingBytes() {
        return this.writePaddingBytes(0);
    }

    public long writePadding16bit() {
        return this.writePaddingBytes(0);
    }

    public long writePadding32bit() {
        return this.writePaddingBytes(1);
    }

    public long writePadding64bit() {
        return this.writePaddingBytes(2);
    }

    public long writePaddingBytes(int twoPlusHowManyTwoBytes) {
        return this.writeIndex(192 + twoPlusHowManyTwoBytes, false, 0L);
    }

    public long writePointerArray(boolean is64, long cnt) {
        return this.writeIndex(210, is64, cnt - 1L);
    }

    public long write64bitPointerArray(long cnt) {
        return this.writeIndex(210, true, cnt - 1L);
    }

    public long write32bitPointerArray(long cnt) {
        return this.writeIndex(210, false, cnt - 1L);
    }

    public long write16bitArray(long cnt) {
        return this.writeIndex(212, false, cnt - 1L);
    }

    public long write32bitArray(long cnt) {
        return this.writeIndex(213, false, cnt - 1L);
    }

    public long write64bitArray(long cnt) {
        return this.writeIndex(214, false, cnt - 1L);
    }

    public long skipOneInIndex() {
        return this.writeIndex(252, false, 0L);
    }

    public long writeLengthCustom(int totalLen, int[] localOffsets, int[] platformTypes) {
        return this.writeIndex(253, false, totalLen, localOffsets, platformTypes);
    }

    public long writeLengthBytePositive(int valUI8) {
        return this.writeIndex(254, false, valUI8);
    }

    public long writeLengthUI32(long offset) {
        return this.writeIndex(255, false, offset);
    }

    public static int platformNumSize(boolean is64, int i) {
        if (i <= 2) {
            return is64 ? 8 : 4;
        }
        if (i <= 4) {
            return 2;
        }
        if (i == 5) {
            return 4;
        }
        if (i == 6) {
            return 8;
        }
        throw new RuntimeException("Unknown platform num");
    }

    private long writeIndex(int code, boolean is64, long val) {
        return this.writeIndex(code, is64, val, null, null);
    }

    private long writeIndex(int code, boolean is64, long val, int[] localOffsets, int[] platformTypes) {
        try {
            LOGGER.finer(String.format("Code = 0x%02X", code));
            this.indexStream.writeUI8(code);
            if (code < 128) {
                LOGGER.finest("0-0x7F: code is directly an index to the index_table");
                if (code >= this.constTable.size()) {
                    LOGGER.severe(String.format("< 0x80: index is greater than index_table_size. %x > %x", code, this.constTable.size()));
                    return 0L;
                }
                LOGGER.finest(String.format("LENGTH = indexTable[%d] = %d", code, this.constTable.get(code)));
                long ret = this.constTable.get(code).intValue();
                this.position += ret;
                return ret;
            }
            if (code < 192) {
                LOGGER.finest("0x80-BF: table[0..255]*(code-0x7F)");
                this.indexStream.writeUI8((int)val);
                int index = (int)val;
                if (index >= this.constTable.size()) {
                    LOGGER.severe(String.format("< 0xC0: index is greater than index_table_size. %x > %x", index, this.constTable.size()));
                    return 0L;
                }
                int n = code - 127;
                LOGGER.finest(String.format("index = %d, n = code - 0x7F = %d", index, n));
                LOGGER.finest(String.format("LENGTH = indexTable[index] * n = indexTable[%d] * %d = %d", index, n, this.constTable.get(index) * n));
                long ret = this.constTable.get(index) * n;
                this.position += ret;
                return ret;
            }
            if (code < 208) {
                LOGGER.finest("0xC0-CF: code*2-0x17E");
                long ret = code * 2 - 382;
                this.position += ret;
                return ret;
            }
            if (code < 224) {
                LOGGER.finest("0xD0-0xDF: platform based");
                int i = code & 0xF;
                this.indexStream.writeUI8((int)val);
                int n8 = (int)val;
                if (n8 < 0) {
                    LOGGER.severe(String.format("< 0xE0: Cannot read n.", new Object[0]));
                    return 0L;
                }
                int n = n8 + 1;
                LOGGER.finest(String.format("i=%X", i));
                LOGGER.finest(String.format("n=%d", n));
                if (is64) {
                    if (i <= 2) {
                        LOGGER.finest(String.format("offset += %d", 8 * n));
                        this.position += (long)(8 * n);
                        return 8 * n;
                    }
                    if (i <= 4) {
                        LOGGER.finest(String.format("offset += %d", 2 * n));
                        this.position += (long)(2 * n);
                        return 2 * n;
                    }
                    if (i == 5) {
                        LOGGER.finest(String.format("offset += %d", 4 * n));
                        this.position += (long)(4 * n);
                        return 4 * n;
                    }
                    if (i == 6) {
                        LOGGER.finest(String.format("offset += %d", 8 * n));
                        this.position += (long)(8 * n);
                        return 8 * n;
                    }
                    LOGGER.severe(String.format("< 0xE0: Invalid value for i (%x %x)", i, code));
                    return 0L;
                }
                switch (i) {
                    case 2: {
                        LOGGER.finest(String.format("offset += %d", 4 * n));
                        this.position += (long)(4 * n);
                        return 4 * n;
                    }
                    case 4: {
                        LOGGER.finest(String.format("offset += %d", 2 * n));
                        this.position += (long)(2 * n);
                        return 2 * n;
                    }
                    case 5: {
                        LOGGER.finest(String.format("offset += %d", 4 * n));
                        this.position += (long)(4 * n);
                        return 4 * n;
                    }
                    case 6: {
                        LOGGER.finest(String.format("offset += %d", 8 * n));
                        this.position += (long)(8 * n);
                        return 8 * n;
                    }
                }
                LOGGER.severe(String.format("< 0xE0: invalid value for i (%x %x)", i, code));
                return 0L;
            }
            if (code == 252) {
                LOGGER.finest(String.format("0xFC: skip 1 ", new Object[0]));
                this.indexStream.write(0);
                return 1L;
            }
            if (code == 253) {
                LOGGER.finest(String.format("0xFD: 0..255, skip 2 * 0..255 ", new Object[0]));
                int n = (int)val;
                this.indexStream.writeUI8((int)val);
                int m = localOffsets.length;
                this.indexStream.writeUI8(localOffsets.length);
                long offset = n;
                this.position += (long)n;
                LOGGER.finest(String.format("offset += %d", n));
                for (int i = 0; i < localOffsets.length; ++i) {
                    this.indexStream.writeUI8(localOffsets[i]);
                    this.indexStream.writeUI8(platformTypes[i]);
                }
                return offset;
            }
            if (code == 254) {
                LOGGER.finest(String.format("0xFD: 0..255 + 1 ", new Object[0]));
                this.indexStream.writeUI8((int)val);
                int n8 = (int)val;
                if (n8 < 0) {
                    LOGGER.severe(String.format("0xFE: Cannot read n.", new Object[0]));
                    return 0L;
                }
                int n = n8 + 1;
                this.position += (long)n;
                LOGGER.finest(String.format("offset += %d", n));
                return n;
            }
            if (code == 255) {
                LOGGER.finest(String.format("0xFF: 32bit ", new Object[0]));
                this.indexStream.writeUI32(val);
                long n = val;
                if (n < 0L) {
                    LOGGER.severe(String.format("0xFF: Cannot read n.", new Object[0]));
                    return 0L;
                }
                LOGGER.finest(String.format("offset += %d", n));
                this.position += n;
                return n;
            }
            LOGGER.warning(String.format("Unrecognized code: %x", code));
            return 0L;
        }
        catch (IOException ex) {
            return 0L;
        }
    }
}

