/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.ValueTooLargeException;
import com.jpexs.decompiler.flash.action.ConstantPoolTooBigException;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.ASMParser;
import com.jpexs.decompiler.flash.action.parser.script.ActionScript2Parser;
import com.jpexs.decompiler.flash.importers.ScriptImporterProgressListener;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AS2ScriptImporter {
    private static final Logger logger = Logger.getLogger(AS2ScriptImporter.class.getName());

    public int importScripts(String scriptsFolder, Map<String, ASMSource> asms) throws InterruptedException {
        return this.importScripts(scriptsFolder, asms, null);
    }

    public int importScripts(String scriptsFolder, Map<String, ASMSource> asms, ScriptImporterProgressListener listener) throws InterruptedException {
        if (!scriptsFolder.endsWith(File.separator)) {
            scriptsFolder = scriptsFolder + File.separator;
        }
        HashMap existingNamesMap = new HashMap();
        int importCount = 0;
        for (String key : asms.keySet()) {
            String txt;
            if (CancellableWorker.isInterrupted()) {
                throw new InterruptedException();
            }
            ASMSource asm = asms.get(key);
            String currentOutDir = scriptsFolder + key + File.separator;
            ArrayList<String> existingNames = (ArrayList<String>)existingNamesMap.get(currentOutDir = new File(currentOutDir).getParentFile().toString() + File.separator);
            if (existingNames == null) {
                existingNames = new ArrayList<String>();
                existingNamesMap.put(currentOutDir, existingNames);
            }
            String name = Helper.makeFileName(asm.getExportFileName());
            int i = 1;
            String baseName = name;
            while (existingNames.contains(name)) {
                name = baseName + "_" + ++i;
            }
            existingNames.add(name);
            String fileName = Path.combine(currentOutDir, name) + ".as";
            if (new File(fileName).exists()) {
                asm.getSwf().informListeners("importing_as", fileName);
                txt = Helper.readTextFile(fileName);
                ActionScript2Parser par = new ActionScript2Parser(asm.getSwf(), asm);
                boolean errored = false;
                try {
                    asm.setActions(par.actionsFromString(txt, asm.getSwf().getCharset()));
                }
                catch (ValueTooLargeException ex) {
                    logger.log(Level.SEVERE, "Script or some of its functions are too large, file: {0}", fileName);
                    errored = true;
                }
                catch (ActionParseException ex) {
                    logger.log(Level.SEVERE, "%error% on line %line%, file: %file%".replace("%error%", ex.text).replace("%line%", Long.toString(ex.line)).replace("%file%", fileName), ex);
                    errored = true;
                }
                catch (CompilationException ex) {
                    logger.log(Level.SEVERE, "%error% on line %line%, file: %file%".replace("%error%", ex.text).replace("%line%", Long.toString(ex.line)).replace("%file%", fileName), ex);
                    errored = true;
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "error during script import, file: %file%".replace("%file%", fileName), ex);
                    errored = true;
                }
                catch (InterruptedException ex) {
                    return importCount;
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "error during script import, file: %file%".replace("%file%", fileName), ex);
                    errored = true;
                }
                if (!errored) {
                    asm.setModified();
                    ++importCount;
                    if (listener != null) {
                        listener.scriptImported();
                    }
                } else if (listener != null) {
                    listener.scriptImportError();
                }
            }
            if (new File(fileName = Path.combine(currentOutDir, name) + ".pcode").exists()) {
                asm.getSwf().informListeners("importing_as", fileName);
                txt = Helper.readTextFile(fileName);
                boolean errored = false;
                try {
                    asm.setActions(ASMParser.parse(0L, true, txt, asm.getSwf().version, false, asm.getSwf().getCharset()));
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "error during script import, file: %file%".replace("%file%", fileName), ex);
                    errored = true;
                }
                catch (ActionParseException ex) {
                    logger.log(Level.SEVERE, "%error% on line %line%, file: %file%".replace("%error%", ex.text).replace("%line%", Long.toString(ex.line)).replace("%file%", fileName), ex);
                    errored = true;
                }
                if (!errored) {
                    asm.setModified();
                    ++importCount;
                    if (listener != null) {
                        listener.scriptImported();
                    }
                } else if (listener != null) {
                    listener.scriptImportError();
                }
            }
            if (new File(fileName = Path.combine(currentOutDir, name) + ".hex").exists()) {
                asm.getSwf().informListeners("importing_as", fileName);
                txt = Helper.readTextFile(fileName);
                asm.setActionBytes(Helper.getBytesFromHexaText(txt));
                asm.setModified();
                ++importCount;
                if (listener != null) {
                    listener.scriptImported();
                }
            }
            if (!new File(fileName = Path.combine(currentOutDir, name) + ".txt").exists()) continue;
            asm.getSwf().informListeners("importing_as", fileName);
            txt = Helper.readTextFile(fileName);
            boolean errored = false;
            try {
                asm.setConstantPools(Helper.getConstantPoolsFromText(txt));
            }
            catch (ConstantPoolTooBigException ex) {
                logger.log(Level.SEVERE, null, ex);
                errored = true;
            }
            if (!errored) {
                asm.setModified();
                ++importCount;
                if (listener == null) continue;
                listener.scriptImported();
                continue;
            }
            if (listener == null) continue;
            listener.scriptImportError();
        }
        return importCount;
    }
}

