/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers.morphshape;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.importers.morphshape.ShapeForMorphExporter;
import com.jpexs.decompiler.flash.importers.morphshape.StyleMismatchException;
import com.jpexs.decompiler.flash.math.BezierEdge;
import com.jpexs.decompiler.flash.tags.DefineMorphShape2Tag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLE;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLE2;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MorphShapeGenerator {
    public void generate(DefineMorphShape2Tag morphShape, ShapeTag startShape, ShapeTag endShape) throws StyleMismatchException {
        int i;
        double minDistance;
        SWF swf = morphShape.getSwf();
        ShapeForMorphExporter startExport = new ShapeForMorphExporter(startShape);
        startExport.export();
        ShapeForMorphExporter endExport = new ShapeForMorphExporter(endShape);
        endExport.export();
        ArrayList<List<BezierEdge>> startBeziers = new ArrayList<List<BezierEdge>>();
        ArrayList<List<BezierEdge>> endBeziers = new ArrayList<List<BezierEdge>>();
        ArrayList<FILLSTYLE> startFillStyles = new ArrayList<FILLSTYLE>();
        ArrayList<Integer> startFillstyleIndices = new ArrayList<Integer>();
        ArrayList<LINESTYLE2> startLineStyles = new ArrayList<LINESTYLE2>();
        ArrayList<Integer> startLineStyleIndices = new ArrayList<Integer>();
        ArrayList<FILLSTYLE> endFillStyles = new ArrayList<FILLSTYLE>();
        ArrayList<LINESTYLE2> endLineStyles = new ArrayList<LINESTYLE2>();
        HashSet<Integer> usedBs = new HashSet<Integer>();
        ArrayList<Integer> startShapeIndices = new ArrayList<Integer>();
        ArrayList<Integer> endShapeIndices = new ArrayList<Integer>();
        for (int a = 0; a < startExport.shapes.size(); ++a) {
            minDistance = Double.MAX_VALUE;
            double minDistanceNoUsed = Double.MAX_VALUE;
            int selectedB = -1;
            int selectedBNoUsed = -1;
            int startFillStyleIndex = startExport.fillStyleIndices.get(a);
            FILLSTYLE startFillStyle = startFillStyleIndex == -1 ? null : startExport.fillStyles.get(startFillStyleIndex);
            int startLineStyleIndex = startExport.lineStyleIndices.get(a);
            LINESTYLE2 startLineStyle = startLineStyleIndex == -1 ? null : startExport.lineStyles.get(startLineStyleIndex);
            for (int b = 0; b < endExport.shapes.size(); ++b) {
                LINESTYLE2 endLineStyle;
                int endFillStyleIndex = endExport.fillStyleIndices.get(b);
                FILLSTYLE endFillStyle = endFillStyleIndex == -1 ? null : endExport.fillStyles.get(endFillStyleIndex);
                int endLineStyleIndex = endExport.lineStyleIndices.get(b);
                LINESTYLE2 lINESTYLE2 = endLineStyle = endLineStyleIndex == -1 ? null : endExport.lineStyles.get(endLineStyleIndex);
                if ((endFillStyle != null || startFillStyle != null) && (startFillStyle == null || endFillStyle == null || !startFillStyle.isCompatibleFillStyle(endFillStyle, swf)) || (endLineStyle != null || startLineStyle != null) && (startLineStyle == null || endLineStyle == null || !startLineStyle.isCompatibleLineStyle(endLineStyle, swf))) continue;
                double distance = startExport.centralPos.get(a).distance(endExport.centralPos.get(b));
                if (distance < minDistance) {
                    minDistance = distance;
                    selectedB = b;
                }
                if (!(distance < minDistanceNoUsed) || usedBs.contains(b)) continue;
                minDistanceNoUsed = distance;
                selectedBNoUsed = b;
            }
            if (selectedB == -1) {
                throw new StyleMismatchException();
            }
            if (selectedBNoUsed != -1) {
                selectedB = selectedBNoUsed;
            }
            startShapeIndices.add(a);
            endShapeIndices.add(selectedB);
            usedBs.add(selectedB);
        }
        if (usedBs.size() < endExport.shapes.size()) {
            for (int b = 0; b < endExport.shapes.size(); ++b) {
                if (usedBs.contains(b)) continue;
                minDistance = Double.MAX_VALUE;
                int selectedA = -1;
                int endFillStyleIndex = endExport.fillStyleIndices.get(b);
                FILLSTYLE endFillStyle = endFillStyleIndex == -1 ? null : endExport.fillStyles.get(endFillStyleIndex);
                int endLineStyleIndex = endExport.lineStyleIndices.get(b);
                LINESTYLE2 endLineStyle = endLineStyleIndex == -1 ? null : endExport.lineStyles.get(endLineStyleIndex);
                for (int a = 0; a < startExport.shapes.size(); ++a) {
                    double distance;
                    LINESTYLE2 startLineStyle;
                    int startFillStyleIndex = startExport.fillStyleIndices.get(a);
                    FILLSTYLE startFillStyle = startFillStyleIndex == -1 ? null : startExport.fillStyles.get(startFillStyleIndex);
                    int startLineStyleIndex = startExport.lineStyleIndices.get(a);
                    LINESTYLE2 lINESTYLE2 = startLineStyle = startLineStyleIndex == -1 ? null : startExport.lineStyles.get(startLineStyleIndex);
                    if ((endFillStyle != null || startFillStyle != null) && (startFillStyle == null || endFillStyle == null || !startFillStyle.isCompatibleFillStyle(endFillStyle, swf)) || (endLineStyle != null || startLineStyle != null) && (startLineStyle == null || endLineStyle == null || !startLineStyle.isCompatibleLineStyle(endLineStyle, swf)) || !((distance = startExport.centralPos.get(a).distance(endExport.centralPos.get(b))) < minDistance)) continue;
                    minDistance = distance;
                    selectedA = a;
                }
                if (selectedA == -1) {
                    throw new StyleMismatchException();
                }
                startShapeIndices.add(selectedA);
                endShapeIndices.add(b);
            }
        }
        for (int i2 = 0; i2 < startShapeIndices.size(); ++i2) {
            int a = (Integer)startShapeIndices.get(i2);
            int b = (Integer)endShapeIndices.get(i2);
            List<BezierEdge> shapeStart = Helper.deepCopy(startExport.shapes.get(a));
            this.split(shapeStart, startExport.pointsPosPercent.get(a), endExport.pointsPosPercent.get(b));
            List<BezierEdge> shapeEnd = Helper.deepCopy(endExport.shapes.get(b));
            this.split(shapeEnd, endExport.pointsPosPercent.get(b), startExport.pointsPosPercent.get(a));
            startBeziers.add(shapeStart);
            endBeziers.add(shapeEnd);
            if (startExport.fillStyleIndices.get(a) != -1) {
                startFillStyles.add(startExport.fillStyles.get(startExport.fillStyleIndices.get(a)));
            }
            startFillstyleIndices.add(startExport.fillStyleIndices.get(a));
            if (startExport.lineStyleIndices.get(a) != -1) {
                startLineStyles.add(startExport.lineStyles.get(startExport.lineStyleIndices.get(a)));
            }
            startLineStyleIndices.add(startExport.lineStyleIndices.get(a));
            if (endExport.fillStyleIndices.get(b) != -1) {
                endFillStyles.add(endExport.fillStyles.get(endExport.fillStyleIndices.get(b)));
            }
            if (endExport.lineStyleIndices.get(b) == -1) continue;
            endLineStyles.add(endExport.lineStyles.get(endExport.lineStyleIndices.get(b)));
        }
        ArrayList<SHAPERECORD> startRecords = new ArrayList<SHAPERECORD>();
        ArrayList<SHAPERECORD> endRecords = new ArrayList<SHAPERECORD>();
        MORPHFILLSTYLEARRAY morphFillStyleArray = new MORPHFILLSTYLEARRAY();
        morphFillStyleArray.fillStyles = new MORPHFILLSTYLE[startFillStyles.size()];
        MORPHLINESTYLEARRAY morphLineStyleArray = new MORPHLINESTYLEARRAY();
        morphLineStyleArray.lineStyles2 = new MORPHLINESTYLE2[startLineStyles.size()];
        for (i = 0; i < startFillStyles.size(); ++i) {
            FILLSTYLE fsEnd;
            FILLSTYLE fsStart = (FILLSTYLE)startFillStyles.get(i);
            MORPHFILLSTYLE morphFillStyle = fsStart.toMorphStyle(fsEnd = (FILLSTYLE)endFillStyles.get(i), swf);
            if (morphFillStyle == null) {
                throw new StyleMismatchException();
            }
            morphFillStyleArray.fillStyles[i] = morphFillStyle;
        }
        for (i = 0; i < endFillStyles.size(); ++i) {
            FILLSTYLE fsStart = (FILLSTYLE)startFillStyles.get(i);
            FILLSTYLE fsEnd = (FILLSTYLE)endFillStyles.get(i);
            if (!fsEnd.hasBitmap() || fsEnd.bitmapId == fsStart.bitmapId) continue;
            swf.removeTag(swf.getImage(fsEnd.bitmapId));
        }
        for (i = 0; i < startLineStyles.size(); ++i) {
            LINESTYLE2 lsEnd;
            LINESTYLE2 lsStart = (LINESTYLE2)startLineStyles.get(i);
            MORPHLINESTYLE2 morphLineStyle = lsStart.toMorphLineStyle2(lsEnd = (LINESTYLE2)endLineStyles.get(i), swf);
            if (morphLineStyle == null) {
                throw new StyleMismatchException();
            }
            morphLineStyleArray.lineStyles2[i] = morphLineStyle;
            if (morphLineStyle.noHScaleFlag || morphLineStyle.noVScaleFlag) {
                morphShape.usesNonScalingStrokes = true;
            }
            if (morphLineStyle.noHScaleFlag || morphLineStyle.noVScaleFlag) continue;
            morphShape.usesScalingStrokes = true;
        }
        for (i = 0; i < startLineStyles.size(); ++i) {
            LINESTYLE2 lsStart = (LINESTYLE2)startLineStyles.get(i);
            LINESTYLE2 lsEnd = (LINESTYLE2)endLineStyles.get(i);
            if (!lsEnd.hasFillFlag || !lsEnd.fillType.hasBitmap() || lsStart.fillType.bitmapId == lsEnd.fillType.bitmapId) continue;
            swf.removeTag(swf.getImage(lsEnd.fillType.bitmapId));
        }
        for (i = 0; i < startBeziers.size(); ++i) {
            List beList = (List)startBeziers.get(i);
            StyleChangeRecord scr = new StyleChangeRecord();
            scr.stateFillStyle0 = true;
            scr.fillStyle0 = (Integer)startFillstyleIndices.get(i) != -1 ? (Integer)startFillstyleIndices.get(i) + 1 : 0;
            scr.stateLineStyle = true;
            scr.lineStyle = (Integer)startLineStyleIndices.get(i) != -1 ? (Integer)startLineStyleIndices.get(i) + 1 : 0;
            startRecords.add(scr);
            BezierEdge firstBe = (BezierEdge)beList.get(0);
            StyleChangeRecord scrMove = new StyleChangeRecord();
            scrMove.stateMoveTo = true;
            scrMove.moveDeltaX = (int)Math.round(firstBe.getBeginPoint().getX());
            scrMove.moveDeltaY = (int)Math.round(firstBe.getBeginPoint().getY());
            startRecords.add(scrMove);
            for (BezierEdge be : beList) {
                SHAPERECORD rec = this.bezierToRecord(be);
                startRecords.add(rec);
            }
        }
        startRecords.add(new EndShapeRecord());
        for (i = 0; i < endBeziers.size(); ++i) {
            List beList = (List)endBeziers.get(i);
            BezierEdge firstBe = (BezierEdge)beList.get(0);
            StyleChangeRecord scrMove = new StyleChangeRecord();
            scrMove.stateMoveTo = true;
            scrMove.moveDeltaX = (int)Math.round(firstBe.getBeginPoint().getX());
            scrMove.moveDeltaY = (int)Math.round(firstBe.getBeginPoint().getY());
            endRecords.add(scrMove);
            for (BezierEdge be : beList) {
                SHAPERECORD rec = this.bezierToRecord(be);
                endRecords.add(rec);
            }
        }
        endRecords.add(new EndShapeRecord());
        morphShape.morphFillStyles = morphFillStyleArray;
        morphShape.morphLineStyles = morphLineStyleArray;
        morphShape.startEdges = new SHAPE();
        morphShape.startEdges.shapeRecords = startRecords;
        morphShape.startEdges.numFillBits = SWFOutputStream.getNeededBitsU(morphFillStyleArray.fillStyles.length);
        morphShape.startEdges.numLineBits = SWFOutputStream.getNeededBitsU(morphLineStyleArray.lineStyles2.length);
        morphShape.endEdges = new SHAPE();
        morphShape.endEdges.numFillBits = 0;
        morphShape.endEdges.numLineBits = 0;
        morphShape.endEdges.shapeRecords = endRecords;
        morphShape.setModified(true);
        morphShape.updateBounds();
    }

    private void split(List<BezierEdge> shape, List<Double> originalPointsPosPercent, List<Double> newPointPosPercent) {
        ArrayList<Double> pointPointsPercent = new ArrayList<Double>(originalPointsPosPercent);
        int nppPos = 0;
        for (int i = 0; i < shape.size() && nppPos < newPointPosPercent.size(); ++i) {
            BezierEdge be = shape.get(i);
            double pointPosPct = (Double)pointPointsPercent.get(i);
            double pointPosNextPct = (Double)pointPointsPercent.get(i + 1);
            double pct = newPointPosPercent.get(nppPos);
            if (pct > pointPosPct && pct < pointPosNextPct) {
                double deltaPct = pointPosNextPct - pointPosPct;
                double newPct = pct - pointPosPct;
                double insidePct = newPct / deltaPct;
                Reference<Object> leftRef = new Reference<Object>(null);
                Reference<Object> rightRef = new Reference<Object>(null);
                be.split(insidePct, leftRef, rightRef);
                shape.remove(i);
                shape.add(i, leftRef.getVal());
                shape.add(i + 1, rightRef.getVal());
                pointPointsPercent.add(i + 1, pct);
                ++nppPos;
                continue;
            }
            if (pct != pointPosPct) continue;
            ++nppPos;
            --i;
        }
    }

    private SHAPERECORD bezierToRecord(BezierEdge be) {
        if (be.points.size() == 2) {
            StraightEdgeRecord ser = new StraightEdgeRecord();
            ser.deltaX = (int)Math.round(be.points.get(1).getX() - be.points.get(0).getX());
            ser.deltaY = (int)Math.round(be.points.get(1).getY() - be.points.get(0).getY());
            ser.generalLineFlag = true;
            ser.simplify();
            return ser;
        }
        if (be.points.size() == 3) {
            CurvedEdgeRecord cer = new CurvedEdgeRecord();
            cer.controlDeltaX = (int)Math.round(be.points.get(1).getX() - be.points.get(0).getX());
            cer.controlDeltaY = (int)Math.round(be.points.get(1).getY() - be.points.get(0).getY());
            cer.anchorDeltaX = (int)Math.round(be.points.get(2).getX() - be.points.get(1).getX());
            cer.anchorDeltaY = (int)Math.round(be.points.get(2).getY() - be.points.get(1).getY());
            return cer;
        }
        return null;
    }
}

