/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers.morphshape;

import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.shape.ShapeExporterBase;
import com.jpexs.decompiler.flash.math.BezierEdge;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FOCALGRADIENT;
import com.jpexs.decompiler.flash.types.GRADIENT;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.helpers.Helper;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class ShapeForMorphExporter
extends ShapeExporterBase {
    public List<List<BezierEdge>> shapes = new ArrayList<List<BezierEdge>>();
    public List<Integer> fillStyleIndices = new ArrayList<Integer>();
    public List<Integer> lineStyleIndices = new ArrayList<Integer>();
    public List<List<Double>> pointsPosPercent = new ArrayList<List<Double>>();
    public List<Point2D.Double> centralPos = new ArrayList<Point2D.Double>();
    private final List<Point2D.Double> pointsSum = new ArrayList<Point2D.Double>();
    private final List<Integer> segmentCount = new ArrayList<Integer>();
    private final List<List<Double>> bezierLengths = new ArrayList<List<Double>>();
    private List<BezierEdge> currentShape = new ArrayList<BezierEdge>();
    private List<Double> currentBezierLengths = new ArrayList<Double>();
    private Point2D.Double currentPointsSum = new Point2D.Double();
    private int currentSegmentCount = 0;
    private int currentLineStyle = -1;
    private int currentFillStyle = -1;
    public List<FILLSTYLE> fillStyles = new ArrayList<FILLSTYLE>();
    public List<LINESTYLE2> lineStyles = new ArrayList<LINESTYLE2>();
    private double lastX = 0.0;
    private double lastY = 0.0;

    public ShapeForMorphExporter(ShapeTag shape) {
        super(0, shape.getShapeNum(), shape.getSwf(), shape.shapes, new ColorTransform());
    }

    @Override
    public void beginShape() {
        this.shapes = new ArrayList<List<BezierEdge>>();
    }

    @Override
    public void endShape() {
        List<BezierEdge> shape;
        int i;
        this.endCurrent();
        for (i = 0; i < this.segmentCount.size(); ++i) {
            Point2D.Double center = new Point2D.Double();
            center.x = this.pointsSum.get((int)i).x / (double)this.segmentCount.get(i).intValue();
            center.y = this.pointsSum.get((int)i).y / (double)this.segmentCount.get(i).intValue();
            this.centralPos.add(center);
        }
        for (i = 0; i < this.shapes.size(); ++i) {
            shape = this.shapes.get(i);
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
            BezierEdge be = null;
            for (int j = 0; j < shape.size(); ++j) {
                be = shape.get(j);
                points.add(new Point2D.Double(be.getBeginPoint().getX() - this.centralPos.get(i).getX(), be.getBeginPoint().getY() - this.centralPos.get(i).getY()));
            }
            points.add(new Point2D.Double(be.getEndPoint().getX() - this.centralPos.get(i).getX(), be.getEndPoint().getY() - this.centralPos.get(i).getY()));
            double w = 0.0;
            for (int j = 0; j < points.size(); ++j) {
                double yp1;
                int secondPoint = j + 1 == points.size() ? 0 : j + 1;
                double x = ((Point2D)points.get(j)).getX();
                double xp1 = ((Point2D)points.get(secondPoint)).getX();
                double y = ((Point2D)points.get(j)).getY();
                if (y * (yp1 = ((Point2D)points.get(secondPoint)).getY()) < 0.0) {
                    double r = x + y * (xp1 - x) / (y - yp1);
                    if (!(r > 0.0)) continue;
                    if (y < 0.0) {
                        w += 1.0;
                        continue;
                    }
                    w -= 1.0;
                    continue;
                }
                if (y == 0.0 && x > 0.0) {
                    if (yp1 > 0.0) {
                        w += 0.5;
                        continue;
                    }
                    w -= 0.5;
                    continue;
                }
                if (yp1 != 0.0 || !(xp1 > 0.0)) continue;
                if (y < 0.0) {
                    w += 0.5;
                    continue;
                }
                w -= 0.5;
            }
            if (w > 0.0) continue;
            ArrayList<BezierEdge> newShape = new ArrayList<BezierEdge>();
            ArrayList<Double> newBeLength = new ArrayList<Double>();
            for (int j = shape.size() - 1; j >= 0; --j) {
                newShape.add(shape.get(j).reverse());
                newBeLength.add(this.bezierLengths.get(i).get(j));
            }
            shape.clear();
            shape.addAll(newShape);
            this.bezierLengths.get(i).clear();
            this.bezierLengths.get(i).addAll(newBeLength);
        }
        for (i = 0; i < this.shapes.size(); ++i) {
            int j;
            shape = this.shapes.get(i);
            if (!shape.get(0).getBeginPoint().equals(shape.get(shape.size() - 1).getEndPoint())) continue;
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            for (int j2 = 0; j2 < shape.size(); ++j2) {
                if (shape.get(j2).getBeginPoint().getX() < minX) {
                    minX = shape.get(j2).getBeginPoint().getX();
                }
                if (!(shape.get(j2).getBeginPoint().getY() < minY)) continue;
                minY = shape.get(j2).getBeginPoint().getY();
            }
            double minDist = Double.MAX_VALUE;
            int minPos = -1;
            for (j = 0; j < shape.size(); ++j) {
                double dist = shape.get(j).getBeginPoint().distance(minX, minY);
                if (!(dist < minDist)) continue;
                minDist = dist;
                minPos = j;
            }
            if (minPos <= -1) continue;
            for (j = 0; j < minPos; ++j) {
                shape.add(shape.remove(0));
                this.bezierLengths.get(i).add(this.bezierLengths.get(i).remove(0));
            }
        }
        for (List<Double> pp : this.bezierLengths) {
            ArrayList<Double> ppPercent = new ArrayList<Double>();
            double len = 0.0;
            for (double bLength : pp) {
                len += bLength;
            }
            double pos = 0.0;
            for (double bLength : pp) {
                double pct = this.roundPct(pos / len);
                pos += bLength;
                ppPercent.add(pct);
            }
            ppPercent.add(1.0);
            this.pointsPosPercent.add(ppPercent);
        }
    }

    @Override
    public void beginFills() {
    }

    @Override
    public void endFills() {
        this.endCurrent();
    }

    @Override
    public void beginLines() {
        this.currentShape = null;
    }

    @Override
    public void endLines(boolean close) {
        this.endCurrent();
    }

    @Override
    public void beginFill(RGB color) {
        this.endCurrent();
        this.currentShape = new ArrayList<BezierEdge>();
        this.currentFillStyle = this.fillStyles.size();
        FILLSTYLE fillStyle = new FILLSTYLE();
        fillStyle.fillStyleType = 0;
        fillStyle.color = color;
        this.fillStyles.add(fillStyle);
    }

    @Override
    public void beginGradientFill(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        this.endCurrent();
        this.currentShape = new ArrayList<BezierEdge>();
        this.currentFillStyle = this.fillStyles.size();
        FILLSTYLE fillStyle = new FILLSTYLE();
        fillStyle.fillStyleType = type;
        fillStyle.gradient = focalPointRatio == 0.0f ? new GRADIENT() : new FOCALGRADIENT();
        fillStyle.gradient.gradientRecords = Helper.deepCopy(gradientRecords);
        fillStyle.gradientMatrix = matrix.toMATRIX();
        fillStyle.gradient.spreadMode = spreadMethod;
        fillStyle.gradient.interpolationMode = interpolationMethod;
        if (focalPointRatio != 0.0f) {
            ((FOCALGRADIENT)fillStyle.gradient).focalPoint = focalPointRatio;
        }
        this.fillStyles.add(fillStyle);
    }

    @Override
    public void beginBitmapFill(int bitmapId, Matrix matrix, boolean repeat, boolean smooth, ColorTransform colorTransform) {
        this.endCurrent();
        this.currentShape = new ArrayList<BezierEdge>();
        this.currentFillStyle = this.fillStyles.size();
        FILLSTYLE fillStyle = new FILLSTYLE();
        fillStyle.fillStyleType = repeat ? (smooth ? 64 : 66) : (smooth ? 65 : 67);
        fillStyle.bitmapMatrix = matrix.toMATRIX();
        fillStyle.bitmapId = bitmapId;
        this.fillStyles.add(fillStyle);
    }

    @Override
    public void endFill() {
        this.endCurrent();
    }

    private void endCurrent() {
        if (this.currentShape != null && !this.currentShape.isEmpty()) {
            this.shapes.add(this.currentShape);
            this.bezierLengths.add(this.currentBezierLengths);
            this.pointsSum.add(this.currentPointsSum);
            this.segmentCount.add(this.currentSegmentCount);
            this.fillStyleIndices.add(this.currentFillStyle);
            this.lineStyleIndices.add(this.currentLineStyle);
        }
        this.currentShape = new ArrayList<BezierEdge>();
        this.currentBezierLengths = new ArrayList<Double>();
        this.currentPointsSum = new Point2D.Double();
        this.currentSegmentCount = 0;
        this.currentFillStyle = -1;
        this.currentLineStyle = -1;
    }

    @Override
    public void lineStyle(double thickness, RGB color, boolean pixelHinting, String scaleMode, int startCaps, int endCaps, int joints, float miterLimit, boolean noClose) {
        this.endCurrent();
        this.currentLineStyle = this.lineStyles.size();
        LINESTYLE2 lineStyle = new LINESTYLE2();
        lineStyle.width = (int)thickness;
        lineStyle.color = color == null ? null : new RGBA(color);
        lineStyle.pixelHintingFlag = pixelHinting;
        switch (scaleMode) {
            case "NONE": {
                lineStyle.noHScaleFlag = true;
                lineStyle.noVScaleFlag = true;
                break;
            }
            case "VERTICAL": {
                lineStyle.noHScaleFlag = true;
                break;
            }
            case "HORIZONTAL": {
                lineStyle.noVScaleFlag = true;
            }
        }
        lineStyle.startCapStyle = startCaps;
        lineStyle.endCapStyle = endCaps;
        lineStyle.joinStyle = joints;
        lineStyle.miterLimitFactor = miterLimit;
        lineStyle.noClose = noClose;
        this.lineStyles.add(lineStyle);
    }

    @Override
    public void lineGradientStyle(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        LINESTYLE2 lineStyle = this.lineStyles.get(this.lineStyles.size() - 1);
        lineStyle.hasFillFlag = true;
        FILLSTYLE fillStyle = new FILLSTYLE();
        fillStyle.fillStyleType = type;
        fillStyle.gradient = focalPointRatio == 0.0f ? new FOCALGRADIENT() : new GRADIENT();
        fillStyle.gradient.gradientRecords = Helper.deepCopy(gradientRecords);
        fillStyle.gradientMatrix = matrix.toMATRIX();
        fillStyle.gradient.spreadMode = spreadMethod;
        fillStyle.gradient.interpolationMode = interpolationMethod;
        if (focalPointRatio != 0.0f) {
            ((FOCALGRADIENT)fillStyle.gradient).focalPoint = focalPointRatio;
        }
        lineStyle.fillType = fillStyle;
    }

    @Override
    public void lineBitmapStyle(int bitmapId, Matrix matrix, boolean repeat, boolean smooth, ColorTransform colorTransform) {
        LINESTYLE2 lineStyle = this.lineStyles.get(this.lineStyles.size() - 1);
        lineStyle.hasFillFlag = true;
        FILLSTYLE fillStyle = new FILLSTYLE();
        fillStyle.fillStyleType = repeat ? (smooth ? 64 : 66) : (smooth ? 65 : 67);
        fillStyle.bitmapMatrix = matrix.toMATRIX();
        fillStyle.bitmapId = bitmapId;
        lineStyle.fillType = fillStyle;
    }

    @Override
    public void moveTo(double x, double y) {
        int backupFillStyle = this.currentFillStyle;
        int backupLineStyle = this.currentLineStyle;
        this.endCurrent();
        this.currentFillStyle = backupFillStyle;
        this.currentLineStyle = backupLineStyle;
        this.lastX = (int)x;
        this.lastY = (int)y;
    }

    @Override
    public void lineTo(double x, double y) {
        if (x == this.lastX && y == this.lastY) {
            return;
        }
        BezierEdge be = new BezierEdge(this.lastX, this.lastY, x, y);
        this.currentPointsSum.x += x;
        this.currentPointsSum.y += y;
        this.currentShape.add(be);
        this.lastX = x;
        this.lastY = y;
        this.currentBezierLengths.add(be.length());
        ++this.currentSegmentCount;
    }

    @Override
    public void curveTo(double controlX, double controlY, double anchorX, double anchorY) {
        if (anchorX == this.lastX && anchorY == this.lastY) {
            return;
        }
        BezierEdge be = new BezierEdge(this.lastX, this.lastY, controlX, controlY, anchorX, anchorY);
        this.currentShape.add(be);
        this.currentPointsSum.x += anchorX;
        this.currentPointsSum.y += anchorY;
        this.lastX = anchorX;
        this.lastY = anchorY;
        this.currentBezierLengths.add(be.length());
        ++this.currentSegmentCount;
    }

    private double roundPct(double pct) {
        double precision = 1000000.0;
        return (double)Math.round(pct * precision) / precision;
    }
}

